/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.entity;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.kingdoms.libs.jetbrains.annotations.ApiStatus;
import org.kingdoms.libs.jetbrains.annotations.Unmodifiable;
import org.kingdoms.managers.entity.types.KingdomEntity;
import org.kingdoms.utils.internal.nonnull.NonNullMap;

public final class KingdomEntityRegistry {
    private static final Map<Entity, KingdomEntity> KINGDOM_MOBS = NonNullMap.of(new WeakHashMap());

    private KingdomEntityRegistry() {
    }

    public static KingdomEntity add(KingdomEntity entity2) {
        Objects.requireNonNull(entity2, "Cannot add null kingdom entity");
        return KINGDOM_MOBS.put(entity2.getEntity(), entity2);
    }

    public static KingdomEntity remove(LivingEntity entity2) {
        return KINGDOM_MOBS.remove(entity2);
    }

    public static @Unmodifiable Map<Entity, KingdomEntity> getEntities() {
        return Collections.unmodifiableMap(KINGDOM_MOBS);
    }

    public static boolean isKingdomEntity(LivingEntity entity2) {
        return entity2 != null && KINGDOM_MOBS.containsKey(entity2);
    }

    public static KingdomEntity get(Entity entity2) {
        return KINGDOM_MOBS.get(entity2);
    }

    @ApiStatus.Internal
    public static void removeAllKingdomMobs() {
        for (Entity entity2 : KINGDOM_MOBS.keySet()) {
            entity2.remove();
        }
        KINGDOM_MOBS.clear();
    }
}

