/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.daily.elections;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.Nation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.Rank;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.managers.daily.elections.ElectionCandidate;
import org.kingdoms.managers.daily.elections.ElectionResult;
import org.kingdoms.managers.daily.elections.ElectionsManager;
import org.kingdoms.utils.MathUtils;

public final class NationsElectionsManager
extends ElectionsManager {
    protected NationsElectionsManager() {
        super("nations");
    }

    @Override
    public void notifyPlayer(Player player) {
        Rank rank = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player).getRank();
        if (rank == null || !rank.isKing()) {
            return;
        }
        super.notifyPlayer(player);
    }

    @Override
    protected Messenger getJoinNotification() {
        return KingdomsLang.ELECTIONS_NATIONS_JOIN_NOTIFY;
    }

    @Override
    public void conclude() {
        HashMap<UUID, ElectionResult> topVotes = new HashMap<UUID, ElectionResult>();
        for (ElectionCandidate electionCandidate : this.candidates.values()) {
            Kingdom kingdom = Kingdom.getKingdom(electionCandidate.getId());
            if (!kingdom.hasNation()) continue;
            ElectionResult result = (ElectionResult)topVotes.get(kingdom.getNationId());
            if (result == null) {
                topVotes.put(kingdom.getNationId(), new ElectionResult(electionCandidate, kingdom.getNationId()));
                continue;
            }
            if (electionCandidate.getVotes().size() > result.getTopCandidate().getVotes().size()) {
                result.change(electionCandidate);
            }
            result.getTotalVotes().addAll(electionCandidate.getVotes());
        }
        for (Map.Entry entry : topVotes.entrySet()) {
            ElectionCandidate chosenCandidateDetails = ((ElectionResult)entry.getValue()).getTopCandidate();
            Kingdom chosenCandidate = Kingdom.getKingdom(chosenCandidateDetails.getId());
            Nation nation = Nation.getNation((UUID)entry.getKey());
            double votePercentage = this.getOption("vote-percentage").getDouble();
            double percent = MathUtils.getPercent(((ElectionResult)entry.getValue()).getTotalVotes().size(), nation.getMembers().size());
            KingdomsLang lang = percent < votePercentage ? KingdomsLang.ELECTIONS_RESULTS : KingdomsLang.ELECTIONS_NOT_ENOUGH_DATA;
            nation.setCapital(chosenCandidate);
            for (Player member : nation.getOnlineMembers()) {
                lang.sendMessage((CommandSender)member, "candidate", chosenCandidate.getName(), "votes", chosenCandidateDetails.getVotes().size(), "statement", chosenCandidateDetails.getStatement());
            }
        }
    }
}

