/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.daily.elections;

import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.config.accessor.KeyedConfigAccessor;
import org.kingdoms.config.implementation.YamlConfigAccessor;
import org.kingdoms.constants.group.Group;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.abstraction.ProlongedTask;
import org.kingdoms.managers.daily.TimeZoneHandler;
import org.kingdoms.managers.daily.elections.ElectionCandidate;
import org.kingdoms.managers.daily.elections.ElectionCandidateSortingStrategy;
import org.kingdoms.managers.daily.elections.NationsElectionsManager;
import org.kingdoms.scheduler.ScheduledTask;
import org.kingdoms.utils.internal.nonnull.NonNullMap;
import org.kingdoms.utils.internal.sorting.Sorter;

public abstract class ElectionsManager
extends ProlongedTask {
    protected final Map<UUID, ElectionCandidate> candidates = new NonNullMap<UUID, ElectionCandidate>();
    protected final Map<UUID, UUID> votes = new NonNullMap<UUID, UUID>();
    private ScheduledTask concludeTask;
    private final String name;

    protected ElectionsManager(String name) {
        super(Duration.ofDays(ElectionsManager.getOption(name, "interval").getInt()), TimeZoneHandler.DAILY_CHECKS, name + " Elections", new String[]{"prolonged-tasks", "elections", name}, null, true);
        this.name = name;
    }

    public KeyedConfigAccessor getOption(String name) {
        return ElectionsManager.getOption(this.name, name);
    }

    private static KeyedConfigAccessor getOption(String prefix, String name) {
        YamlConfigAccessor root = new YamlConfigAccessor(KingdomsConfig.MAIN.getConfig(), KingdomsConfig.MAIN.getDefaults());
        return root.get("daily-checks", "elections", prefix, name);
    }

    @Nullable
    public ElectionCandidate getCandidate(UUID id) {
        return this.candidates.get(id);
    }

    public void registerCandidate(UUID id, String statement) {
        this.candidates.put(id, new ElectionCandidate(id, statement));
    }

    public Map<UUID, ElectionCandidate> getCandidates() {
        return this.candidates;
    }

    public Map<UUID, UUID> getVotes() {
        return this.votes;
    }

    public UUID getVote(Player voter) {
        return this.votes.get(voter.getUniqueId());
    }

    public void vote(Player voter, UUID candidateId) {
        ElectionCandidate candidate = this.getCandidate(candidateId);
        Objects.requireNonNull(candidate, () -> "No candidate was registered with ID " + candidateId);
        UUID previouslyVotedCandidate = this.votes.put(voter.getUniqueId(), candidateId);
        if (previouslyVotedCandidate != null && previouslyVotedCandidate.equals(candidateId)) {
            return;
        }
        candidate.getVotes().add(voter.getUniqueId());
        if (previouslyVotedCandidate != null) {
            ElectionCandidate prevCandidate = this.getCandidate(previouslyVotedCandidate);
            prevCandidate.getVotes().remove(voter.getUniqueId());
        }
    }

    public boolean isAcceptingVotes() {
        return this.concludeTask != null;
    }

    public static boolean isEnabledFor(Group group) {
        if (group instanceof Kingdom) {
            Kingdom kingdom = (Kingdom)group;
            return kingdom.hasOwner();
        }
        return true;
    }

    public boolean isEnabled() {
        return this.getOption("enabled").getBoolean();
    }

    public boolean areKicksDisallowed() {
        return this.getOption("disallow-kicks").getBoolean();
    }

    @Override
    public void remind(String formattedTime) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void run() {
        KingdomsLang.ELECTIONS_BEGIN.sendEveryoneMessage(new Object[0]);
        this.concludeTask = Kingdoms.taskScheduler().async().delayed(this.getOption("duration").getTime(), () -> {
            this.conclude();
            this.concludeTask = null;
        });
    }

    public void notifyPlayer(Player player) {
        Group group;
        if (!this.isAcceptingVotes()) {
            return;
        }
        if (this.votes.containsKey(player.getUniqueId())) {
            return;
        }
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        Kingdom kingdom = kp.getKingdom();
        if (kingdom == null) {
            return;
        }
        if (this instanceof NationsElectionsManager) {
            if (!kingdom.hasNation()) {
                return;
            }
            group = kingdom.getNation();
        } else {
            group = kingdom;
        }
        if (!ElectionsManager.isEnabledFor(group)) {
            return;
        }
        this.getJoinNotification().sendMessage((CommandSender)player);
    }

    protected abstract Messenger getJoinNotification();

    public Sorter<ElectionCandidate> getCandidateSorter() {
        return ElectionCandidateSortingStrategy.valueOf(this.getOption("sort-by").getString());
    }

    public Duration getVotingAge() {
        return this.getOption("voting-age").getTime();
    }

    public abstract void conclude();
}

