/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.daily;

import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.Nation;
import org.kingdoms.constants.top.common.KingdomTopData;
import org.kingdoms.constants.top.common.NationTopData;
import org.kingdoms.data.centers.KingdomsDataCenter;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.utils.MathUtils;
import org.kingdoms.utils.internal.numbers.Numbers;

public final class TopRewardsManager {
    public static void rewardTopKingdoms() {
        int limit = KingdomsConfig.TOP_KINGDOMS_REWARDS_TOP.getInt();
        if (limit <= 0) {
            return;
        }
        String rp = KingdomsConfig.TOP_KINGDOMS_REWARDS_RESOURCE_POINTS.getString();
        String bank = KingdomsConfig.TOP_KINGDOMS_REWARDS_BANK.getString();
        KingdomTopData defaultTopData = KingdomsDataCenter.get().getKingdomManager().getTopData("default");
        List topKingdoms = defaultTopData.getTop(0, limit, defaultTopData.getPredicate());
        int ranking = 0;
        for (Kingdom kingdom : topKingdoms) {
            long rewardRp = (long)MathUtils.eval(rp, kingdom, "rank", ++ranking);
            double bankReward = MathUtils.eval(bank, kingdom, "rank", ranking);
            kingdom.getResourcePoints().add(rewardRp);
            kingdom.getBank().add(bankReward);
            Object[] edits = new Object[]{"rank", ranking, "money", Numbers.toFancyNumber(bankReward), "rp", Numbers.toFancyNumber(rewardRp)};
            for (Player member : kingdom.getOnlineMembers()) {
                KingdomsLang.TOP_REWARDS_KINGDOM.sendMessage((CommandSender)member, edits);
            }
        }
    }

    public static void rewardTopNations() {
        int limit = KingdomsConfig.TOP_NATIONS_REWARDS_TOP.getInt();
        if (limit <= 0) {
            return;
        }
        String rp = KingdomsConfig.TOP_NATIONS_REWARDS_RESOURCE_POINTS.getString();
        String bank = KingdomsConfig.TOP_NATIONS_REWARDS_BANK.getString();
        NationTopData defaultTopData = KingdomsDataCenter.get().getNationManager().getTopData("default");
        List topNations = defaultTopData.getTop(0, limit, defaultTopData.getPredicate());
        int ranking = 0;
        for (Nation nation : topNations) {
            long rewardRp = (long)MathUtils.eval(rp, nation, "rank", ++ranking);
            double bankReward = MathUtils.eval(bank, nation, "rank", ranking);
            nation.getResourcePoints().add(rewardRp);
            nation.getBank().add(bankReward);
            Object[] edits = new Object[]{"rank", ranking, "money", Numbers.toFancyNumber(bankReward), "rp", Numbers.toFancyNumber(rewardRp)};
            for (Player member : nation.getOnlineMembers()) {
                KingdomsLang.TOP_REWARDS_NATION.sendMessage((CommandSender)member, edits);
            }
        }
    }
}

