/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.chunkrestoration.path;

import java.time.Instant;
import java.util.Collection;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.managers.chunkrestoration.path.ChunkSnapshotEntry;
import org.kingdoms.managers.chunkrestoration.path.ChunkSnapshotFunctionalPath;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u000fJ\u0018\u0010\u0011\u001a\u0004\u0018\u00010\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u0014H\u0016R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u0015"}, d2={"Lorg/kingdoms/managers/chunkrestoration/path/ChunkSnapshotRangedTimedPath;", "Lorg/kingdoms/managers/chunkrestoration/path/ChunkSnapshotFunctionalPath;", "location", "Lorg/kingdoms/constants/land/location/SimpleChunkLocation;", "type", "Lorg/kingdoms/constants/namespace/Namespace;", "before", "Ljava/time/Instant;", "after", "<init>", "(Lorg/kingdoms/constants/land/location/SimpleChunkLocation;Lorg/kingdoms/constants/namespace/Namespace;Ljava/time/Instant;Ljava/time/Instant;)V", "getBefore", "()Ljava/time/Instant;", "getAfter", "isLatest", "", "isOldest", "match", "Lorg/kingdoms/managers/chunkrestoration/path/ChunkSnapshotEntry;", "entries", "", "core"})
public final class ChunkSnapshotRangedTimedPath
extends ChunkSnapshotFunctionalPath {
    @Nullable
    private final Instant before;
    @Nullable
    private final Instant after;

    public ChunkSnapshotRangedTimedPath(@NotNull SimpleChunkLocation location, @NotNull Namespace type, @Nullable Instant before, @Nullable Instant after) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        super(location, type);
        this.before = before;
        this.after = after;
    }

    @Nullable
    public final Instant getBefore() {
        return this.before;
    }

    @Nullable
    public final Instant getAfter() {
        return this.after;
    }

    public final boolean isLatest() {
        return this.before == null && this.after == null;
    }

    public final boolean isOldest() {
        return Intrinsics.areEqual((Object)this.before, (Object)Instant.EPOCH);
    }

    @Override
    @Nullable
    public ChunkSnapshotEntry match(@NotNull Collection<ChunkSnapshotEntry> entries) {
        Intrinsics.checkNotNullParameter(entries, (String)"entries");
        ChunkSnapshotEntry answer = null;
        for (ChunkSnapshotEntry entry : entries) {
            Instant timeTaken = entry.getTimeTaken();
            if (this.isLatest()) {
                if (answer == null) {
                    answer = entry;
                    continue;
                }
                if (!timeTaken.isAfter(answer.getTimeTaken())) continue;
                answer = entry;
                continue;
            }
            if (this.isOldest()) {
                if (answer == null) {
                    answer = entry;
                    continue;
                }
                if (!timeTaken.isBefore(answer.getTimeTaken())) continue;
                answer = entry;
                continue;
            }
            if (this.before != null && !timeTaken.isBefore(this.before) || this.after != null && !timeTaken.isAfter(this.after) || answer != null && !timeTaken.isAfter(answer.getTimeTaken())) continue;
            answer = entry;
        }
        return answer;
    }
}

