/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.chunkrestoration;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.bukkit.Bukkit;
import org.bukkit.block.data.BlockData;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.data.centers.KingdomsDataCenter;
import org.kingdoms.main.KLogger;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.chunkrestoration.ChunkSnapshot;
import org.kingdoms.managers.chunkrestoration.path.ChunkSnapshotEntry;
import org.kingdoms.managers.chunkrestoration.path.ChunkSnapshotExactTimedPath;
import org.kingdoms.managers.chunkrestoration.path.ChunkSnapshotFunctionalPath;
import org.kingdoms.managers.chunkrestoration.path.ChunkSnapshotPath;
import org.kingdoms.server.location.BlockVector3;
import org.kingdoms.utils.debugging.DebugNS;
import org.kingdoms.utils.debugging.KingdomsDebug;
import org.kingdoms.utils.time.TimeUtils;

public final class ChunkSnapshotManager {
    private static final DateTimeFormatter SNAPSHOT_FILE_DATE = DateTimeFormatter.ofPattern("yyyy-MM-dd HH-mm-ss").withZone(ZoneId.from(ZoneOffset.UTC));
    private static final int METHOD = 9;
    private static final Set<ChunkSnapshotFunctionalPath> CHUNK_RESTORATION_QUEUE = Collections.newSetFromMap(new ConcurrentHashMap());
    private static final Map<ChunkSnapshotPath, ChunkSnapshot> ACTIVE_RESTORING_CHUNKS = new ConcurrentHashMap<ChunkSnapshotPath, ChunkSnapshot>();
    private static final Set<ChunkSnapshotPath> SNAPSHOT_GENERATOR_QUEUE = new LinkedHashSet<ChunkSnapshotPath>();
    public static final Path DATA_FOLDER = KingdomsDataCenter.DATA_FOLDER.resolve("chunk-snapshots");
    private static final Queue<Runnable> SNAPSHOT_SAVE_QUEUE = new ConcurrentLinkedQueue<Runnable>();
    private static final BukkitTask QUERY_TASK = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)Kingdoms.get(), () -> {
        while (!SNAPSHOT_SAVE_QUEUE.isEmpty()) {
            Runnable operation = SNAPSHOT_SAVE_QUEUE.poll();
            operation.run();
        }
    }, 100L, 5L);

    public static void init() {
    }

    public static void saveSnapshot(ChunkSnapshot snapshot) {
        ChunkSnapshotExactTimedPath snapshotPath = snapshot.asPath();
        Path path = ChunkSnapshotManager.getSnapshotZipPath(snapshotPath);
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try (ZipOutputStream output = new ZipOutputStream(Files.newOutputStream(path, StandardOpenOption.WRITE, StandardOpenOption.CREATE), StandardCharsets.UTF_8);){
            output.setMethod(8);
            output.setLevel(9);
            ZipEntry entry = new ZipEntry(ChunkSnapshotManager.getSnapshotInternalFileName(snapshotPath));
            output.putNextEntry(entry);
            try (DataOutputStream fout = new DataOutputStream(output);){
                ChunkSnapshotManager.writeSnapshotData(fout, snapshot);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void writeSnapshotData(DataOutputStream fout, ChunkSnapshot snapshot) throws IOException {
        fout.writeByte(snapshot.getVersion());
        for (Map.Entry<BlockVector3, BlockData> block : snapshot.getBlocks().entrySet()) {
            BlockVector3 loc = block.getKey();
            fout.writeByte(loc.getX());
            fout.writeShort(loc.getY());
            fout.writeByte(loc.getZ());
            fout.writeUTF(block.getValue().getAsString(true));
        }
    }

    public static void finalizeSnapshotRestoration(ChunkSnapshot snapshot) {
        KLogger.debug((DebugNS)KingdomsDebug.CHUNK$SNAPSHOT, () -> "Snapshot restoration completed for: " + snapshot);
        ChunkSnapshotExactTimedPath path = snapshot.asPath();
        ChunkSnapshotManager.removeFromActiveRegeneration(path);
        ChunkSnapshotManager.deleteSnapshot(path);
        snapshot.getLocation().toChunk().removePluginChunkTicket((Plugin)Kingdoms.get());
    }

    public static void queueSnapshotGeneration(ChunkSnapshotPath path) {
        SNAPSHOT_GENERATOR_QUEUE.add(path);
    }

    public static boolean hasPendingSnapshotGeneration() {
        return !SNAPSHOT_GENERATOR_QUEUE.isEmpty();
    }

    public static ChunkSnapshotPath getNextPendingChunk() {
        Iterator<ChunkSnapshotPath> iterator = SNAPSHOT_GENERATOR_QUEUE.iterator();
        ChunkSnapshotPath next = iterator.next();
        iterator.remove();
        return next;
    }

    public static void queueRestoration(ChunkSnapshotFunctionalPath path) {
        CHUNK_RESTORATION_QUEUE.add(path);
    }

    public static boolean hasPendingRestorationQueue() {
        return !CHUNK_RESTORATION_QUEUE.isEmpty();
    }

    public static boolean hasActiveRestoration() {
        return !ACTIVE_RESTORING_CHUNKS.isEmpty();
    }

    public static boolean isBeingRestoredActively(ChunkSnapshotPath chunk) {
        return ACTIVE_RESTORING_CHUNKS.containsKey(chunk);
    }

    public static void removeFromActiveRegeneration(ChunkSnapshotPath snapshot) {
        ACTIVE_RESTORING_CHUNKS.remove(snapshot);
    }

    public static void restoreActively(ChunkSnapshot snapshot) {
        ACTIVE_RESTORING_CHUNKS.put(snapshot.asPath(), snapshot);
    }

    public static void queueSaveSnapshot(ChunkSnapshot snapshot) {
        if (ChunkSnapshotManager.loadSnapshot(snapshot.asPath()) == null) {
            SNAPSHOT_SAVE_QUEUE.add(() -> ChunkSnapshotManager.saveSnapshot(snapshot));
        }
    }

    public static ChunkSnapshot getSnapshot(ChunkSnapshotFunctionalPath path) {
        return ChunkSnapshotManager.loadSnapshot(path);
    }

    public static void finishTasks() {
        QUERY_TASK.cancel();
        while (!SNAPSHOT_SAVE_QUEUE.isEmpty()) {
            SNAPSHOT_SAVE_QUEUE.poll().run();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ChunkSnapshot loadSnapshot(ChunkSnapshotFunctionalPath snapshotPath) {
        Path path = ChunkSnapshotManager.getSnapshotZipPath(snapshotPath);
        if (!Files.exists(path, new LinkOption[0])) {
            return null;
        }
        try (ZipFile zipFile = new ZipFile(path.toFile());){
            Instant timeTaken;
            Object entry;
            ArrayList<ChunkSnapshotEntry> entries = new ArrayList<ChunkSnapshotEntry>(zipFile.size());
            Enumeration<? extends ZipEntry> enumerateEntries = zipFile.entries();
            while (enumerateEntries.hasMoreElements()) {
                entry = enumerateEntries.nextElement();
                try {
                    timeTaken = SNAPSHOT_FILE_DATE.parse((CharSequence)((ZipEntry)entry).getName(), Instant::from);
                }
                catch (DateTimeParseException ex) {
                    timeTaken = Instant.now();
                }
                entries.add(new ChunkSnapshotEntry(timeTaken, (ZipEntry)entry));
            }
            entry = snapshotPath.match(entries);
            if (entry == null) {
                timeTaken = null;
                return timeTaken;
            }
            InputStream stream = zipFile.getInputStream(((ChunkSnapshotEntry)entry).getZipEntry());
            ChunkSnapshot chunkSnapshot = ChunkSnapshotManager.loadSnapshotFromStream(snapshotPath, stream, ((ChunkSnapshotEntry)entry).getTimeTaken(), ((ChunkSnapshotEntry)entry).getZipEntry().getSize());
            return chunkSnapshot;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static ChunkSnapshot loadSnapshotFromStream(ChunkSnapshotPath snapshotPath, InputStream stream, Instant timeTaken, long size) {
        byte version = 1;
        HashMap<BlockVector3, BlockData> blocks = new HashMap<BlockVector3, BlockData>(size <= 0L ? 1000 : (int)(size / 4L));
        try {
            DataInputStream fin = new DataInputStream(stream);
            try {
                version = fin.readByte();
                while (true) {
                    byte x = fin.readByte();
                    short y = fin.readShort();
                    byte z = fin.readByte();
                    BlockData blockData = Bukkit.getServer().createBlockData(fin.readUTF());
                    blocks.put(BlockVector3.of(x, y, z), blockData);
                }
            }
            catch (Throwable throwable) {
                try {
                    fin.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (EOFException fin) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new ChunkSnapshot(snapshotPath.getLocation(), snapshotPath.getType(), timeTaken, version, blocks);
    }

    public static void deleteSnapshot(ChunkSnapshotPath path) {
        try {
            Files.delete(ChunkSnapshotManager.getSnapshotZipPath(path));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean hasSnapshot(ChunkSnapshotPath path) {
        return Files.exists(ChunkSnapshotManager.getSnapshotZipPath(path), new LinkOption[0]);
    }

    private static Path getSnapshotZipPath(ChunkSnapshotPath path) {
        SimpleChunkLocation chunk = path.getLocation();
        return DATA_FOLDER.resolve(chunk.getWorld()).resolve(chunk.getX() + ", " + chunk.getZ() + ".zip");
    }

    private static String getSnapshotInternalFileName(ChunkSnapshotExactTimedPath snapshot) {
        return SNAPSHOT_FILE_DATE.format(snapshot.getTime()) + ".chunk-snapshot";
    }

    static {
        Bukkit.getScheduler().runTaskTimer((Plugin)Kingdoms.get(), () -> {
            if (ChunkSnapshotManager.hasActiveRestoration()) {
                for (ChunkSnapshot snapshots : ACTIVE_RESTORING_CHUNKS.values()) {
                    if (!snapshots.restoreNextBlock()) continue;
                    ChunkSnapshotManager.finalizeSnapshotRestoration(snapshots);
                }
            }
        }, 100L, (long)KingdomsConfig.Claims.RESTORATION_BLOCK_RESTORATION_RATE.getManager().getInt());
        Bukkit.getScheduler().runTaskTimer((Plugin)Kingdoms.get(), () -> {
            if (ChunkSnapshotManager.hasPendingSnapshotGeneration()) {
                ChunkSnapshotPath next = ChunkSnapshotManager.getNextPendingChunk();
                ChunkSnapshot snapshot = ChunkSnapshot.generateFor(next);
                ChunkSnapshotManager.queueSaveSnapshot(snapshot);
                if (!ChunkSnapshotManager.hasPendingSnapshotGeneration()) {
                    KLogger.debug((DebugNS)KingdomsDebug.CHUNK$SNAPSHOT, "All chunk snapshots are completed.");
                }
            }
        }, 100L, 20L);
        int maxActiveChunks = KingdomsConfig.Claims.RESTORATION_MAX_ACTIVE_RESTORING_CHUNKS.getManager().getInt();
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)Kingdoms.get(), () -> {
            if (ACTIVE_RESTORING_CHUNKS.size() < maxActiveChunks && ChunkSnapshotManager.hasPendingRestorationQueue()) {
                Iterator<ChunkSnapshotFunctionalPath> iterator = CHUNK_RESTORATION_QUEUE.iterator();
                while (iterator.hasNext()) {
                    ChunkSnapshotFunctionalPath chunk = iterator.next();
                    if (ChunkSnapshotManager.isBeingRestoredActively(chunk)) continue;
                    ChunkSnapshot snapshot = ChunkSnapshotManager.getSnapshot(chunk);
                    if (snapshot != null) {
                        Bukkit.getScheduler().runTask((Plugin)Kingdoms.get(), () -> chunk.getLocation().toChunk().addPluginChunkTicket((Plugin)Kingdoms.get()));
                        ChunkSnapshotManager.restoreActively(snapshot);
                    }
                    iterator.remove();
                }
            }
        }, 100L, TimeUtils.toTicks(Duration.ofMinutes(1L)));
    }
}

