/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.chunkrestoration;

import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.libs.xseries.XBlock;
import org.kingdoms.libs.xseries.XTag;
import org.kingdoms.managers.chunkrestoration.ChunkLocationIterator;
import org.kingdoms.managers.chunkrestoration.path.ChunkSnapshotExactTimedPath;
import org.kingdoms.managers.chunkrestoration.path.ChunkSnapshotPath;
import org.kingdoms.server.location.BlockVector3;
import org.kingdoms.utils.versionsupport.VersionSupport;

final class ChunkSnapshot {
    public static final byte LATEST_VERSION = 1;
    private final Namespace type;
    private final SimpleChunkLocation location;
    private final Instant timeTaken;
    private final byte version;
    private final Map<BlockVector3, BlockData> blocks;
    private ChunkLocationIterator restorer;
    private static final List<XTag.Matcher<Object>> IGNORED_BLOCKS = XTag.stringMatcher(KingdomsConfig.Claims.RESTORATION_IGNORED_BLOCKS.getManager().getStringList(), null);

    public static ChunkSnapshot generateFor(ChunkSnapshotPath path) {
        return new ChunkSnapshot(path.getLocation(), path.getType(), Instant.now(), 1, ChunkSnapshot.parseBlocksOf(path.getLocation()));
    }

    public Namespace getType() {
        return this.type;
    }

    public ChunkSnapshot(SimpleChunkLocation location, Namespace type, Instant timeTaken, byte version, Map<BlockVector3, BlockData> blocks) {
        this.location = location;
        this.type = type;
        this.timeTaken = timeTaken;
        this.version = version;
        this.blocks = blocks;
    }

    private static Map<BlockVector3, BlockData> parseBlocksOf(SimpleChunkLocation location) {
        HashMap<BlockVector3, BlockData> blocks = new HashMap<BlockVector3, BlockData>(1000);
        World world = location.getBukkitWorld();
        int minHeight = VersionSupport.getMinWorldHeight(world);
        int maxHeight = world.getMaxHeight();
        ChunkLocationIterator iterator = new ChunkLocationIterator(minHeight, maxHeight);
        while (iterator.hasNext()) {
            BlockVector3 loc = iterator.next();
            Block block = location.getSimpleLocation(loc.getX(), loc.getY(), loc.getZ()).getBlock();
            if (XBlock.isAir((Material)block.getType())) continue;
            blocks.put(loc, block.getBlockData());
        }
        return blocks;
    }

    public boolean restoreNextBlock() {
        boolean noMore;
        World world = this.location.getBukkitWorld();
        if (!world.isChunkLoaded(this.location.getX(), this.location.getZ())) {
            return true;
        }
        if (this.restorer == null) {
            this.restorer = new ChunkLocationIterator(VersionSupport.getMinWorldHeight(world), world.getMaxHeight());
        }
        BlockVector3 blockLocation = this.restorer.next();
        Block block = this.location.getSimpleLocation(blockLocation.getX(), blockLocation.getY(), blockLocation.getZ()).getBlock();
        BlockData blockData = this.blocks.get(blockLocation);
        if (blockData == null) {
            block.setType(Material.AIR, false);
        } else {
            Material bukkitMaterial = blockData.getMaterial();
            if (XTag.anyMatch((Object)bukkitMaterial, IGNORED_BLOCKS)) {
                block.setType(Material.AIR, false);
            } else {
                block.setType(bukkitMaterial, false);
                block.setBlockData(blockData);
            }
        }
        boolean bl = noMore = !this.restorer.hasNext();
        if (noMore) {
            this.restorer = null;
        }
        return noMore;
    }

    public ChunkSnapshotExactTimedPath asPath() {
        return new ChunkSnapshotExactTimedPath(this.location, this.type, this.timeTaken);
    }

    public Instant getTimeTaken() {
        return this.timeTaken;
    }

    public byte getVersion() {
        return this.version;
    }

    public Map<BlockVector3, BlockData> getBlocks() {
        return this.blocks;
    }

    public SimpleChunkLocation getLocation() {
        return this.location;
    }

    public String toString() {
        return "ChunkSnapshot{location=" + this.location + ", type=" + this.type + ", timeTaken=" + this.timeTaken + ", version=" + this.version + ", blocks=" + this.blocks.size() + '}';
    }
}

