/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.chat;

import java.util.Optional;
import net.md_5.bungee.api.chat.ComponentBuilder;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.LanguageManager;
import org.kingdoms.locale.compiler.MessageObject;
import org.kingdoms.locale.compiler.builders.context.ComplexMessageBuilderContextProvider;
import org.kingdoms.locale.compiler.builders.context.HTMLMessageBuilderContextProvider;
import org.kingdoms.locale.compiler.builders.context.MessageBuilderContextProvider;
import org.kingdoms.locale.compiler.builders.context.PlainMessageBuilderContextProvider;
import org.kingdoms.locale.compiler.pieces.MessagePiece;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.services.managers.ServiceHandler;
import org.kingdoms.utils.PlayerUtils;

public class TagMessagePiece
extends MessagePiece {
    private final String name;

    public TagMessagePiece(String name) {
        this.name = name;
    }

    KingdomsLang getTagFormat(MessageBuilderContextProvider context) {
        OfflinePlayer taggedPlayer = PlayerUtils.getOfflinePlayer(this.name);
        if (taggedPlayer == null) {
            Optional<Player> ignoreCaseTag = Bukkit.getOnlinePlayers().stream().filter(x -> x.getName().equalsIgnoreCase(this.name)).findFirst();
            if (ignoreCaseTag.isPresent()) {
                taggedPlayer = (OfflinePlayer)ignoreCaseTag.get();
            } else {
                return KingdomsLang.TAGS_UNKNOWN_PLAYER;
            }
        }
        if (taggedPlayer.isOnline()) {
            Object receiver = context.getSettings().getSecondaryTarget();
            if (receiver instanceof OfflinePlayer && taggedPlayer.getUniqueId().equals(((OfflinePlayer)receiver).getUniqueId())) {
                return ServiceHandler.isIgnoring(taggedPlayer.getPlayer(), ((OfflinePlayer)receiver).getUniqueId()) ? KingdomsLang.TAGS_TAGGED_IGNORED : KingdomsLang.TAGS_TAGGED;
            }
            return KingdomsLang.TAGS_OTHERS;
        }
        return KingdomsLang.TAGS_OFFLINE;
    }

    @Override
    public void build(ComplexMessageBuilderContextProvider context) {
        KingdomsLang lang = this.getTagFormat(context);
        MessageObject format = lang.getMessageObject(LanguageManager.getDefaultLanguage());
        context.getSettings().parse("tag", this.name);
        format.build(context);
        context.newComponent(ComponentBuilder.FormatRetention.ALL);
        lang.getProvider(LanguageManager.getDefaultLanguage()).send((CommandSender)context.getSettings().getPrimaryTarget(), context.getSettings());
    }

    @Override
    public void build(PlainMessageBuilderContextProvider context) {
        MessageObject format = this.getTagFormat(context).getMessageObject(LanguageManager.getDefaultLanguage());
        MessagePlaceholderProvider settings = context.getSettings().parse("tag", this.name);
        String tag = format.buildPlain(settings);
        context.getCurrentLine().append(tag);
    }

    @Override
    public void build(HTMLMessageBuilderContextProvider context) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int jsonLength() {
        return this.length();
    }

    @Override
    public int length() {
        return this.name.length() + 2;
    }
}

