/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.buildings.turrets;

import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.kingdoms.abstraction.processor.KingdomsProcess;
import org.kingdoms.abstraction.processor.KingdomsProcessor;
import org.kingdoms.commands.general.building.CommandBuildingPreview;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.model.relationships.StandardRelationAttribute;
import org.kingdoms.constants.item.KingdomItemCreateSettings;
import org.kingdoms.constants.land.KingdomBuildingHandler;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.abstraction.KingdomBuilding;
import org.kingdoms.constants.land.abstraction.KingdomBuildingStyle;
import org.kingdoms.constants.land.abstraction.gui.KingdomItemGUIContext;
import org.kingdoms.constants.land.building.BuildingConstruction;
import org.kingdoms.constants.land.building.BuildingConstructionType;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.constants.land.structures.Structure;
import org.kingdoms.constants.land.structures.objects.Regulator;
import org.kingdoms.constants.land.turrets.Turret;
import org.kingdoms.constants.land.turrets.TurretRegistry;
import org.kingdoms.constants.land.turrets.TurretStyle;
import org.kingdoms.constants.land.turrets.TurretType;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.data.Pair;
import org.kingdoms.events.items.KingdomItemInteractEvent;
import org.kingdoms.events.items.KingdomItemPlaceContext;
import org.kingdoms.events.items.KingdomItemRemoveContext;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.xseries.XBlock;
import org.kingdoms.libs.xseries.XItemStack;
import org.kingdoms.libs.xseries.XMaterial;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.managers.buildings.KingdomBuildingManagerCommons;
import org.kingdoms.managers.buildings.limit.BuildingLimiter;
import org.kingdoms.managers.land.KingdomBuildingManager;
import org.kingdoms.managers.land.LandProtectionManager;
import org.kingdoms.managers.land.block.KingdomsBlockBreakContext;
import org.kingdoms.managers.land.block.KingdomsBlockInteractContext;
import org.kingdoms.managers.land.block.KingdomsBlockPlaceContext;
import org.kingdoms.managers.land.block.KingdomsBlockRepairContext;
import org.kingdoms.managers.land.block.KingdomsBlockUpgradeContext;
import org.kingdoms.permissions.KingdomsDefaultPluginPermission;
import org.kingdoms.server.location.Direction;
import org.kingdoms.utils.display.visualizer.StructureVisualizer;
import org.kingdoms.utils.internal.string.StringMatcher;
import org.kingdoms.utils.versionsupport.VersionSupport;

public final class TurretManager
implements KingdomBuildingHandler<Turret> {
    public static final Namespace NS = Namespace.kingdoms("TURRET");
    public static final TurretManager INSTANCE = new TurretManager();

    private TurretManager() {
    }

    public static boolean canBePlacedInWorld(KingdomBuilding<?> building, Player player) {
        StringMatcher matchers = StringMatcher.parseAndGroup(((KingdomBuildingStyle)building.getStyle()).getOption("disabled-worlds").getStringList());
        return !matchers.matches(player.getWorld().getName());
    }

    @Override
    public Messenger onPlace(@NotNull KingdomsBlockPlaceContext<Turret> context) {
        Messenger error;
        Land land = context.getLand();
        KingdomPlayer kp = context.getPlayer();
        Player player = kp.getPlayer();
        PlayerInteractEvent event = context.getCause();
        event.setCancelled(true);
        Block block = event.getClickedBlock().getRelative(event.getBlockFace());
        if (!XBlock.isAir((Material)block.getType())) {
            context.getMessageContext().parse("material", KingdomsLang.translate(XMaterial.matchXMaterial((Material)block.getType())));
            return KingdomsLang.TURRETS_BLOCK_OCCUPIED;
        }
        if (!kp.hasKingdom()) {
            return KingdomsLang.NO_KINGDOM_TURRETS_USE;
        }
        if (land == null || !land.isClaimed()) {
            return KingdomsLang.UNCLAIMED_PLACE_TURRETS;
        }
        Kingdom landKingdom = land.getKingdom();
        if (!KingdomsDefaultPluginPermission.TURRETS_BUILD_PLACE.hasPermission((CommandSender)player, true)) {
            boolean notRegulatored = true;
            Structure structure = land.getStructure(struct -> struct instanceof Regulator);
            if (structure != null) {
                Regulator regulator = (Regulator)structure;
                Boolean attr = regulator.hasAttribute(player.getUniqueId(), Regulator.Attribute.MANAGE_TURRETS);
                boolean bl = notRegulatored = attr == null || attr == false;
            }
            if (notRegulatored) {
                if (!kp.hasPermission(StandardKingdomPermission.TURRETS)) {
                    return StandardKingdomPermission.TURRETS.getDeniedMessage();
                }
                if (!StandardRelationAttribute.MANAGE_TURRETS.hasAttribute(kp.getKingdom(), landKingdom)) {
                    return KingdomsLang.OTHER_KINGDOMS_TURRET_PLACE;
                }
            }
        }
        SimpleLocation origin = SimpleLocation.of(block);
        Pair pairs = KingdomBuildingManager.getPairs(context, this);
        Turret turret = pairs.getKey();
        TurretStyle style = (TurretStyle)pairs.getValue();
        if (!TurretManager.canBePlacedInWorld(turret, player)) {
            return KingdomsLang.TURRETS_BLOCK_DISABLED_WORLD;
        }
        KingdomsProcessor limitProcessor = BuildingLimiter.ofTurrets(landKingdom, land).checkCanAddMore(style).process();
        if (!((BuildingLimiter)limitProcessor).isSuccessful()) {
            context.inherit(limitProcessor);
            return null;
        }
        if (!kp.isAdmin() && !style.canBePlacedInBiome(block.getLocation())) {
            return KingdomsLang.TURRETS_CANT_PLACE_IN_BIOME;
        }
        if (land.isKingdomBlock(origin.toBlockVector())) {
            return KingdomsLang.BUILDING_ALREADY_PLACED;
        }
        if (CommandBuildingPreview.isEnabled(player)) {
            KingdomBuildingManager.preview(player, turret);
            return null;
        }
        Direction direction = Direction.cardinalDirectionFromYaw(player.getLocation().getYaw()).getOppositeFace();
        if (!KingdomBuildingManager.validateAndPreview(player, turret, true)) {
            return KingdomsLang.BUILDING_ERRORS_MAIN;
        }
        if (!kp.isAdmin() && (error = KingdomBuildingManagerCommons.evaluateConditions(turret, "place")) != null) {
            return error;
        }
        context.addFinalizer(() -> {
            StructureVisualizer.stop(player, KingdomBuildingManager.PREVIEW_NS);
            KingdomItemPlaceContext placeCtx = new KingdomItemPlaceContext();
            placeCtx.setCause((Event)event);
            placeCtx.setPlayer(kp);
            placeCtx.setFromItem(event.getItem());
            placeCtx.setFacing(direction);
            turret.place(placeCtx);
        });
        return null;
    }

    @Override
    public Messenger onBreak(@NotNull KingdomsBlockBreakContext<Turret> context) {
        Messenger manualBreak;
        Messenger error;
        BuildingConstruction ctor;
        Turret turret = context.getBlock();
        Land land = context.getBlock().getLand();
        KingdomPlayer kp = context.getPlayer();
        Player player = kp.getPlayer();
        BlockBreakEvent event = context.getCause();
        if (!kp.isAdmin() && kp.hasKingdom() && !kp.hasPermission(StandardKingdomPermission.TURRETS)) {
            return StandardKingdomPermission.TURRETS.getDeniedMessage();
        }
        if (turret.getBuilding().isUnderConstruction() && (ctor = (BuildingConstruction)turret.getBuilding()).getType() == BuildingConstructionType.DEMOLISHING) {
            return KingdomsLang.BUILDING_ALREADY_BEING_DEMOLISHED;
        }
        if (!kp.isAdmin() && (error = KingdomBuildingManagerCommons.evaluateConditions(turret, "break")) != null) {
            return error;
        }
        if (!kp.isAdmin() && !KingdomsDefaultPluginPermission.TURRETS_BUILD_BREAK.hasPermission((CommandSender)player) && land != null && land.isClaimed()) {
            boolean notRegulatored = true;
            Structure structure = land.getStructure(struct -> struct instanceof Regulator);
            if (structure != null) {
                Regulator regulator = (Regulator)structure;
                Boolean attr = regulator.hasAttribute(player.getUniqueId(), Regulator.Attribute.MANAGE_TURRETS);
                boolean bl = notRegulatored = attr == null || attr == false;
            }
            if (notRegulatored) {
                Kingdom kingdom = kp.getKingdom();
                if (!StandardRelationAttribute.MANAGE_TURRETS.hasAttribute(kingdom, land.getKingdom())) {
                    event.setCancelled(true);
                    return KingdomsLang.OTHER_KINGDOMS_TURRET_BREAK;
                }
                if (kingdom != null && !kp.hasPermission(StandardKingdomPermission.TURRETS)) {
                    event.setCancelled(true);
                    return StandardKingdomPermission.TURRETS.getDeniedMessage();
                }
            }
        }
        if ((manualBreak = KingdomBuildingManagerCommons.handleManualBreak(context)) != null) {
            return manualBreak;
        }
        context.addFinalizer(() -> {
            KingdomItemGUIContext.closeForOthers(turret, kp.getId());
            StructureVisualizer.stop(player, KingdomBuildingManager.PREVIEW_NS);
            boolean toInv = KingdomsConfig.Turrets.TO_INVENTORY_ON_BREAK.getManager().getBoolean();
            KingdomItemRemoveContext ctx = new KingdomItemRemoveContext();
            ctx.setCause((Event)event);
            ctx.setPlayer(kp);
            ctx.setDropsItem(!toInv);
            if (turret.remove(ctx).isCancelled()) {
                return;
            }
            if (VersionSupport.SUPPORTS_BlockBreakEvent_setDropItems) {
                event.setDropItems(false);
            }
            Kingdom kingdom = land.getKingdom();
            if (toInv && ((TurretStyle)turret.getStyle()).hasItem()) {
                XItemStack.giveOrDrop((Player)player, (ItemStack[])new ItemStack[]{turret.getItem(new KingdomItemCreateSettings(kingdom, kp)).getItem()});
            }
        });
        return null;
    }

    @Override
    public Messenger onInteract(@NotNull KingdomsBlockInteractContext<Turret> context) {
        Messenger error;
        Turret turret = context.getBlock();
        Land land = context.getBlock().getLand();
        Player player = context.getPlayer().getPlayer();
        PlayerInteractEvent event = context.getCause();
        if (!context.isFunctionalPoint("interaction")) {
            return null;
        }
        if (player.isSneaking() && KingdomsConfig.Turrets.DISABLE_SHIFT_CLICK.getManager().getBoolean()) {
            Material type = player.getInventory().getItemInMainHand().getType();
            if (type == Material.AIR || !type.isBlock()) {
                event.setUseInteractedBlock(Event.Result.DENY);
            }
            return null;
        }
        event.setCancelled(true);
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        if (land.isClaimed() && !KingdomsDefaultPluginPermission.TURRETS_INTERACT.hasPermission((CommandSender)player, true)) {
            Kingdom kingdom = kp.getKingdom();
            if (!StandardRelationAttribute.MANAGE_TURRETS.hasAttribute(kingdom, land.getKingdom())) {
                return KingdomsLang.OTHER_KINGDOMS_TURRET_INTERACT;
            }
            if (kingdom != null && !kp.hasPermission(StandardKingdomPermission.TURRETS)) {
                return StandardKingdomPermission.TURRETS.getDeniedMessage();
            }
        }
        if (!land.isClaimed()) {
            context.message(KingdomsProcess.MessageType.INFO, KingdomsLang.OTHER_KINGDOMS_TURRET_CAN_TAKE);
        }
        if (turret.getBuilding().isUnderConstruction()) {
            return KingdomsLang.TURRETS_BUILDING_UNDER_CONSTRUCTION;
        }
        if (!kp.isAdmin() && (error = KingdomBuildingManagerCommons.evaluateConditions(turret, "interact")) != null) {
            return error;
        }
        context.addFinalizer(() -> {
            KingdomItemInteractEvent<Turret> interactEvent = new KingdomItemInteractEvent<Turret>(event, land, turret);
            Bukkit.getPluginManager().callEvent(interactEvent);
            if (interactEvent.isCancelled()) {
                return;
            }
            if (!land.isClaimed()) {
                LandProtectionManager.openKingdomItemGUI(player, turret, interactEvent);
                return;
            }
            ((TurretType)((TurretStyle)turret.getStyle()).getType()).open(new KingdomItemGUIContext<Turret>(interactEvent));
        });
        return null;
    }

    @Override
    public @NonNull Namespace getNamespace() {
        return NS;
    }

    @Override
    @Nullable
    public Messenger onRepair(@NotNull KingdomsBlockRepairContext<Turret> context) {
        return null;
    }

    @Override
    @Nullable
    public Messenger onUpgrade(@NotNull KingdomsBlockUpgradeContext<Turret> context) {
        Messenger error;
        Turret turret = context.getBlock();
        KingdomPlayer kp = context.getPlayer();
        Kingdom kingdom = turret.getLand().getKingdom();
        Kingdom upgradingKingdom = kp.getKingdom();
        int level = turret.getLevel();
        int upgradeCost = turret.getUpgradeCost(upgradingKingdom);
        if (level >= turret.getMaxLevel(kingdom)) {
            return KingdomsLang.TURRET_UPGRADE_MAX_LEVEL;
        }
        boolean admin = context.getPlayer().isAdmin();
        if (!admin && !upgradingKingdom.getResourcePoints().has(upgradeCost)) {
            return KingdomsLang.TURRET_UPGRADE_NOT_ENOUGH_RESOURCE_POINTS;
        }
        if (turret.getBuilding().isUnderConstruction()) {
            return KingdomsLang.TURRETS_BUILDING_UNDER_CONSTRUCTION;
        }
        if (!kp.isAdmin() && (error = KingdomBuildingManagerCommons.evaluateConditions(turret, "upgrade")) != null) {
            return error;
        }
        context.addFinalizer(() -> {
            if (turret.upgrade(context.getNewLevel(), upgradeCost, kp).isCancelled()) {
                return;
            }
            if (!admin) {
                upgradingKingdom.getResourcePoints().add(-upgradeCost);
            }
            KingdomsLang.TURRET_UPGRADE_UPGRADING.sendMessage((CommandSender)kp.getPlayer(), turret.getMessageContext());
            turret.playSound("upgrading");
            KingdomItemGUIContext.closeForOthers(turret, kp.getId());
            StructureVisualizer.stop(kp.getPlayer(), KingdomBuildingManager.PREVIEW_NS);
        });
        return null;
    }

    @NotNull
    public TurretRegistry getRegistry() {
        return TurretRegistry.get();
    }
}

