/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.buildings.turrets;

import java.util.Collection;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.abstraction.KingdomBuilding;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.constants.land.structures.objects.Regulator;
import org.kingdoms.constants.land.turrets.Turret;
import org.kingdoms.constants.land.turrets.TurretStyle;
import org.kingdoms.constants.land.turrets.TurretType;
import org.kingdoms.constants.land.turrets.objects.RangedTurret;
import org.kingdoms.events.general.KingdomDisbandEvent;
import org.kingdoms.events.items.KingdomBuildingFinishEvent;
import org.kingdoms.events.items.KingdomItemBreakEvent;
import org.kingdoms.events.items.KingdomItemPlaceEvent;
import org.kingdoms.events.lands.AsyncBatchLandLoadEvent;
import org.kingdoms.events.lands.ClaimLandEvent;
import org.kingdoms.events.lands.LandUnloadEvent;
import org.kingdoms.events.lands.UnclaimLandEvent;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;
import org.kingdoms.managers.buildings.turrets.TurretFactory;

public final class TurretLandCacheOptimizationWatcher
implements Listener {
    private static boolean hasValuableTurrets(Land land, @Nullable SimpleLocation ignoring) {
        for (Turret turret : land.getTurrets().values()) {
            if (ignoring != null && turret.getOrigin().equals(ignoring) || !turret.isEnabled() || turret.getBuilding() == null || turret.getBuilding().isUnderConstruction() || !((TurretType)((TurretStyle)turret.getStyle()).getType()).isRanged()) continue;
            return true;
        }
        return false;
    }

    public static void cache(Land land) {
        TurretFactory.getTurretLands().put(land.getLocation(), land);
    }

    public static void uncache(SimpleChunkLocation chunkLocation) {
        Land land = TurretFactory.getTurretLands().remove(chunkLocation);
        if (land != null) {
            for (Turret turret : land.getTurrets().values()) {
                if (!(turret instanceof RangedTurret)) continue;
                RangedTurret rangedTurret = (RangedTurret)turret;
                rangedTurret.invalidateStateCache();
            }
        }
    }

    public static void checked(Land land, Factor excluding) {
        for (Factor factor : Factor.FACTORS) {
            if (factor == excluding || !factor.check(land)) continue;
            return;
        }
        TurretLandCacheOptimizationWatcher.cache(land);
    }

    private static void checked(Collection<Land> lands, Factor excluding) {
        for (Land land : lands) {
            TurretLandCacheOptimizationWatcher.checked(land, excluding);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onLoad(AsyncBatchLandLoadEvent event) {
        TurretLandCacheOptimizationWatcher.checked(event.getLands(), null);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onLandClaim(ClaimLandEvent event) {
        TurretLandCacheOptimizationWatcher.checked(event.getLands(), Factor.CLAIMED);
    }

    private static void placedCheck(KingdomBuilding<?> building) {
        if (!(building instanceof Turret)) {
            return;
        }
        Turret turret = (Turret)building;
        if (!((TurretType)((TurretStyle)turret.getStyle()).getType()).isRanged()) {
            return;
        }
        if (turret.getBuilding().isUnderConstruction()) {
            return;
        }
        Land land = building.getLand();
        if (Factor.REGULATED.check(land)) {
            return;
        }
        TurretLandCacheOptimizationWatcher.cache(land);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onTurretPlace(KingdomItemPlaceEvent<Turret> event) {
        TurretLandCacheOptimizationWatcher.placedCheck((KingdomBuilding)event.getKingdomBlock());
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onTurretPlace(KingdomBuildingFinishEvent<Turret> event) {
        TurretLandCacheOptimizationWatcher.placedCheck(event.getBuilding());
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onTurretBreak(KingdomItemBreakEvent<?> event) {
        Land land = ((KingdomBuilding)event.getKingdomItem()).getLand();
        if (TurretLandCacheOptimizationWatcher.hasValuableTurrets(land, ((KingdomBuilding)event.getKingdomItem()).getOrigin())) {
            TurretLandCacheOptimizationWatcher.uncache(land.getLocation());
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onUnclaim(UnclaimLandEvent event) {
        for (SimpleChunkLocation loc : event.getLandLocations()) {
            TurretLandCacheOptimizationWatcher.uncache(loc);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onUnload(LandUnloadEvent event) {
        TurretLandCacheOptimizationWatcher.uncache(event.getLand().getLocation());
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onDisband(KingdomDisbandEvent event) {
        Kingdom kingdom = event.getKingdom();
        for (SimpleChunkLocation landLocation : kingdom.getLandLocations()) {
            TurretLandCacheOptimizationWatcher.uncache(landLocation);
        }
    }

    public static enum Factor {
        CLAIMED{

            @Override
            public boolean check(Land land) {
                return !land.isClaimed();
            }
        }
        ,
        REGULATED{

            @Override
            public boolean check(Land land) {
                Regulator regulator = land.getStructure(Regulator.class);
                if (regulator == null) {
                    return false;
                }
                return regulator.hasRule(Regulator.Rule.DISABLE_TURRETS);
            }
        }
        ,
        TURRET_CHECK{

            @Override
            public boolean check(Land land) {
                return !TurretLandCacheOptimizationWatcher.hasValuableTurrets(land, null);
            }
        };

        private static final Factor[] FACTORS;

        public abstract boolean check(Land var1);

        static {
            FACTORS = Factor.values();
        }
    }
}

