/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.buildings.turrets;

import org.bukkit.World;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.structures.objects.Regulator;
import org.kingdoms.constants.land.turrets.Turret;
import org.kingdoms.main.KLogger;
import org.kingdoms.managers.buildings.turrets.TurretFactory;
import org.kingdoms.managers.buildings.turrets.TurretTurretTaskHandler;
import org.kingdoms.utils.cache.single.CachedSupplier;

public class TurretIterationTaskHandler {
    protected final boolean g_debug;
    protected final KLogger logger;
    protected int totalHandledTurrets = 0;

    public TurretIterationTaskHandler(boolean gDebug, KLogger logger) {
        this.g_debug = gDebug;
        this.logger = logger;
    }

    public class TurretLandTaskHandler {
        protected final TurretIterationTaskHandler iteration;
        protected final Land land;
        protected CachedSupplier<Regulator> regulatable;
        protected Kingdom kingdom;
        protected World world;

        public TurretLandTaskHandler(TurretLandTaskHandler from) {
            this.iteration = TurretIterationTaskHandler.this;
            this.land = from.land;
            this.regulatable = from.regulatable;
            this.kingdom = from.kingdom;
            this.world = from.world;
        }

        public TurretLandTaskHandler(Land land) {
            this.iteration = TurretIterationTaskHandler.this;
            this.land = land;
        }

        public void handle() {
            Regulator regulator;
            this.kingdom = this.land.getKingdom();
            if (this.kingdom == null) {
                TurretIterationTaskHandler.this.logger.log("Land " + this.land + " which was registered as a turret-containing land, has a null kingdom");
                return;
            }
            this.regulatable = new CachedSupplier<Regulator>(() -> this.land.getStructure(Regulator.class));
            if (TurretFactory.debugTarget != null && (regulator = this.regulatable.get()) != null && regulator.hasRule(Regulator.Rule.DISABLE_TURRETS)) {
                if (this.land.getTurrets().containsKey(TurretFactory.debugTarget.toBlockVector())) {
                    TurretIterationTaskHandler.this.logger.log("The debug turret was in a land that contained a regulator that has disabled turrets.");
                }
                return;
            }
            this.world = this.land.getLocation().getBukkitWorld();
            for (Turret turret : this.land.unsafeGetTurrets().values()) {
                TurretTurretTaskHandler turretHandler = new TurretTurretTaskHandler(this, turret);
                turretHandler.handleTurret();
            }
        }
    }
}

