/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.buildings.turrets;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionType;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.config.accessor.ConfigAccessor;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.model.relationships.RelationAttribute;
import org.kingdoms.constants.group.model.relationships.StandardRelationAttribute;
import org.kingdoms.constants.land.KingdomBlock;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.abstraction.KingdomBuilding;
import org.kingdoms.constants.land.abstraction.KingdomBuildingStyle;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.constants.land.structures.Structure;
import org.kingdoms.constants.land.structures.objects.Regulator;
import org.kingdoms.constants.land.turrets.Turret;
import org.kingdoms.constants.land.turrets.TurretStyle;
import org.kingdoms.constants.land.turrets.TurretType;
import org.kingdoms.constants.land.turrets.effects.HypnosisTurretEffect;
import org.kingdoms.constants.land.turrets.effects.WeaknessTurretEffect;
import org.kingdoms.constants.land.turrets.objects.MineTurret;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.events.items.KingdomItemRemoveContext;
import org.kingdoms.events.items.turrets.TurretActivateEvent;
import org.kingdoms.libs.caffeine.cache.Cache;
import org.kingdoms.libs.xseries.XSound;
import org.kingdoms.locale.compiler.MessageCompiler;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.locale.placeholders.context.PlaceholderContextBuilder;
import org.kingdoms.locale.placeholders.context.PlaceholderProvider;
import org.kingdoms.locale.provider.MessageProvider;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.buildings.turrets.TurretEffectFactory;
import org.kingdoms.managers.buildings.turrets.TurretTask;
import org.kingdoms.managers.land.holograms.TemporaryBuildingVisuals;
import org.kingdoms.managers.pvp.PvPManager;
import org.kingdoms.platform.bukkit.adapters.BukkitAdapter;
import org.kingdoms.utils.MathUtils;
import org.kingdoms.utils.PlayerUtils;
import org.kingdoms.utils.cache.caffeine.CacheHandler;
import org.kingdoms.utils.config.ConfigSection;
import org.kingdoms.utils.hash.EntityHashMap;
import org.kingdoms.utils.hash.EntityWeakHashMap;

public final class TurretFactory
implements Listener {
    public static final Cache<Integer, TurretActivateEvent> DAMAGED = CacheHandler.newBuilder().expireAfterWrite(30L, TimeUnit.SECONDS).build();
    public static SimpleLocation debugTarget;
    protected static final Map<SimpleChunkLocation, Land> TURRET_LANDS;
    protected static final EntityWeakHashMap<Entity, BukkitTask> INVULNERABLE;
    public static final long UPDATE_TICKS;
    public static final long ACCURACY;
    public static final long DELAYED_SERVICE_START = 600L;
    private static boolean disabled;
    public static final boolean ALLOW_TARGETTING_NPCS;

    public static boolean isDisabled() {
        return disabled;
    }

    public static void setDisabled(boolean disable) {
        disabled = disable;
    }

    public static Map<SimpleChunkLocation, Land> getTurretLands() {
        return TURRET_LANDS;
    }

    @EventHandler(ignoreCancelled=true)
    public void onProjectileHit(ProjectileHitEvent event) {
        Projectile entity2 = event.getEntity();
        if (event.getHitBlock() != null && entity2.hasMetadata("TURRET_ORIGIN")) {
            entity2.remove();
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onTurretParalysis(ProjectileHitEvent event) {
        Block hitBlock;
        Land land;
        if (event.getHitBlock() == null) {
            return;
        }
        Projectile projectile = event.getEntity();
        ProjectileSource src = projectile.getShooter();
        if (!(src instanceof Player)) {
            return;
        }
        Player shooter = (Player)src;
        if (shooter.getGameMode() == GameMode.CREATIVE) {
            KingdomPlayer kingdomPlayer = KingdomPlayer.getKingdomPlayer((OfflinePlayer)shooter);
        }
        if ((land = Land.getLand(hitBlock = event.getHitBlock())) == null) {
            return;
        }
        KingdomBlock kingdomBlock = land.getKingdomBlocks().get(BukkitAdapter.adaptVector(hitBlock));
        if (kingdomBlock == null) {
            return;
        }
        if (!(kingdomBlock instanceof Turret) && !(kingdomBlock instanceof Structure)) {
            return;
        }
        KingdomBuilding building = (KingdomBuilding)kingdomBlock;
        ConfigAccessor _section = ((KingdomBuildingStyle)building.getStyle()).getOption("damaging-factors").getSection();
        if (_section == null) {
            return;
        }
        ConfigSection damagingFactors = _section.getSection();
        ConfigSection entityFactor = damagingFactors.getSection(projectile.getType().name());
        if (entityFactor == null) {
            return;
        }
        TurretEffectFactory effects = new TurretEffectFactory();
        if (projectile instanceof Arrow) {
            ConfigSection normalSection;
            Arrow arrow = (Arrow)projectile;
            List otherEffects = arrow.getCustomEffects();
            PotionType baseEffect = arrow.getBasePotionType();
            MessagePlaceholderProvider context = new MessagePlaceholderProvider();
            Float force = PvPManager.getChargedForce(projectile).orElse(Float.valueOf(1.0f));
            context.raw("force", force);
            if (baseEffect != null) {
                effects.parseEffects(baseEffect.getPotionEffects(), context, entityFactor);
            }
            effects.parseEffects(otherEffects, context, entityFactor);
            if (baseEffect == null && otherEffects.isEmpty() && (normalSection = entityFactor.getSection("normal")) != null) {
                effects.parseEffects(context, normalSection);
            }
        } else if (projectile instanceof ThrownPotion) {
            ThrownPotion potion = (ThrownPotion)projectile;
            effects.parseEffects(potion.getEffects(), new MessagePlaceholderProvider(), entityFactor);
        } else {
            effects.parseEffects(new MessagePlaceholderProvider(), entityFactor);
        }
        effects.applyEffects(projectile.getLocation(), building);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOW)
    public void onTurretDamage(EntityDamageByEntityEvent event) {
        if (!(event.getEntity() instanceof LivingEntity)) {
            return;
        }
        LivingEntity victim = (LivingEntity)event.getEntity();
        Entity damager = event.getDamager();
        List meta = damager.getMetadata("TURRET_ORIGIN");
        if (meta.isEmpty()) {
            DAMAGED.invalidate((Object)victim.getEntityId());
            return;
        }
        Turret turret = (Turret)((MetadataValue)meta.get(0)).value();
        Land land = turret.getLand();
        if (land == null) {
            return;
        }
        Kingdom kingdom = (Kingdom)((MetadataValue)damager.getMetadata("TURRET_KINGDOM").get(0)).value();
        if (turret.getLastActivation() != null && turret.getLastActivation().getTarget() != victim) {
            Kingdom owningEntityKingdom;
            if (victim instanceof Player) {
                KingdomPlayer kp = KingdomPlayer.getKingdomPlayer(victim.getUniqueId());
                owningEntityKingdom = kp.getKingdom();
            } else {
                Land entityLand = Land.getLand(victim.getLocation());
                owningEntityKingdom = entityLand == null ? null : entityLand.getKingdom();
            }
            boolean friendly = owningEntityKingdom != null && owningEntityKingdom.hasAttribute(kingdom, (RelationAttribute)StandardRelationAttribute.TURRET_CEASEFIRE);
            List<String> list = (friendly ? KingdomsConfig.Turrets.DISALLOW_ACCIDENTAL_MOB_DAMAGE_FRIENDLY : KingdomsConfig.Turrets.DISALLOW_ACCIDENTAL_MOB_DAMAGE_OTHERS).getManager().getStringList();
            if (list.contains(victim.getType().name())) {
                event.setCancelled(true);
                return;
            }
        }
        double damage = turret.getDamage(kingdom);
        Optional damageReduction = turret.getEffect(WeaknessTurretEffect.NS);
        if (damageReduction.isPresent()) {
            WeaknessTurretEffect effect = (WeaknessTurretEffect)damageReduction.get();
            damage -= MathUtils.eval(effect.getDamageReduction(), (PlaceholderProvider)new PlaceholderContextBuilder().raw("damage", damage));
        }
        turret.activate(victim, kingdom);
        event.setDamage(damage);
        TurretFactory.spawnTempHolograms((Entity)victim, turret);
    }

    private static void spawnTempHolograms(Entity victim, Turret turret) {
        if (victim instanceof Player) {
            Player player = (Player)victim;
            if (!turret.getVisualsManager().getVisibilityStrategy().isVisibleTo(player)) {
                TemporaryBuildingVisuals.spawn(player, turret);
            }
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onTeleport(PlayerTeleportEvent event) {
        int seconds = KingdomsConfig.Turrets.TELEPORTATION_INVULNERABILITY.getManager().getInt();
        if (seconds <= 0) {
            return;
        }
        final Player player = event.getPlayer();
        BukkitTask last = INVULNERABLE.put((Entity)player, new BukkitRunnable(){

            public void run() {
                INVULNERABLE.remove((Entity)player);
            }
        }.runTaskLater((Plugin)Kingdoms.get(), (long)seconds * 20L));
        if (last != null) {
            last.cancel();
        }
    }

    @EventHandler
    public void onTurretDropEXP(EntityDeathEvent event) {
        if (event.getEntityType() == EntityType.PLAYER) {
            return;
        }
        if (event.getDroppedExp() != 0) {
            return;
        }
        LivingEntity entity2 = event.getEntity();
        TurretActivateEvent turretEvent = (TurretActivateEvent)DAMAGED.getIfPresent((Object)entity2.getEntityId());
        if (turretEvent == null) {
            return;
        }
        ConfigAccessor exp = ((TurretStyle)turretEvent.getTurret().getStyle()).getOption("dropped-exp").getSection();
        if (exp == null) {
            return;
        }
        String eqn = exp.getString(entity2.getType().name());
        if (eqn == null) {
            return;
        }
        event.setDroppedExp((int)MathUtils.eval(eqn, turretEvent.getKingdom(), new Object[0]));
    }

    @EventHandler
    public void onTurretDeath(PlayerDeathEvent event) {
        Player player = event.getEntity();
        TurretActivateEvent turretEvent = (TurretActivateEvent)DAMAGED.getIfPresent((Object)player.getEntityId());
        if (turretEvent == null) {
            return;
        }
        Turret turret = turretEvent.getTurret();
        String deathMsg = turret.chooseDeathMessage();
        if (deathMsg == null) {
            return;
        }
        event.setDeathMessage(null);
        MessagePlaceholderProvider settings = turret.getMessageContext().withContext(player).other(turretEvent.getKingdom());
        MessageProvider msg = MessageCompiler.compile(deathMsg).getSimpleProvider();
        Bukkit.getOnlinePlayers().forEach(p -> msg.send((CommandSender)p, settings));
        msg.send((CommandSender)Bukkit.getConsoleSender(), settings);
    }

    public static boolean canAttack(Turret turret, Kingdom targetKingdom, Kingdom turretKingdom) {
        Optional hypnosis = turret.getEffect(HypnosisTurretEffect.NS);
        if (hypnosis.isPresent()) {
            return targetKingdom == turretKingdom;
        }
        return !StandardRelationAttribute.TURRET_CEASEFIRE.hasAttribute(targetKingdom, turretKingdom);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onMineStep(PlayerInteractEvent event) {
        if (event.getAction() != Action.PHYSICAL) {
            return;
        }
        Block block = event.getClickedBlock();
        if (!block.getType().name().endsWith("_PLATE")) {
            return;
        }
        Player victim = event.getPlayer();
        if (victim.isInvulnerable() || PlayerUtils.invulnerableGameMode(victim)) {
            return;
        }
        Land land = Land.getLand(block);
        if (land == null) {
            return;
        }
        Regulator regulator = land.getStructure(Regulator.class);
        if (regulator != null && regulator.hasRule(Regulator.Rule.DISABLE_TURRETS)) {
            return;
        }
        Turret turret = land.getTurrets().get(BukkitAdapter.adaptVector(block));
        if (turret == null) {
            return;
        }
        if (!turret.canFunction()) {
            return;
        }
        MineTurret mine = (MineTurret)turret;
        if (mine.getLastActivation() != null && mine.getLastActivation().getTime() > Duration.ofMillis(System.currentTimeMillis()).minusSeconds(10L).toMillis()) {
            return;
        }
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)victim);
        Kingdom kingdom = land.getKingdom();
        if (!TurretFactory.canAttack(turret, kp.getKingdom(), kingdom)) {
            return;
        }
        TurretActivateEvent activateEvent = new TurretActivateEvent((LivingEntity)victim, mine, kingdom, land, block.getLocation(), null, null);
        Bukkit.getPluginManager().callEvent((Event)activateEvent);
        mine.setLastActivation(activateEvent);
        if (activateEvent.isCancelled()) {
            return;
        }
        TurretFactory.spawnTempHolograms((Entity)victim, mine);
        mine.beeeeeeeeepbeeeeeeepbeeeeepbeeepbeepbeepbeep(XSound.BLOCK_NOTE_BLOCK_CHIME.record().withVolume(5.0f).withPitch(2.0f).publicSound(true).soundPlayer().atLocation(block.getLocation()), () -> {
            DAMAGED.put((Object)victim.getEntityId(), (Object)activateEvent);
            ((TurretType)((TurretStyle)mine.getStyle()).getType()).tryActivate(activateEvent);
            mine.playSound("activate");
            mine.setDurability(mine.getDurability() - 1.0);
            KingdomItemRemoveContext ctx = new KingdomItemRemoveContext();
            ctx.setDropsItem(false);
            ctx.setCause(activateEvent);
            if (mine.getDurability() <= 0.0) {
                mine.remove(ctx);
            }
        });
    }

    static {
        TURRET_LANDS = new ConcurrentHashMap<SimpleChunkLocation, Land>(100);
        INVULNERABLE = ((EntityHashMap.WeakBuilder)((EntityHashMap.WeakBuilder)EntityHashMap.weakBuilder(Entity.class).onDeath(EntityWeakHashMap::remove)).onLeave(EntityWeakHashMap::remove)).build();
        disabled = false;
        ALLOW_TARGETTING_NPCS = KingdomsConfig.Turrets.ALLOW_TARGETTING_NPCS.getManager().getBoolean();
        UPDATE_TICKS = KingdomsConfig.Turrets.UPDATE_TICKS.getManager().getLong();
        ACCURACY = KingdomsConfig.Turrets.ACCURACY.getManager().getLong();
        if (UPDATE_TICKS < 0L) {
            throw new IllegalArgumentException("Invalid turret update ticks: " + UPDATE_TICKS);
        }
        if (ACCURACY < 0L) {
            throw new IllegalArgumentException("Invalid turret accuracy ticks: " + ACCURACY);
        }
        new TurretTask().runTaskTimer((Plugin)Kingdoms.get(), 600L, UPDATE_TICKS);
    }
}

