/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.buildings.turrets;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.bukkit.Location;
import org.bukkit.potion.PotionEffect;
import org.kingdoms.constants.land.abstraction.KingdomBuilding;
import org.kingdoms.constants.land.turrets.Turret;
import org.kingdoms.constants.land.turrets.effects.DamageTurretEffect;
import org.kingdoms.constants.land.turrets.effects.HypnosisTurretEffect;
import org.kingdoms.constants.land.turrets.effects.ParalysisTurretEffect;
import org.kingdoms.constants.land.turrets.effects.SlownessTurretEffect;
import org.kingdoms.constants.land.turrets.effects.TurretEffect;
import org.kingdoms.constants.land.turrets.effects.WeaknessTurretEffect;
import org.kingdoms.data.Pair;
import org.kingdoms.libs.xseries.XSound;
import org.kingdoms.locale.messenger.DefaultedMessenger;
import org.kingdoms.locale.messenger.LanguageEntryMessenger;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.locale.placeholders.context.PlaceholderProvider;
import org.kingdoms.utils.MathUtils;
import org.kingdoms.utils.compilers.expressions.MathExpression;
import org.kingdoms.utils.config.ConfigSection;
import org.kingdoms.utils.nms.HologramFactory;
import org.kingdoms.utils.time.TimeUtils;

public final class TurretEffectFactory {
    private final List<Pair<TurretEffect, MessagePlaceholderProvider>> effects = new ArrayList<Pair<TurretEffect, MessagePlaceholderProvider>>();

    public void parseEffects(Collection<PotionEffect> effectsList, MessagePlaceholderProvider context, ConfigSection entityFactor) {
        for (PotionEffect effect : effectsList) {
            ConfigSection effectsSection = entityFactor.getSection(effect.getType().getKey().getKey().toUpperCase(Locale.ENGLISH));
            if (effectsSection == null) continue;
            context.raw("effect_lvl", effect.getAmplifier() + 1).raw("effect_duration", TimeUtils.fromTicks(effect.getDuration()));
            this.parseEffects(context, effectsSection);
        }
    }

    public TurretEffectFactory parseEffects(MessagePlaceholderProvider context, ConfigSection section) {
        ConfigSection slowness;
        ConfigSection weakness;
        MathExpression hypnosis;
        MathExpression paralysis;
        if (section == null) {
            return this;
        }
        MathExpression dmg = section.getMathExpression("damage");
        if (!dmg.isDefault()) {
            double eval = MathUtils.eval(dmg, (PlaceholderProvider)context);
            this.addEffect(new DamageTurretEffect(eval), context);
        }
        if (!(paralysis = section.getMathExpression("paralyze")).isDefault()) {
            this.addEffect(new ParalysisTurretEffect(Duration.ofMillis((long)MathUtils.eval(paralysis, (PlaceholderProvider)context))), context);
        }
        if (!(hypnosis = section.getMathExpression("hypnotize")).isDefault()) {
            this.addEffect(new HypnosisTurretEffect(Duration.ofMillis((long)MathUtils.eval(hypnosis, (PlaceholderProvider)context))), context);
        }
        if ((weakness = section.getSection("weakness")) != null) {
            Duration duration = Duration.ofMillis((long)MathUtils.eval(weakness.getMathExpression("duration"), (PlaceholderProvider)context));
            MathExpression dmgReduction = MathUtils.partialEval(weakness.getMathExpression("damage-reduction"), context);
            this.addEffect(new WeaknessTurretEffect(dmgReduction, duration), context);
        }
        if ((slowness = section.getSection("slowness")) != null) {
            Duration duration = Duration.ofMillis((long)MathUtils.eval(slowness.getMathExpression("duration"), (PlaceholderProvider)context));
            MathExpression delay = MathUtils.partialEval(slowness.getMathExpression("delay"), context);
            this.addEffect(new SlownessTurretEffect(delay, duration), context);
        }
        return this;
    }

    private void addEffect(TurretEffect effect, MessagePlaceholderProvider context) {
        this.effects.add(Pair.of(effect, context));
        effect.addMessageContextEdits(context);
    }

    public void applyEffects(Location impactLocation, KingdomBuilding<?> building) {
        double hologramHeightOffset = 0.0;
        for (Pair<TurretEffect, MessagePlaceholderProvider> effect : this.effects) {
            DefaultedMessenger msgEntry = new LanguageEntryMessenger("turrets", "effects", effect.getKey().getNamespace().getConfigOptionName()).safe();
            HologramFactory.spawn(impactLocation.clone().add(0.0, hologramHeightOffset, 0.0), msgEntry.parse(effect.getValue()));
            hologramHeightOffset += 0.3;
            XSound.Record sound = effect.getKey().getSound();
            if (sound != null) {
                sound.copy().withVolume(1.0f).publicSound(true).soundPlayer().atLocation(impactLocation).play();
            }
            effect.getKey().getParticles().forEach(x -> x.copy().withLocation(impactLocation).spawn());
            if (building instanceof Turret) {
                ((Turret)building).addEffect(effect.getKey());
                continue;
            }
            effect.getKey().apply(building);
        }
    }

    public List<Pair<TurretEffect, MessagePlaceholderProvider>> getEffects() {
        return this.effects;
    }
}

