/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.buildings.structures;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Group;
import org.kingdoms.constants.group.Nation;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.constants.player.KingdomPermission;
import org.kingdoms.constants.player.KingdomPermissionRegistry;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.Rank;
import org.kingdoms.constants.player.RankMap;
import org.kingdoms.events.general.ranks.PlayerRankChangeContext;
import org.kingdoms.events.general.ranks.RankColorChangeEvent;
import org.kingdoms.events.general.ranks.RankCreateEvent;
import org.kingdoms.events.general.ranks.RankDeleteEvent;
import org.kingdoms.events.general.ranks.RankIdentifier;
import org.kingdoms.events.general.ranks.RankMaterialChangeEvent;
import org.kingdoms.events.general.ranks.RankMaxClaimsChangeEvent;
import org.kingdoms.events.general.ranks.RankNameChangeEvent;
import org.kingdoms.events.general.ranks.RankPermissionChangeEvent;
import org.kingdoms.events.general.ranks.RankPriorityChangeEvent;
import org.kingdoms.events.general.ranks.RankSymbolChangeEvent;
import org.kingdoms.gui.GUIAccessor;
import org.kingdoms.gui.GUIBuilder;
import org.kingdoms.gui.InteractiveGUI;
import org.kingdoms.gui.KingdomsGUI;
import org.kingdoms.gui.OptionHandler;
import org.kingdoms.gui.ReusableOptionHandler;
import org.kingdoms.gui.pagination.GUIPagination;
import org.kingdoms.libs.xseries.XMaterial;
import org.kingdoms.libs.xseries.XTag;
import org.kingdoms.libs.xseries.base.XBase;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.compiler.MessageCompiler;
import org.kingdoms.locale.compiler.MessageCompilerSettings;
import org.kingdoms.locale.compiler.MessageObject;
import org.kingdoms.locale.compiler.pieces.MessagePiece;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.utils.config.ConfigSection;
import org.kingdoms.utils.internal.enumeration.OrderedSet;
import org.kingdoms.utils.string.Strings;

public final class RankEditor {
    private final Player player;
    private final KingdomPlayer kp;
    private final Rank rank;
    private final Group group;
    private final Consumer<InteractiveGUI> ranksGUIEditor;
    private final KingdomsGUI ranksGUIPath;
    private final String rootGUIPath;

    public RankEditor(Player player, Rank rank, Group group, Consumer<InteractiveGUI> ranksGUIEditor, KingdomsGUI ranksGUIPath) {
        this.player = player;
        this.kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        this.rank = rank;
        this.group = group;
        this.ranksGUIEditor = ranksGUIEditor;
        this.ranksGUIPath = ranksGUIPath;
        this.rootGUIPath = group instanceof Nation ? "structures/nexus/nation/ranks/" : "structures/nexus/ranks/";
    }

    public static MessagePlaceholderProvider getRankEdits(Rank rank) {
        return new MessagePlaceholderProvider().raw("rank_node", rank.getNode()).raw("rank_priority", rank.getPriority()).raw("rank_max_claims", rank.getMaxClaims()).raw("rank_material", rank.getMaterial().toString()).parse("rank_symbol", rank.getSymbol()).parse("rank_name", rank.getName()).parse("rank_color", rank.getColor());
    }

    public static XMaterial randomMaterial() {
        XMaterial mat;
        Material material;
        ThreadLocalRandom random = ThreadLocalRandom.current();
        while ((material = (mat = XMaterial.VALUES[random.nextInt(0, XMaterial.VALUES.length)]).parseMaterial()) == null || XTag.INVENTORY_NOT_DISPLAYABLE.isTagged((XBase)XMaterial.matchXMaterial((Material)material))) {
        }
        return mat;
    }

    public static Rank createNewRank(RankMap ranks, boolean nation) {
        String node = KingdomsConfig.Ranks.NEW_RANK_NODE.getManager().getString();
        int i = 0;
        while (ranks.has(node)) {
            node = "node (" + ++i + ')';
        }
        String name = KingdomsConfig.Ranks.NEW_RANK_NAME.getManager().getString();
        String color = KingdomsConfig.Ranks.NEW_RANK_COLOR.getManager().getString();
        String symbol = KingdomsConfig.Ranks.NEW_RANK_SYMBOL.getManager().getString();
        int maxClaims = KingdomsConfig.Ranks.NEW_RANK_MAX_CLAIMS.getManager().getInt();
        List<String> permissions = KingdomsConfig.Ranks.NEW_RANK_PERMISSIONS.getManager().getStringList();
        Set<KingdomPermission> perms = !permissions.isEmpty() && permissions.get(0).equals("@MEMBER") ? (nation ? new HashSet<KingdomPermission>() : ranks.getLowestRank().copyPermissions()) : KingdomPermissionRegistry.parse(permissions);
        String materialName = KingdomsConfig.Ranks.NEW_RANK_MATERIAL.getManager().getString();
        XMaterial material = materialName.equalsIgnoreCase("random") ? RankEditor.randomMaterial() : XMaterial.matchXMaterial((String)materialName).orElse(XMaterial.DIRT);
        int priority = ranks.size();
        return new Rank(node, name, color, symbol, material, priority, maxClaims, perms);
    }

    protected static InteractiveGUI openRanks(KingdomsGUI guiPath, Player player, KingdomPlayer kp, Group group, Consumer<InteractiveGUI> editor) {
        InteractiveGUI ranks = GUIAccessor.prepare(player, guiPath, new MessagePlaceholderProvider().withContext(kp.getOfflinePlayer()));
        ranks.push("add", () -> {
            int limit;
            int size = group.getRanks().size();
            if (size >= (limit = KingdomsConfig.Ranks.CUSTOM_RANKS_LIMITS_RANKS.getManager().getInt())) {
                KingdomsLang.NEXUS_RANK_EDITOR_MAX.sendMessage((CommandSender)player, "limit", limit);
                return;
            }
            Rank rank = RankEditor.createNewRank(group.getRanks(), false);
            Kingdoms.taskScheduler().async().execute(() -> {
                RankCreateEvent event = new RankCreateEvent(rank, group, kp);
                Bukkit.getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    return;
                }
                group.getRanks().add(rank);
                new RankEditor(player, rank, group, editor, guiPath).openRankEditor(innerGUI -> innerGUI.push("back", () -> RankEditor.openRanks(guiPath, player, kp, group, editor), new Object[0]));
            });
        }, new Object[0]).push("reset", () -> {
            InteractiveGUI gui = GUIAccessor.prepare(player, "confirm/ranks/reset");
            if (gui == null) {
                return;
            }
            gui.push("confirm", () -> {
                group.setRanks(Rank.copyDefaults(group));
                RankEditor.openRanks(guiPath, player, kp, group, editor);
            }, new Object[0]).push("cancel", () -> ((Player)player).closeInventory(), new Object[0]);
            gui.open();
        }, new Object[0]).push("demote-all", () -> {
            InteractiveGUI gui = GUIAccessor.prepare(player, "confirm/ranks/demote-all");
            if (gui == null) {
                return;
            }
            gui.push("confirm", () -> {
                KingdomPlayer byPlayer = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
                PlayerRankChangeContext rankContext = new PlayerRankChangeContext(group, RankIdentifier.defaultRank());
                rankContext.setByPlayer(byPlayer);
                boolean isNation = group instanceof Nation;
                for (KingdomPlayer member : group.getKingdomPlayers()) {
                    Rank currentRank = isNation ? member.getNationRank() : member.getRank();
                    if (currentRank.isKing()) continue;
                    member.changeRank(rankContext);
                }
                RankEditor.openRanks(guiPath, player, kp, group, editor);
            }, new Object[0]).push("cancel", () -> ((Player)player).closeInventory(), new Object[0]);
            gui.open();
        }, new Object[0]);
        ReusableOptionHandler holder = ranks.getReusableOption("rank");
        if (holder != null) {
            for (Rank rank : group.getRanks()) {
                holder.getMessageContext().addAll((Map)RankEditor.getRankEdits(rank).getPlaceholders());
                ((ReusableOptionHandler)holder.editItem(item -> rank.getMaterial().setType(item))).onNormalClicks(() -> new RankEditor(player, rank, group, editor, guiPath).openRankEditor(innerGUI -> innerGUI.push("back", () -> RankEditor.openRanks(guiPath, player, kp, group, editor), new Object[0]))).done();
            }
        }
        editor.accept(ranks);
        ranks.open();
        return ranks;
    }

    public InteractiveGUI openRankEditor(Consumer<InteractiveGUI> editor) {
        boolean king = this.rank.isKing();
        boolean nation = this.group instanceof Nation;
        KingdomsGUI path = nation ? (king ? KingdomsGUI.STRUCTURES_NEXUS_NATION_RANKS_KING$RANK$EDITOR : KingdomsGUI.STRUCTURES_NEXUS_NATION_RANKS_RANK$EDITOR) : (king ? KingdomsGUI.STRUCTURES_NEXUS_RANKS_KING$RANK$EDITOR : KingdomsGUI.STRUCTURES_NEXUS_RANKS_RANK$EDITOR);
        return this.openRankEditor(path, editor);
    }

    public InteractiveGUI openRankEditor(KingdomsGUI guiPath, Consumer<InteractiveGUI> editor) {
        InteractiveGUI gui = GUIAccessor.prepare(this.player, guiPath, RankEditor.getRankEdits(this.rank).withContext(this.kp.getOfflinePlayer()));
        gui.push("node", () -> {
            KingdomsLang.NEXUS_RANK_EDITOR_ENTER_VALUE.sendMessage((CommandSender)this.player);
            gui.startConversation("node");
        }, input -> {
            if (!Strings.isEnglish(input)) {
                KingdomsLang.NEXUS_RANK_EDITOR_INVALID_NODE.sendError((CommandSender)this.player, new Object[0]);
                return;
            }
            int limit = KingdomsConfig.Ranks.CUSTOM_RANKS_LIMITS_LENGTH_NODE.getManager().getInt();
            if (input.length() > limit) {
                KingdomsLang.NEXUS_RANK_EDITOR_LENGTH_NODE.sendError((CommandSender)this.player, "limit", limit);
                return;
            }
            if (this.group.getRanks().has((String)input)) {
                KingdomsLang.NEXUS_RANK_EDITOR_NODE_ALREADY_EXISTS.sendError((CommandSender)this.player, new Object[0]);
                return;
            }
            this.group.updateRankNode(this.rank.getNode(), (String)input);
            this.openRankEditor(guiPath, editor);
            gui.endConversation();
        }, new Object[0]).push("name", () -> {
            KingdomsLang.NEXUS_RANK_EDITOR_ENTER_VALUE.sendMessage((CommandSender)this.player);
            gui.startConversation("name");
        }, input -> {
            int limit = KingdomsConfig.Ranks.CUSTOM_RANKS_LIMITS_LENGTH_NAME.getManager().getInt();
            if (input.length() > limit) {
                KingdomsLang.NEXUS_RANK_EDITOR_LENGTH_NAME.sendMessage((CommandSender)this.player, "limit", limit);
                return;
            }
            KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)this.player);
            RankNameChangeEvent event = new RankNameChangeEvent(this.rank, this.group, kp, (String)input);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            this.rank.setName(event.getNewName());
            this.openRankEditor(guiPath, editor);
            gui.endConversation();
        }, new Object[0]).push("color", () -> {
            KingdomsLang.NEXUS_RANK_EDITOR_ENTER_VALUE.sendMessage((CommandSender)this.player);
            gui.startConversation("color");
        }, input -> {
            int limit = KingdomsConfig.Ranks.CUSTOM_RANKS_LIMITS_LENGTH_COLOR.getManager().getInt();
            MessageObject compiled = MessageCompiler.compile(input, new MessageCompilerSettings(false, true, true, false, false, null));
            if (compiled.hasPiece(piece -> !(piece instanceof MessagePiece.SimpleColor) && !(piece instanceof MessagePiece.HexColor))) {
                KingdomsLang.NEXUS_RANK_EDITOR_COLOR_HAS_NONE_COLORS.sendError((CommandSender)this.player, new Object[0]);
                return;
            }
            if (compiled.count(piece -> piece instanceof MessagePiece.Color) > limit) {
                KingdomsLang.NEXUS_RANK_EDITOR_LENGTH_COLOR.sendMessage((CommandSender)this.player, "limit", limit);
                return;
            }
            KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)this.player);
            RankColorChangeEvent event = new RankColorChangeEvent(this.rank, this.group, kp, (String)input);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            this.rank.setColor(event.getNewColor());
            this.openRankEditor(guiPath, editor);
            gui.endConversation();
        }, new Object[0]).push("symbol", () -> {
            KingdomsLang.NEXUS_RANK_EDITOR_ENTER_VALUE.sendMessage((CommandSender)this.player);
            gui.startConversation("symbol");
        }, input -> {
            int limit = KingdomsConfig.Ranks.CUSTOM_RANKS_LIMITS_LENGTH_SYMBOL.getManager().getInt();
            if (input.length() > limit) {
                KingdomsLang.NEXUS_RANK_EDITOR_LENGTH_SYMBOL.sendError((CommandSender)this.player, "limit", limit);
                return;
            }
            KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)this.player);
            RankSymbolChangeEvent event = new RankSymbolChangeEvent(this.rank, this.group, kp, (String)input);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            this.rank.setSymbol(event.getNewSymbol());
            this.openRankEditor(guiPath, editor);
            gui.endConversation();
        }, new Object[0]).push("priority", () -> {
            KingdomsLang.NEXUS_RANK_EDITOR_ENTER_VALUE.sendMessage((CommandSender)this.player);
            gui.startConversation("priority");
        }, input -> {
            int newPriority;
            try {
                newPriority = Integer.parseInt(input);
            }
            catch (NumberFormatException ignored) {
                KingdomsLang.INVALID_NUMBER.sendError((CommandSender)this.player, new MessagePlaceholderProvider().raw("arg", input));
                return;
            }
            int size = this.group.getRanks().size();
            if (newPriority <= 0 || newPriority >= size) {
                KingdomsLang.NEXUS_RANK_EDITOR_INVALID_PRIORITY.sendError((CommandSender)this.player, new Object[0]);
                return;
            }
            KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)this.player);
            RankPriorityChangeEvent event = new RankPriorityChangeEvent(this.rank, this.group, kp, newPriority);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            this.group.getRanks().switchPriorities(this.rank.getPriority(), newPriority);
            this.openRankEditor(guiPath, editor);
            gui.endConversation();
        }, new Object[0]).push("max-claims", () -> {
            KingdomsLang.NEXUS_RANK_EDITOR_ENTER_VALUE.sendMessage((CommandSender)this.player);
            gui.startConversation("max-claims");
        }, input -> {
            int num;
            try {
                num = Integer.parseInt(input);
            }
            catch (NumberFormatException ignored) {
                KingdomsLang.NEXUS_RANK_EDITOR_INVALID_MAX_CLAIMS.sendError((CommandSender)this.player, new Object[0]);
                return;
            }
            if (num < 0) {
                KingdomsLang.NEXUS_RANK_EDITOR_INVALID_MAX_CLAIMS.sendError((CommandSender)this.player, new Object[0]);
                return;
            }
            KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)this.player);
            RankMaxClaimsChangeEvent event = new RankMaxClaimsChangeEvent(this.rank, this.group, kp, num);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            this.rank.setMaxClaims(event.getNewMaxClaims());
            this.openRankEditor(guiPath, editor);
            gui.endConversation();
        }, new Object[0]).push("delete", () -> Kingdoms.taskScheduler().async().execute(() -> {
            int ranks = this.group.getRanks().size();
            if (ranks - 1 < 2) {
                KingdomsLang.NEXUS_RANK_EDITOR_CANNOT_DELETE_RANK.sendError((CommandSender)this.player, new Object[0]);
                return;
            }
            if (this.rank.isKing()) {
                KingdomsLang.NEXUS_RANK_EDITOR_CANNOT_DELETE_KING.sendError((CommandSender)this.player, new Object[0]);
                return;
            }
            if (this.group.getRanks().getLowestRank().getPriority() == this.rank.getPriority()) {
                KingdomsLang.NEXUS_RANK_EDITOR_CANNOT_DELETE_MEMBER.sendError((CommandSender)this.player, new Object[0]);
                return;
            }
            KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)this.player);
            RankDeleteEvent event = new RankDeleteEvent(this.rank, this.group, kp);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            this.group.getRanks().remove(this.rank);
            RankEditor.openRanks(this.ranksGUIPath, this.player, kp, this.group, this.ranksGUIEditor);
        }), new Object[0]).push("copy", () -> this.rankSelector(innerGUI -> innerGUI.push("back", () -> this.openRankEditor(editor), new Object[0])), new Object[0]);
        gui.option("material").editItem(item -> this.rank.getMaterial().setType(item)).onNormalClicks(() -> {
            KingdomsLang.NEXUS_RANK_EDITOR_ENTER_VALUE.sendMessage((CommandSender)this.player);
            gui.startConversation("material");
        }).setConversation(input -> {
            Optional material = XMaterial.matchXMaterial((String)input);
            if (!material.isPresent()) {
                KingdomsLang.NEXUS_RANK_EDITOR_UNKNOWN_MATERIAL.sendError((CommandSender)this.player, "material", input);
                return;
            }
            XMaterial mat = (XMaterial)material.get();
            List<String> list = KingdomsConfig.Ranks.CUSTOM_RANKS_LIMITS_MATERIAL_LIST.getManager().getStringList();
            boolean whitelist = KingdomsConfig.Ranks.CUSTOM_RANKS_LIMITS_MATERIAL_WHITELIST.getManager().getBoolean();
            boolean contains = XTag.anyMatch((Object)mat, (Collection)XTag.stringMatcher(list, null));
            if (!mat.isSupported() || XTag.INVENTORY_NOT_DISPLAYABLE.isTagged((XBase)mat) || whitelist != contains) {
                KingdomsLang.NEXUS_RANK_EDITOR_INVALID_MATERIAL.sendMessage((CommandSender)this.player, "material", KingdomsLang.translate(mat));
                return;
            }
            KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)this.player);
            RankMaterialChangeEvent event = new RankMaterialChangeEvent(this.rank, this.group, kp, mat);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            this.rank.setMaterial(event.getNewMaterial());
            this.openRankEditor(guiPath, editor);
            gui.endConversation();
        }).done();
        gui.push("permissions", () -> this.openPermissionCategories(innerGUI -> innerGUI.push("back", () -> this.openRankEditor(editor), new Object[0]), 0), new Object[0]);
        editor.accept(gui);
        gui.open();
        return gui;
    }

    private Map<String, PermissionCategory> getPermissionCategories() {
        HashMap<String, PermissionCategory> categories = new HashMap<String, PermissionCategory>();
        KingdomPermissionRegistry permissionRegistry = Kingdoms.get().getPermissionRegistery();
        ConfigSection categoriesSection = (this.group instanceof Nation ? KingdomsConfig.Ranks.NATIONAL_PERMISSION_CATEGORIES : KingdomsConfig.Ranks.PERMISSION_CATEGORIES).getManager().getSection().getSection();
        for (String key : categoriesSection.getKeys()) {
            ConfigSection category = categoriesSection.getSection(key);
            categories.put(key, new PermissionCategory(key, category.getString("gui"), category.getStringList("permissions").stream().map(Namespace::fromString).map(permissionRegistry::getRegistered).filter(Objects::nonNull).collect(Collectors.toList())));
        }
        return categories;
    }

    public InteractiveGUI openPermissionCategories(Consumer<InteractiveGUI> editor, int page) {
        InteractiveGUI gui = GUIAccessor.prepare(this.player, this.getGUIPath("permissions/categories"));
        for (PermissionCategory category : this.getPermissionCategories().values()) {
            gui.option("category-" + category.name).onNormalClicks(ctx -> this.openPermissions(editor, ctx.getConfig().getString("name"), category, page)).done();
        }
        editor.accept(gui);
        gui.open();
        return gui;
    }

    private String getGUIPath(String path) {
        return this.rootGUIPath + path;
    }

    private InteractiveGUI openPermissions(Consumer<InteractiveGUI> editor, String categoryName, PermissionCategory category, int page) {
        GUIBuilder builder = new GUIBuilder(this.getGUIPath("permissions/" + category.gui)).forPlayer(this.player);
        builder.getMessageContext().parse("permission_category_name", categoryName);
        Object gui = builder.build();
        boolean paginated = ((InteractiveGUI)gui).getConfig().isSet("(import)", "pagination");
        Runnable refresh = () -> this.openPermissions(editor, categoryName, category, page);
        if (paginated) {
            GUIPagination<KingdomPermission> pagination = GUIPagination.paginate(gui, category.permissions, "permissions", page, newPage -> this.openPermissions(editor, categoryName, category, (int)newPage));
            for (KingdomPermission permission : pagination.getPaginatedElements()) {
                this.handlePermissionOption(pagination.getOption(), permission, refresh);
            }
        } else {
            for (KingdomPermission permission : category.permissions) {
                OptionHandler option = ((InteractiveGUI)gui).option("permission-" + permission.getNamespace().getConfigOptionName());
                this.handlePermissionOption(option, permission, refresh);
            }
        }
        ((InteractiveGUI)gui).push("back", () -> this.openPermissionCategories(editor, page), new Object[0]);
        ((InteractiveGUI)gui).open();
        return gui;
    }

    private void handlePermissionOption(OptionHandler option, KingdomPermission permission, Runnable refresh) {
        option.setEdits("permission", permission.getNamespace().getConfigOptionName(), "enabled", this.rank.hasPermission(permission));
        option.onNormalClicks(() -> Kingdoms.taskScheduler().async().execute(() -> {
            RankPermissionChangeEvent event = new RankPermissionChangeEvent(this.rank, this.group, this.kp, new OrderedSet<KingdomPermission>(this.rank.getPermissions()));
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            if (this.rank.hasPermission(permission)) {
                this.rank.getPermissions().remove(permission);
            } else {
                this.rank.getPermissions().add(permission);
            }
            refresh.run();
        })).done();
    }

    public InteractiveGUI rankSelector(Consumer<InteractiveGUI> editor) {
        InteractiveGUI gui = GUIAccessor.prepare(this.player, "structures/nexus/ranks/rank-selector", RankEditor.getRankEdits(this.rank).withContext(this.kp.getOfflinePlayer()));
        if (gui == null) {
            return null;
        }
        ReusableOptionHandler holder = gui.getReusableOption("ranks");
        for (Rank copiedRank : this.group.getRanks()) {
            if (copiedRank.isKing() || copiedRank.equals(this.rank)) continue;
            holder.getMessageContext().addAll((Map)RankEditor.getRankEdits(copiedRank).getPlaceholders());
            ((ReusableOptionHandler)holder.editItem(item -> copiedRank.getMaterial().setType(item))).onNormalClicks(() -> {
                this.rank.setName(copiedRank.getName());
                this.rank.setColor(copiedRank.getColor());
                this.rank.setMaterial(copiedRank.getMaterial());
                this.rank.setMaxClaims(copiedRank.getMaxClaims());
                this.rank.setSymbol(copiedRank.getSymbol());
                this.rank.setPermissions(copiedRank.copyPermissions());
                KingdomsLang.NEXUS_RANK_EDITOR_COPY.sendMessage((CommandSender)this.player, "copy_node", copiedRank.getNode(), "rank_node", this.rank.getNode());
                this.openRankEditor(editor);
            }).done();
        }
        editor.accept(gui);
        gui.open();
        return gui;
    }

    private static final class PermissionCategory {
        final String name;
        final String gui;
        final List<KingdomPermission> permissions;

        private PermissionCategory(String name, String gui, List<KingdomPermission> permissions) {
            this.name = name;
            this.gui = gui;
            this.permissions = permissions;
        }
    }
}

