/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.buildings.limit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.kingdoms.abstraction.processor.AbstractKingdomsProcessor;
import org.kingdoms.abstraction.processor.KingdomsProcessor;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.config.accessor.EnumConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.upgradable.MiscUpgrade;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.abstraction.KingdomBuilding;
import org.kingdoms.constants.land.abstraction.KingdomBuildingStyle;
import org.kingdoms.constants.land.abstraction.KingdomBuildingType;
import org.kingdoms.constants.land.structures.Structure;
import org.kingdoms.constants.land.turrets.Turret;
import org.kingdoms.events.items.KingdomItemRemoveContext;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.locale.messenger.DefaultedMessenger;
import org.kingdoms.locale.messenger.LanguageEntryMessenger;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.locale.messenger.StaticMessenger;
import org.kingdoms.locale.placeholders.context.PlaceholderContextBuilder;
import org.kingdoms.locale.placeholders.context.PlaceholderProvider;
import org.kingdoms.managers.buildings.limit.BuildingLimitType;
import org.kingdoms.utils.MathUtils;
import org.kingdoms.utils.Validate;
import org.kingdoms.utils.internal.enumeration.QuickEnumSet;
import org.kingdoms.utils.internal.iterator.Iterables;
import org.kingdoms.utils.string.Strings;

public final class BuildingLimiter<Building extends KingdomBuilding<?>>
extends AbstractKingdomsProcessor {
    private final Kingdom kingdom;
    private final int limitTotal;
    private final int limitPerLand;
    private final Function<Land, Collection<? extends Building>> of;
    private final Set<BuildingLimitType> limitTypes = new QuickEnumSet((Enum[])BuildingLimitType.values());
    private KingdomBuildingStyle<?, ?, ?> checkCanAddMore;
    private boolean processed = false;
    private boolean returnOnFirstError = false;
    private boolean prepareForRemoval = false;
    private final Collection<? extends Building> totalOfLand;
    private final Set<Building> extraBuildings = Collections.newSetFromMap(new IdentityHashMap());
    private final Map<KingdomBuildingStyle<?, ?, ?>, List<Building>> landCountMap = new IdentityHashMap();
    private final Map<KingdomBuildingStyle<?, ?, ?>, Integer> totalCountMap = new IdentityHashMap();
    private int totalSize = 0;

    private void limitedBy(BuildingLimitType type, int current, int limit) {
        if (current < limit) {
            throw new IllegalArgumentException("Cannot limit type " + (Object)((Object)type) + " with: current:" + current + " <= limit:" + limit);
        }
        this.limitTypes.add(type);
        String entryName = BuildingLimiter.getLangEntryName(type).replace('-', '_');
        this.getMessageContext().raw("building_limit_" + entryName, limit);
        this.getMessageContext().raw("building_current_" + entryName, current);
    }

    @Override
    public boolean isSuccessful() {
        return this.limitTypes.isEmpty();
    }

    private boolean shouldReturn() {
        return this.returnOnFirstError && !this.limitTypes.isEmpty();
    }

    private BuildingLimiter(Kingdom kingdom, Land land, EnumConfig limitTotal, EnumConfig limitPerLand, Function<Land, Collection<? extends Building>> of) {
        this.kingdom = Objects.requireNonNull(kingdom);
        PlaceholderContextBuilder ctx = new PlaceholderContextBuilder().withContext(kingdom).raw("misc_upgrades_max_turrets", MiscUpgrade.MAX_TURRETS.getScaling(kingdom));
        this.limitTotal = (int)MathUtils.eval(limitTotal.getManager().getMathExpression(), (PlaceholderProvider)ctx);
        this.limitPerLand = (int)MathUtils.eval(limitPerLand.getManager().getMathExpression(), (PlaceholderProvider)ctx);
        this.of = of;
        this.totalOfLand = land != null ? of.apply(land) : null;
    }

    @Override
    @Nullable
    public Messenger processIssue() {
        this.process0();
        if (this.checkCanAddMore == null) {
            return null;
        }
        if (this.limitTypes.isEmpty()) {
            return null;
        }
        String entryName = BuildingLimiter.getLangEntryName((BuildingLimitType)((Object)this.limitTypes.stream().findFirst().get()));
        return DefaultedMessenger.oneOf(new LanguageEntryMessenger(this.checkCanAddMore.getConfigName(), "limit", entryName), () -> new LanguageEntryMessenger(Strings.configOption(((KingdomBuildingType)this.checkCanAddMore.getType()).getCategoryName()), "limit", entryName), () -> new StaticMessenger("Missing building limit entry for " + this.checkCanAddMore + " of type " + entryName));
    }

    private static String getLangEntryName(BuildingLimitType type) {
        switch (type) {
            case TOTAL: {
                return "total";
            }
            case PER_LAND: {
                return "total-per-land";
            }
            case STYLE_TOTAL: {
                return "total-style";
            }
            case STYLE_PER_LAND: {
                return "total-style-per-land";
            }
        }
        throw new AssertionError((Object)("Unknown building limit type: " + (Object)((Object)type)));
    }

    public int getLimit(BuildingLimitType type) {
        switch (type) {
            case TOTAL: {
                return this.limitTotal;
            }
            case PER_LAND: {
                return this.limitPerLand;
            }
            case STYLE_TOTAL: 
            case STYLE_PER_LAND: {
                throw new UnsupportedOperationException("Cannot get specific limit of type " + (Object)((Object)type));
            }
        }
        throw new AssertionError((Object)("Unknown building limit type: " + (Object)((Object)type)));
    }

    private void ensureLandData() {
        Objects.requireNonNull(this.totalOfLand, "Cannot process the limiter without land information");
    }

    public BuildingLimiter<Building> checkCanAddMore(KingdomBuildingStyle<Building, ?, ?> style) {
        this.checkCanAddMore = style;
        this.returnOnFirstError = true;
        style.addMessageContextEdits(this.getMessageContext());
        return this;
    }

    public static BuildingLimiter<Structure> ofStructures(Kingdom kingdom, Land land) {
        return new BuildingLimiter(kingdom, land, KingdomsConfig.Structures.LIMITS_TOTAL, KingdomsConfig.Structures.LIMITS_PER_LAND, x -> x.getStructures().values());
    }

    public static BuildingLimiter<Turret> ofTurrets(Kingdom kingdom, Land land) {
        return new BuildingLimiter(kingdom, land, KingdomsConfig.Turrets.LIMITS_TOTAL, KingdomsConfig.Turrets.LIMITS_PER_LAND, x -> x.getTurrets().values());
    }

    public static BuildingLimiter<Turret> ofTurrets(Kingdom kingdom) {
        return BuildingLimiter.ofTurrets(kingdom, null);
    }

    public Collection<Building> removeExtra() {
        Validate.isTrue(this.processed, "Data not processed yet");
        this.prepareForRemoval = true;
        for (KingdomBuilding building : this.extraBuildings) {
            building.remove(new KingdomItemRemoveContext());
        }
        return this.extraBuildings;
    }

    private void checkTotalLimit() {
        int limitTotal = this.limitTotal - (this.checkCanAddMore == null ? 0 : 1);
        if (limitTotal > 0 && this.totalSize > limitTotal) {
            int toRemove = this.totalSize - limitTotal;
            for (Map.Entry<KingdomBuildingStyle<?, ?, ?>, List<Building>> counted : this.landCountMap.entrySet()) {
                if (toRemove <= 0) break;
                if (this.prepareForRemoval) {
                    int sizeBefore = this.extraBuildings.size();
                    Iterables.removeAndCollect(toRemove, (Collection)counted.getValue(), this.extraBuildings);
                    int sizeAfter = this.extraBuildings.size();
                    toRemove -= Math.abs(sizeAfter - sizeBefore);
                    continue;
                }
                toRemove -= counted.getValue().size();
            }
            if (toRemove > 0) {
                this.limitedBy(BuildingLimitType.TOTAL, this.totalSize, this.limitTotal);
            }
        }
    }

    private void checkTotalPerLandLimit() {
        this.ensureLandData();
        int limitPerLand = this.limitPerLand - (this.checkCanAddMore == null ? 0 : 1);
        if (limitPerLand > 0 && this.totalOfLand.size() > limitPerLand) {
            int toRemove = this.totalOfLand.size() - limitPerLand;
            for (Map.Entry<KingdomBuildingStyle<?, ?, ?>, List<Building>> counted : this.landCountMap.entrySet()) {
                if (toRemove <= 0) break;
                if (this.prepareForRemoval) {
                    int sizeBefore = this.extraBuildings.size();
                    Iterables.removeAndCollect(toRemove, (Collection)counted.getValue(), this.extraBuildings);
                    int sizeAfter = this.extraBuildings.size();
                    toRemove -= Math.abs(sizeAfter - sizeBefore);
                    continue;
                }
                toRemove -= counted.getValue().size();
            }
            if (toRemove > 0) {
                this.limitedBy(BuildingLimitType.PER_LAND, this.totalOfLand.size(), this.limitPerLand);
            }
        }
    }

    private void individualTotalLimit(KingdomBuildingStyle<?, ?, ?> style, List<Building> buildings) {
        int totalSpecificLimit = style.getOption("limits", "total").getInt();
        if (totalSpecificLimit <= 0) {
            return;
        }
        int totalSpecificCount = this.totalCountMap.getOrDefault(style, 0);
        if (this.checkCanAddMore == style) {
            ++totalSpecificCount;
        }
        if (totalSpecificCount > totalSpecificLimit) {
            int toRemove = totalSpecificCount - totalSpecificLimit;
            if (this.prepareForRemoval) {
                Iterables.removeAndCollect(toRemove, buildings, this.extraBuildings);
            }
            this.limitedBy(BuildingLimitType.STYLE_TOTAL, totalSpecificCount, totalSpecificLimit);
        }
    }

    private void individualTotalPerLandLimit(KingdomBuildingStyle<?, ?, ?> style, List<Building> buildings) {
        int limitIndividualPerLand = style.getOption("limits", "per-land").getInt();
        if (limitIndividualPerLand <= 0) {
            return;
        }
        int sameTypeCount = buildings.size();
        if (this.checkCanAddMore == style) {
            ++sameTypeCount;
        }
        if (sameTypeCount > limitIndividualPerLand) {
            int toRemove = sameTypeCount - limitIndividualPerLand;
            if (this.prepareForRemoval) {
                Iterables.removeAndCollect(toRemove, buildings, this.extraBuildings);
            }
            int currentAmount = this.checkCanAddMore == style ? sameTypeCount - 1 : sameTypeCount;
            this.limitedBy(BuildingLimitType.STYLE_PER_LAND, currentAmount, limitIndividualPerLand);
        }
    }

    private boolean checkIndividualLimits(KingdomBuildingStyle<?, ?, ?> style, List<Building> buildings) {
        if (buildings.isEmpty()) {
            return false;
        }
        this.individualTotalLimit(style, buildings);
        if (this.shouldReturn()) {
            return true;
        }
        this.individualTotalPerLandLimit(style, buildings);
        return this.shouldReturn();
    }

    @Override
    @NotNull
    public BuildingLimiter<Building> process() {
        super.process();
        return this;
    }

    private void process0() {
        List buildings;
        Object style;
        Validate.isTrue(!this.processed, "Data was already processed");
        this.ensureLandData();
        this.processed = true;
        for (Land land : this.kingdom.getLands()) {
            for (KingdomBuilding building : this.of.apply(land)) {
                this.totalCountMap.compute((KingdomBuildingStyle<?, ?, ?>)building.getStyle(), (BiFunction<KingdomBuildingStyle<?, ?, ?>, Integer, Integer>)((BiFunction<KingdomBuildingStyle, Integer, Integer>)(k, v) -> v == null ? 1 : v + 1));
                ++this.totalSize;
            }
        }
        for (KingdomBuilding kingdomBuilding : this.totalOfLand) {
            style = kingdomBuilding.getStyle();
            buildings = this.landCountMap.computeIfAbsent((KingdomBuildingStyle<?, ?, ?>)style, (Function<KingdomBuildingStyle<?, ?, ?>, List<Building>>)((Function<KingdomBuildingStyle, List>)k -> new ArrayList(10)));
            buildings.add(kingdomBuilding);
        }
        this.checkTotalLimit();
        if (this.shouldReturn()) {
            return;
        }
        this.checkTotalPerLandLimit();
        if (this.shouldReturn()) {
            return;
        }
        if (this.checkCanAddMore == null) {
            for (Map.Entry entry : this.landCountMap.entrySet()) {
                style = (KingdomBuildingStyle)entry.getKey();
                if (!this.checkIndividualLimits((KingdomBuildingStyle<?, ?, ?>)style, buildings = (List)entry.getValue())) continue;
                return;
            }
        } else {
            List<Building> buildings2 = this.landCountMap.get(this.checkCanAddMore);
            if (buildings2 != null) {
                this.checkIndividualLimits(this.checkCanAddMore, buildings2);
            }
        }
    }

    @Override
    @NotNull
    public KingdomsProcessor reprocess() {
        throw new UnsupportedOperationException();
    }
}

