/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.buildings.itemoffer.impl;

import java.util.Iterator;
import java.util.Objects;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.kingdoms.config.accessor.ConfigAccessor;
import org.kingdoms.constants.land.FuelContainer;
import org.kingdoms.constants.land.abstraction.KingdomBuilding;
import org.kingdoms.constants.land.abstraction.KingdomBuildingStyle;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.managers.ItemMatcher;
import org.kingdoms.managers.buildings.itemoffer.BuildingItemOfferSession;
import org.kingdoms.managers.buildings.itemoffer.ItemOfferResult;
import org.kingdoms.utils.config.ConfigSection;
import org.kingdoms.utils.internal.numbers.Numbers;

public class BuildingFuelItemOffer
extends BuildingItemOfferSession {
    public BuildingFuelItemOffer(Player player, Item droppedItem, SimpleLocation droppedLocation, ItemStack droppedItemStack) {
        super(player, droppedItem, droppedLocation, droppedItemStack);
    }

    @Override
    public void checkBuilding(KingdomBuilding<?> building) {
        ConfigSection variant;
        if (!(building instanceof FuelContainer)) {
            return;
        }
        ConfigAccessor settings = ((KingdomBuildingStyle)building.getStyle()).getOption("fuel").getSection();
        if (!settings.getBoolean("enabled")) {
            return;
        }
        ItemMatcher matched = null;
        Iterator<ConfigSection> iterator = settings.gotoSection("variants").getSection().getSections().values().iterator();
        while (iterator.hasNext() && !(matched = new ItemMatcher(variant = iterator.next())).matches(this.droppedItemStack)) {
            matched = null;
        }
        if (matched == null) {
            return;
        }
        FuelContainer fuelContainer = (FuelContainer)((Object)building);
        double capacity = fuelContainer.getMaxFuel();
        boolean currentFull = fuelContainer.hasFuel(capacity);
        if (this.compareNeedsAndDistance(building, currentFull)) {
            return;
        }
        this.lastBuildingNeedsItem = !currentFull;
        this.building = building;
        this.matchedItem = matched;
    }

    @Override
    public ItemOfferResult finalizeProcess() {
        int keep;
        Objects.requireNonNull(this.building);
        FuelContainer fuelContainer = (FuelContainer)((Object)this.building);
        if (!this.lastBuildingNeedsItem) {
            KingdomsLang.STRUCTURE_FUEL_FULL.sendError((CommandSender)this.player, "fuel", Numbers.toFancyNumber(fuelContainer.getFuel()));
            this.building.playSound("fuel-full");
            return null;
        }
        int amount = this.droppedItemStack.getAmount();
        this.building.playSound("fuel-fill");
        ItemMatcher matched = this.matchedItem;
        double oldAmount = fuelContainer.getFuel();
        double costPerItem = matched.getSection().getDouble("fill-amount-per-item");
        double added = costPerItem * (double)amount;
        double capacity = fuelContainer.getMaxFuel();
        fuelContainer.setFuel(Math.min(capacity, fuelContainer.getFuel() + added));
        if (fuelContainer.getFuel() == capacity) {
            double needed = capacity - oldAmount;
            keep = (int)Math.floor((added - needed) / costPerItem);
        } else {
            keep = 0;
        }
        return new ItemOfferResult(keep, fuelContainer.getFuel() == capacity ? KingdomsLang.STRUCTURE_FUEL_MAXXED : KingdomsLang.STRUCTURE_FUEL_FILL, new MessagePlaceholderProvider().raws("old-fuel", Numbers.toFancyNumber(oldAmount), "added-fuel", Numbers.toFancyNumber(added), "fuel", Numbers.toFancyNumber(fuelContainer.getFuel())));
    }
}

