/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.book;

import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerEditBookEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.ItemStack;
import org.kingdoms.events.members.KingdomLeaveEvent;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.managers.book.BookSession;
import org.kingdoms.utils.hash.EntityHashMap;
import org.kingdoms.utils.hash.EntityWeakHashMap;
import org.kingdoms.utils.nms.XBook;

public final class BookManager
implements Listener {
    private static final EntityWeakHashMap<Player, BookSession> BOOKS = EntityHashMap.weakBuilder(Player.class).build();

    public static void handle(Player player, BookSession session, List<String> pages, String title) {
        BOOKS.put(player, session);
        ItemStack book = XBook.getBook(pages, player, title, true, true);
        player.getInventory().setItem(session.getSlot(), book);
    }

    public static BookSession getSession(Player player) {
        return BOOKS.get(player);
    }

    public static BookSession removeSession(Player player) {
        return BOOKS.remove(player);
    }

    public static void removeAll() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            BookSession slot = BOOKS.get(player);
            if (slot == null) continue;
            player.getInventory().setItem(slot.getSlot(), null);
        }
    }

    public static BookSession removeBook(Player player) {
        BookSession slot = BOOKS.remove(player);
        if (slot == null) {
            return null;
        }
        player.getInventory().setItem(slot.getSlot(), null);
        return slot;
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onBookSign(PlayerEditBookEvent event) {
        if (!event.isSigning()) {
            return;
        }
        Player player = event.getPlayer();
        BookSession editingChapter = BOOKS.get(player);
        if (editingChapter == null) {
            return;
        }
        if (editingChapter.getOnSign() != null) {
            editingChapter.getOnSign().accept(event);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onKingdomLeave(KingdomLeaveEvent event) {
        Player player = event.getPlayer().getPlayer();
        if (player != null) {
            BookManager.removeBook(player);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onItemSwap(PlayerSwapHandItemsEvent event) {
        Player player = event.getPlayer();
        BookSession slot = BOOKS.get(player);
        if (slot == null) {
            return;
        }
        if (slot.getSlot() != player.getInventory().getHeldItemSlot()) {
            return;
        }
        event.setCancelled(true);
        KingdomsLang.BOOKS_CANT_MOVE.sendError((CommandSender)player, new Object[0]);
    }

    @EventHandler(ignoreCancelled=true)
    public void onBookDrop(PlayerDropItemEvent event) {
        Player player = event.getPlayer();
        BookSession slot = BOOKS.get(player);
        if (slot == null) {
            return;
        }
        if (slot.getSlot() == player.getInventory().getHeldItemSlot()) {
            KingdomsLang.BOOKS_CANT_MOVE.sendError((CommandSender)player, new Object[0]);
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onLeave(PlayerQuitEvent event) {
        BookManager.removeBook(event.getPlayer());
    }

    @EventHandler
    public void onDeath(PlayerDeathEvent event) {
        BookManager.removeBook(event.getEntity());
    }

    @EventHandler(ignoreCancelled=true)
    public void onBookItemMove(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        BookSession slot = BOOKS.get(player);
        if (slot == null || event.getSlot() != slot.getSlot()) {
            return;
        }
        event.setCancelled(true);
        KingdomsLang.BOOKS_CANT_MOVE.sendError((CommandSender)player, new Object[0]);
    }
}

