/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.backup;

import java.nio.file.Path;
import java.util.function.Function;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.collections.ArraysKt;
import org.kingdoms.libs.kotlin.jvm.JvmOverloads;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.managers.backup.ZipEntryCreator;
import org.kingdoms.utils.fs.FSUtil;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001BE\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0016\b\u0002\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0018\u00010\u0007\u0012\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0018\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u0005H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\"\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0018\u00010\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001c\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bX\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u0016\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001c"}, d2={"Lorg/kingdoms/managers/backup/ZipEntryCreatorPath;", "Lorg/kingdoms/managers/backup/ZipEntryCreator;", "path", "Ljava/nio/file/Path;", "zipPath", "", "errorHandler", "Ljava/util/function/Function;", "", "", "comments", "", "<init>", "(Ljava/nio/file/Path;Ljava/lang/String;Ljava/util/function/Function;[Ljava/lang/String;)V", "getPath", "()Ljava/nio/file/Path;", "getZipPath", "()Ljava/lang/String;", "getErrorHandler", "()Ljava/util/function/Function;", "getComments", "()[Ljava/lang/String;", "[Ljava/lang/String;", "processStream", "relativeToBackup", "zs", "Ljava/util/zip/ZipOutputStream;", "toString", "core"})
public final class ZipEntryCreatorPath
implements ZipEntryCreator {
    @NotNull
    private final Path path;
    @Nullable
    private final String zipPath;
    @Nullable
    private final Function<Throwable, Boolean> errorHandler;
    @NotNull
    private final String[] comments;

    @JvmOverloads
    public ZipEntryCreatorPath(@NotNull Path path, @Nullable String zipPath, @Nullable Function<Throwable, Boolean> errorHandler, @NotNull String[] comments) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)comments, (String)"comments");
        this.path = path;
        this.zipPath = zipPath;
        this.errorHandler = errorHandler;
        this.comments = comments;
    }

    public /* synthetic */ ZipEntryCreatorPath(Path path, String string, Function function, String[] stringArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            function = null;
        }
        if ((n & 8) != 0) {
            stringArray = new String[]{};
        }
        this(path, string, function, stringArray);
    }

    @NotNull
    public final Path getPath() {
        return this.path;
    }

    @Nullable
    public final String getZipPath() {
        return this.zipPath;
    }

    @Override
    @Nullable
    public Function<Throwable, Boolean> getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    @NotNull
    public String[] getComments() {
        return this.comments;
    }

    @Override
    @NotNull
    public String processStream(@NotNull Path relativeToBackup, @NotNull ZipOutputStream zs) {
        Intrinsics.checkNotNullParameter((Object)relativeToBackup, (String)"relativeToBackup");
        Intrinsics.checkNotNullParameter((Object)zs, (String)"zs");
        String string = this.zipPath;
        if (string == null) {
            string = ((Object)relativeToBackup.relativize(this.path)).toString();
        }
        String zipPath = string;
        ZipEntry zipEntry = new ZipEntry(zipPath);
        if (!(this.getComments().length == 0)) {
            zs.setComment(ArraysKt.joinToString$default((Object[])this.getComments(), null, null, null, (int)0, null, ZipEntryCreatorPath::processStream$lambda$0, (int)31, null));
        }
        FSUtil.lockAndTransfer(this.path, zs, () -> ZipEntryCreatorPath.processStream$lambda$1(zs, zipEntry));
        zs.closeEntry();
        return zipPath;
    }

    @NotNull
    public String toString() {
        return "ZipEntryContentPath(" + this.path + ')';
    }

    @JvmOverloads
    public ZipEntryCreatorPath(@NotNull Path path, @Nullable String zipPath, @Nullable Function<Throwable, Boolean> errorHandler) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this(path, zipPath, errorHandler, null, 8, null);
    }

    @JvmOverloads
    public ZipEntryCreatorPath(@NotNull Path path, @Nullable String zipPath) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this(path, zipPath, null, null, 12, null);
    }

    @JvmOverloads
    public ZipEntryCreatorPath(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this(path, null, null, null, 14, null);
    }

    private static final CharSequence processStream$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "\n";
    }

    private static final void processStream$lambda$1(ZipOutputStream $zs, ZipEntry $zipEntry) {
        $zs.putNextEntry($zipEntry);
    }
}

