/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.backup;

import java.io.InputStream;
import java.nio.file.Path;
import java.util.function.Function;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.collections.ArraysKt;
import org.kingdoms.libs.kotlin.jvm.JvmOverloads;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.managers.backup.ZipEntryCreator;
import org.kingdoms.utils.fs.FSUtil;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001BA\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0016\b\u0002\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0018\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\"\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001c\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000bX\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u0016\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001d"}, d2={"Lorg/kingdoms/managers/backup/ZipEntryCreatorInputStream;", "Lorg/kingdoms/managers/backup/ZipEntryCreator;", "filePath", "", "errorHandler", "Ljava/util/function/Function;", "", "", "inputStream", "Ljava/io/InputStream;", "comments", "", "<init>", "(Ljava/lang/String;Ljava/util/function/Function;Ljava/io/InputStream;[Ljava/lang/String;)V", "getFilePath", "()Ljava/lang/String;", "getErrorHandler", "()Ljava/util/function/Function;", "getInputStream", "()Ljava/io/InputStream;", "getComments", "()[Ljava/lang/String;", "[Ljava/lang/String;", "processStream", "relativeToBackup", "Ljava/nio/file/Path;", "zs", "Ljava/util/zip/ZipOutputStream;", "toString", "core"})
public final class ZipEntryCreatorInputStream
implements ZipEntryCreator {
    @NotNull
    private final String filePath;
    @Nullable
    private final Function<Throwable, Boolean> errorHandler;
    @NotNull
    private final InputStream inputStream;
    @NotNull
    private final String[] comments;

    @JvmOverloads
    public ZipEntryCreatorInputStream(@NotNull String filePath, @Nullable Function<Throwable, Boolean> errorHandler, @NotNull InputStream inputStream, @NotNull String[] comments) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Intrinsics.checkNotNullParameter((Object)comments, (String)"comments");
        this.filePath = filePath;
        this.errorHandler = errorHandler;
        this.inputStream = inputStream;
        this.comments = comments;
    }

    public /* synthetic */ ZipEntryCreatorInputStream(String string, Function function, InputStream inputStream, String[] stringArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            function = null;
        }
        if ((n & 8) != 0) {
            stringArray = new String[]{};
        }
        this(string, function, inputStream, stringArray);
    }

    @NotNull
    public final String getFilePath() {
        return this.filePath;
    }

    @Override
    @Nullable
    public Function<Throwable, Boolean> getErrorHandler() {
        return this.errorHandler;
    }

    @NotNull
    public final InputStream getInputStream() {
        return this.inputStream;
    }

    @Override
    @NotNull
    public String[] getComments() {
        return this.comments;
    }

    @Override
    @NotNull
    public String processStream(@NotNull Path relativeToBackup, @NotNull ZipOutputStream zs) {
        Intrinsics.checkNotNullParameter((Object)relativeToBackup, (String)"relativeToBackup");
        Intrinsics.checkNotNullParameter((Object)zs, (String)"zs");
        ZipEntry zipEntry = new ZipEntry(this.filePath);
        zs.putNextEntry(zipEntry);
        if (!(this.getComments().length == 0)) {
            zs.setComment(ArraysKt.joinToString$default((Object[])this.getComments(), null, null, null, (int)0, null, ZipEntryCreatorInputStream::processStream$lambda$0, (int)31, null));
        }
        FSUtil.transfer(this.inputStream, zs);
        zs.closeEntry();
        return this.filePath;
    }

    @NotNull
    public String toString() {
        return "ZipEntryContentInputStream(" + this.filePath + ')';
    }

    @JvmOverloads
    public ZipEntryCreatorInputStream(@NotNull String filePath, @Nullable Function<Throwable, Boolean> errorHandler, @NotNull InputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        this(filePath, errorHandler, inputStream, null, 8, null);
    }

    @JvmOverloads
    public ZipEntryCreatorInputStream(@NotNull String filePath, @NotNull InputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        this(filePath, null, inputStream, null, 10, null);
    }

    private static final CharSequence processStream$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "\n";
    }
}

