/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.abstraction;

import com.google.common.base.Strings;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.List;
import java.util.Objects;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.config.managers.ConfigManager;
import org.kingdoms.data.centers.KingdomsStartup;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.main.KLogger;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.Masswar;
import org.kingdoms.managers.abstraction.ProlongedDurationTask;
import org.kingdoms.managers.daily.DailyChecksManager;
import org.kingdoms.managers.daily.TimeZoneHandler;
import org.kingdoms.managers.daily.elections.Elections;
import org.kingdoms.managers.daily.elections.ElectionsManager;
import org.kingdoms.managers.logger.KingdomsLogger;
import org.kingdoms.scheduler.DelayedTask;
import org.kingdoms.utils.time.TimeFormatter;
import org.kingdoms.utils.time.TimeUtils;

public abstract class ProlongedTask {
    private final Duration interval;
    private final LocalTime fixedPerformTime;
    private final String taskName;
    private final String[] lastPerformConfigPath;
    private final long[] countdowns;
    private final boolean compensateMissedTask;
    private boolean skip;
    private DelayedTask task;
    private DelayedTask reminder;

    protected ProlongedTask(Long interval, String fixedPerformTime, String taskName, String[] lastPerformConfigPath, List<String> countdowns, boolean compensateMissedTask) {
        LocalTime fixedPerformTime1;
        this.compensateMissedTask = compensateMissedTask;
        Objects.requireNonNull(interval, () -> taskName + " interval cannot be null");
        if (Strings.isNullOrEmpty((String)fixedPerformTime)) {
            fixedPerformTime1 = null;
        } else {
            try {
                fixedPerformTime1 = TimeZoneHandler.parseLocalTime(fixedPerformTime);
            }
            catch (DateTimeParseException ex) {
                fixedPerformTime1 = null;
            }
        }
        this.fixedPerformTime = fixedPerformTime1;
        if (this.fixedPerformTime != null) {
            if (interval % Duration.ofDays(1L).toMillis() != 0L) {
                KLogger.error("The interval of " + taskName + " must be in days: " + interval + " -> " + Duration.ofMillis(interval).toDays());
                this.interval = Duration.ofDays(1L);
            } else {
                this.interval = Duration.ofMillis(interval);
            }
        } else {
            this.interval = Duration.ofMillis(interval);
        }
        this.taskName = taskName;
        this.lastPerformConfigPath = lastPerformConfigPath;
        this.countdowns = countdowns == null ? null : ProlongedTask.parseCountdowns(countdowns);
    }

    protected ProlongedTask(Duration interval, LocalTime fixedPerformTime, String taskName, String[] lastPerformConfigPath, List<String> countdowns, boolean compensateMissedTask) {
        this.interval = interval;
        this.taskName = taskName;
        this.fixedPerformTime = fixedPerformTime;
        this.lastPerformConfigPath = lastPerformConfigPath;
        this.countdowns = countdowns == null ? null : ProlongedTask.parseCountdowns(countdowns);
        this.compensateMissedTask = compensateMissedTask;
    }

    public static void init() {
        KingdomsStartup.whenReady(x -> {
            DailyChecksManager.getInstance().load();
            if (KingdomsConfig.Invasions.MASSWAR_ENABLED.getManager().getBoolean() && !"0".equals(KingdomsConfig.Invasions.MASSWAR_INTERVAL.getManager().getString())) {
                Masswar.getInstance().load();
            }
            Elections.ALL.stream().filter(ElectionsManager::isEnabled).forEach(ProlongedTask::load);
        });
    }

    public void runAndRenew() {
        this.log("runAndRenew() start.");
        if (this.task != null) {
            this.task.cancel();
            this.task = null;
        }
        if (this.reminder != null) {
            this.reminder.cancel();
            this.reminder = null;
        }
        this.runAndSet();
        this.load(null);
        this.log("runAndRenew() done.");
    }

    protected void log(String str) {
        KingdomsLogger.getMain().log("[ProlongedTask/" + this.taskName + "] " + str);
    }

    private static long[] parseCountdowns(List<String> countdown) {
        return countdown.stream().map(TimeUtils::parseTime).filter(Objects::nonNull).mapToLong(x -> x).toArray();
    }

    public abstract void run();

    public abstract void remind(String var1);

    public boolean isSkipping() {
        return this.skip;
    }

    public void setSkipped(boolean skip) {
        this.skip = skip;
    }

    public long untilNextRun(TemporalUnit unit) {
        LocalDateTime now = LocalDateTime.now(TimeZoneHandler.SERVER_TIME_ZONE);
        LocalDateTime lastPerform = this.lastPerform();
        if (lastPerform != null && this instanceof ProlongedDurationTask) {
            Duration taskDuration = ((ProlongedDurationTask)this).getDuration();
            long runningDuration = unit.between(lastPerform, now);
            long remaining = taskDuration.toMillis() - runningDuration;
            if (remaining > 0L) {
                return 0L;
            }
        }
        if (!this.compensateMissedTask) {
            lastPerform = null;
        }
        if (this.fixedPerformTime == null) {
            if (lastPerform == null) {
                return now.until(now.plus(this.interval), unit);
            }
            if (lastPerform.plus(this.interval).isBefore(now)) {
                return 0L;
            }
            return now.until(lastPerform.plus(this.interval), unit);
        }
        if (lastPerform == null) {
            if (now.toLocalTime().isAfter(this.fixedPerformTime)) {
                ChronoUnit accuracy = ChronoUnit.SECONDS;
                long reversedUntil = this.fixedPerformTime.until(now.toLocalTime(), accuracy);
                LocalDateTime exactNextRun = now.plusDays(1L).plus(reversedUntil, accuracy);
                return unit.between(now, exactNextRun);
            }
            return now.until(LocalDateTime.of(now.toLocalDate(), this.fixedPerformTime), unit);
        }
        LocalDateTime supposedNextRun = LocalDateTime.of(lastPerform.plus(this.interval).toLocalDate(), this.fixedPerformTime);
        if (now.isAfter(supposedNextRun)) {
            return 0L;
        }
        return now.until(supposedNextRun, unit);
    }

    public LocalDateTime lastPerform() {
        long millis = ConfigManager.getGlobals().getLong(this.lastPerformConfigPath);
        if (millis <= 0L) {
            return null;
        }
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(millis), TimeZoneHandler.SERVER_TIME_ZONE);
    }

    public void runAndSet() {
        this.run();
        ConfigManager.getGlobals().set(this.lastPerformConfigPath, (Object)System.currentTimeMillis());
        ConfigManager.getGlobalsAdapter().saveConfig();
    }

    public void load() {
        this.load(Duration.ofMillis(this.untilNextRun(ChronoUnit.MILLIS)));
    }

    private void load(@Nullable Duration initialDelay) {
        if (this.task != null) {
            throw new IllegalStateException("Task " + this.taskName + " is already loaded");
        }
        Duration intervalDelays = this.fixedPerformTime == null ? this.interval : Duration.ofDays(1L);
        this.task = Kingdoms.taskScheduler().async().repeating(initialDelay == null ? intervalDelays : initialDelay, intervalDelays, () -> {
            if (!this.isSkipping()) {
                this.runAndSet();
            } else {
                this.skip = false;
            }
        });
        this.scheduleReminder();
    }

    private void scheduleReminder() {
        if (this.countdowns == null || this.skip) {
            return;
        }
        long nextCheck = this.untilNextRun(ChronoUnit.MILLIS);
        Long millisUntilNextCooldown = null;
        for (long countdown : this.countdowns) {
            if (countdown >= nextCheck) continue;
            millisUntilNextCooldown = nextCheck - countdown;
            break;
        }
        if (millisUntilNextCooldown == null) {
            return;
        }
        this.log("Triggered reminder. Next: " + TimeFormatter.ofRaw(millisUntilNextCooldown));
        this.reminder = Kingdoms.taskScheduler().async().delayed(Duration.ofMillis(millisUntilNextCooldown).plusMillis(100L), () -> {
            this.scheduleReminder();
            this.remind(TimeFormatter.ofRaw(this.untilNextRun(ChronoUnit.MILLIS)));
        });
    }
}

