/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.abstraction;

import java.time.Duration;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.List;
import org.kingdoms.libs.jetbrains.annotations.MustBeInvokedByOverriders;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.NoWhenBranchMatchedException;
import org.kingdoms.libs.kotlin.enums.EnumEntries;
import org.kingdoms.libs.kotlin.enums.EnumEntriesKt;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.abstraction.ProlongedTask;
import org.kingdoms.managers.daily.TimeZoneHandler;
import org.kingdoms.scheduler.DelayedTask;
import org.kingdoms.scheduler.TaskScheduler;
import org.kingdoms.utils.time.stopwatch.Stopwatch;
import org.kingdoms.utils.time.stopwatch.StopwatchState;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\b&\u0018\u00002\u00020\u0001:\u0001-BI\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010\u001f\u001a\u00020\u0005H\u0002J\u0006\u0010 \u001a\u00020\fJ\u0006\u0010!\u001a\u00020\u001eJ\u0006\u0010\"\u001a\u00020\u001eJ\b\u0010#\u001a\u00020\u001eH\u0004J\b\u0010(\u001a\u00020\u001eH\u0017J\b\u0010)\u001a\u00020\u001eH\u0016J\b\u0010*\u001a\u00020\u001eH\u0017J\n\u0010+\u001a\u0004\u0018\u00010%H\u0002J\u0006\u0010,\u001a\u00020%R$\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u0017X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010$\u001a\u00020%X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'\u00a8\u0006."}, d2={"Lorg/kingdoms/managers/abstraction/ProlongedDurationTask;", "Lorg/kingdoms/managers/abstraction/ProlongedTask;", "interval", "", "fixedPerformTime", "", "taskName", "lastPerformConfigPath", "", "countdowns", "", "compensateMissedTask", "", "<init>", "(Ljava/lang/Long;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;Ljava/util/List;Z)V", "value", "Lorg/kingdoms/managers/abstraction/ProlongedDurationTask$State;", "state", "getState", "()Lorg/kingdoms/managers/abstraction/ProlongedDurationTask$State;", "setState", "(Lorg/kingdoms/managers/abstraction/ProlongedDurationTask$State;)V", "stopwatch", "Lorg/kingdoms/utils/time/stopwatch/Stopwatch;", "getStopwatch", "()Lorg/kingdoms/utils/time/stopwatch/Stopwatch;", "hasStartedSinceLastServerStart", "task", "Lorg/kingdoms/scheduler/DelayedTask;", "validateStateSync", "", "stateMismatch", "isRunning", "pause", "resume", "renewStopTask", "duration", "Ljava/time/Duration;", "getDuration", "()Ljava/time/Duration;", "stop", "runAndSet", "run", "getPassedTime", "getTimeLeftUntilStop", "State", "core"})
@SourceDebugExtension(value={"SMAP\nProlongedDurationTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProlongedDurationTask.kt\norg/kingdoms/managers/abstraction/ProlongedDurationTask\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,124:1\n1#2:125\n*E\n"})
public abstract class ProlongedDurationTask
extends ProlongedTask {
    @NotNull
    private State state;
    @NotNull
    private final Stopwatch stopwatch;
    private boolean hasStartedSinceLastServerStart;
    @Nullable
    private DelayedTask task;

    public ProlongedDurationTask(@Nullable Long interval, @Nullable String fixedPerformTime, @NotNull String taskName, @NotNull String[] lastPerformConfigPath, @NotNull List<String> countdowns, boolean compensateMissedTask) {
        Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
        Intrinsics.checkNotNullParameter((Object)lastPerformConfigPath, (String)"lastPerformConfigPath");
        Intrinsics.checkNotNullParameter(countdowns, (String)"countdowns");
        super(interval, fixedPerformTime, taskName, lastPerformConfigPath, countdowns, compensateMissedTask);
        this.state = State.NOT_STARTED;
        this.stopwatch = Stopwatch.Companion.withMillisAccuracy$default(Stopwatch.Companion, null, 1, null);
    }

    @NotNull
    public final State getState() {
        return this.state;
    }

    protected final void setState(@NotNull State value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        this.validateStateSync();
        if (this.state == value) {
            throw new IllegalArgumentException("State already set: " + (Object)((Object)value));
        }
        this.state = value;
    }

    @NotNull
    protected final Stopwatch getStopwatch() {
        return this.stopwatch;
    }

    private final void validateStateSync() {
        switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
            case 1: {
                if (this.stopwatch.getState() == StopwatchState.NOT_STARTED) break;
                boolean $i$a$-require-ProlongedDurationTask$validateStateSync$42 = false;
                String $i$a$-require-ProlongedDurationTask$validateStateSync$42 = this.stateMismatch();
                throw new IllegalArgumentException($i$a$-require-ProlongedDurationTask$validateStateSync$42.toString());
            }
            case 2: {
                if (this.stopwatch.getState() == StopwatchState.TICKING) break;
                boolean $i$a$-require-ProlongedDurationTask$validateStateSync$52 = false;
                String $i$a$-require-ProlongedDurationTask$validateStateSync$52 = this.stateMismatch();
                throw new IllegalArgumentException($i$a$-require-ProlongedDurationTask$validateStateSync$52.toString());
            }
            case 3: {
                if (this.stopwatch.getState() == StopwatchState.PAUSED) break;
                boolean bl = false;
                String string = this.stateMismatch();
                throw new IllegalArgumentException(string.toString());
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private final String stateMismatch() {
        return "State mismatch. Task::" + (Object)((Object)this.state) + " | Stopwatch::" + (Object)((Object)this.stopwatch.getState());
    }

    public final boolean isRunning() {
        this.validateStateSync();
        return this.state == State.RUNNING;
    }

    public final void pause() {
        block0: {
            this.setState(State.PAUSED);
            this.stopwatch.pause();
            DelayedTask delayedTask = this.task;
            if (delayedTask == null) break block0;
            delayedTask.cancel();
        }
    }

    public final void resume() {
        this.setState(State.RUNNING);
        this.stopwatch.resume();
        this.renewStopTask();
    }

    protected final void renewStopTask() {
        DelayedTask delayedTask = this.task;
        if (delayedTask != null) {
            delayedTask.cancel();
        }
        Duration duration = this.getDuration();
        Duration elapsed = this.stopwatch.getElapsed();
        Duration remaining = duration.minus(elapsed);
        TaskScheduler taskScheduler = Kingdoms.taskScheduler().async();
        Intrinsics.checkNotNull((Object)remaining);
        this.task = taskScheduler.delayed(remaining, () -> ProlongedDurationTask.renewStopTask$lambda$3(this));
    }

    @NotNull
    public abstract Duration getDuration();

    @MustBeInvokedByOverriders
    public void stop() {
        this.setState(State.NOT_STARTED);
        this.stopwatch.reset();
    }

    @Override
    public void runAndSet() {
        Duration adjusted = this.getPassedTime();
        if (adjusted != null) {
            this.run();
        } else {
            super.runAndSet();
        }
    }

    @Override
    @MustBeInvokedByOverriders
    public void run() {
        if (!this.hasStartedSinceLastServerStart) {
            this.hasStartedSinceLastServerStart = true;
            Duration passedTime = this.getPassedTime();
            if (passedTime != null) {
                this.stopwatch.setElapsed(passedTime);
            }
        }
        this.setState(State.RUNNING);
        this.stopwatch.start();
        this.renewStopTask();
    }

    private final Duration getPassedTime() {
        LocalDateTime lastPerform = this.lastPerform();
        Duration taskDuration = this.getDuration();
        if (lastPerform != null) {
            LocalDateTime now = LocalDateTime.now(TimeZoneHandler.SERVER_TIME_ZONE);
            long runningDuration = ChronoUnit.MILLIS.between(lastPerform, now);
            if (taskDuration.toMillis() > runningDuration) {
                return Duration.ofMillis(runningDuration);
            }
        }
        return null;
    }

    @NotNull
    public final Duration getTimeLeftUntilStop() {
        Duration duration;
        if (this.state != State.RUNNING) {
            throw new IllegalStateException("Task isn't running: " + this);
        }
        long diff = this.stopwatch.getElapsed().toMillis();
        Duration left = this.getDuration().minusMillis(diff);
        if (left.isNegative()) {
            Duration duration2 = Duration.ZERO;
            duration = duration2;
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ZERO");
        } else {
            Intrinsics.checkNotNull((Object)left);
            duration = left;
        }
        return duration;
    }

    private static final void renewStopTask$lambda$3(ProlongedDurationTask this$0) {
        this$0.stop();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/kingdoms/managers/abstraction/ProlongedDurationTask$State;", "", "<init>", "(Ljava/lang/String;I)V", "NOT_STARTED", "RUNNING", "PAUSED", "core"})
    public static final class State
    extends Enum<State> {
        public static final /* enum */ State NOT_STARTED = new State();
        public static final /* enum */ State RUNNING = new State();
        public static final /* enum */ State PAUSED = new State();
        private static final /* synthetic */ State[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value) {
            return Enum.valueOf(State.class, value);
        }

        @NotNull
        public static EnumEntries<State> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = stateArray = new State[]{State.NOT_STARTED, State.RUNNING, State.PAUSED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[State.values().length];
            try {
                nArray[State.NOT_STARTED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.RUNNING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.PAUSED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

