/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import org.kingdoms.main.Kingdoms;

public final class TempKingdomsFolder {
    private static final Path TEMP = Kingdoms.getPath("temp");

    public static Path getOrCreateFile(String name) {
        Path path = TEMP.resolve(name);
        TempKingdomsFolder.ensureCreated(TEMP);
        return path;
    }

    public static Path getOrCreateFolder(String name) {
        Path path = TEMP.resolve(name);
        TempKingdomsFolder.ensureCreated(path);
        return path;
    }

    private static void ensureCreated(Path path) {
        try {
            boolean tempExists = Files.exists(TEMP, new LinkOption[0]);
            Files.createDirectories(path, new FileAttribute[0]);
            if (!tempExists) {
                Files.write(TEMP.resolve("README.txt"), Arrays.asList("This folder stores temporary files.", "These entire folder and its files can safely be deleted."), StandardCharsets.US_ASCII, new OpenOption[0]);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create temporary kingdoms folder: " + path, e);
        }
    }
}

