/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers;

import java.time.Duration;
import java.util.Collection;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.plugin.Plugin;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.Nation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.KingdomsChatChannel;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.LanguageManager;
import org.kingdoms.locale.SupportedLanguage;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.daily.TaxManager;
import org.kingdoms.managers.daily.elections.Elections;
import org.kingdoms.managers.invasions.InvasionManager;
import org.kingdoms.managers.land.holograms.TemporaryBuildingVisuals;
import org.kingdoms.managers.land.indicator.LandVisualizer;
import org.kingdoms.managers.land.map.KingdomsMap;
import org.kingdoms.permissions.KingdomsDefaultPluginPermission;
import org.kingdoms.platform.bukkit.adapters.BukkitAdapter;
import org.kingdoms.services.managers.ServiceHandler;
import org.kingdoms.utils.PlayerUtils;
import org.kingdoms.utils.display.scoreboard.XScoreboard;
import org.kingdoms.utils.internal.numbers.Numbers;
import org.kingdoms.utils.versionsupport.VersionSupport;

public final class JoinAndLeaveManager
implements Listener {
    private static boolean showJoinLeaveMessages(Player player, boolean joining) {
        return KingdomsConfig.JOIN_LEAVE_MESSAGES.getBoolean() && !(joining ? KingdomsDefaultPluginPermission.SILENT_JOIN : KingdomsDefaultPluginPermission.SILENT_LEAVE).hasPermission((CommandSender)player) && !ServiceHandler.isVanished(player);
    }

    private static void sendMessage(KingdomsLang lang, Predicate<Player> filter, Player player, boolean console) {
        MessagePlaceholderProvider settings = new MessagePlaceholderProvider().withContext(player);
        Collection players = filter == null ? Bukkit.getOnlinePlayers() : (Iterable)Bukkit.getOnlinePlayers().stream().filter(filter).collect(Collectors.toList());
        players.forEach(p -> lang.sendMessage((CommandSender)p, settings.other((Player)p)));
        if (console) {
            lang.sendMessage((CommandSender)Bukkit.getConsoleSender(), settings);
        }
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        int unreadMails;
        XScoreboard scoreboard;
        Player player = event.getPlayer();
        PlayerUtils.cachePlayer(player);
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        Kingdom kingdom = kp.getKingdom();
        InvasionManager.showBossBars(player, kingdom);
        kp.updatePower(false);
        TemporaryBuildingVisuals.removeAll(player);
        if (!kp.getInvites().isEmpty()) {
            KingdomsLang.JOIN_INVITES.sendMessage((CommandSender)player, "invites", kp.getInvites().size());
        }
        Kingdoms.taskScheduler().async().delayed(Duration.ofSeconds(5L), () -> {
            if (KingdomsConfig.FORCE_LANG.getManager().getBoolean()) {
                kp.setLanguage(LanguageManager.getDefaultLanguage());
            } else if (!player.hasPlayedBefore()) {
                if (KingdomsConfig.Powers.POWER_ENABLED.getManager().getBoolean()) {
                    double initial = KingdomsConfig.Powers.POWER_PLAYER_INITIAL.getManager().getDouble();
                    kp.setPower(initial, true);
                }
                if (VersionSupport.SUPPORTS_Player_getLocale) {
                    String detectedLocale = player.getLocale();
                    SupportedLanguage chosen = SupportedLanguage.fromName(detectedLocale);
                    if (chosen == null || !chosen.isInstalled()) {
                        KingdomsLang.JOIN_LANGUAGE_NOT_SUPPORTED.sendError((CommandSender)player, "detected-lang", detectedLocale);
                        kp.setLanguage(LanguageManager.getDefaultLanguage());
                    } else {
                        kp.setLanguage(chosen);
                        KingdomsLang.JOIN_LANGUAGE_SUPPORTED.sendMessage((CommandSender)player, "detected-lang", detectedLocale);
                    }
                }
            }
        });
        if (JoinAndLeaveManager.showJoinLeaveMessages(player, true)) {
            event.setJoinMessage(null);
            Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)Kingdoms.get(), () -> {
                if (kingdom == null) {
                    JoinAndLeaveManager.sendMessage(KingdomsLang.JOIN_LEAVE_MESSAGES_JOIN_OTHERS, null, player, true);
                } else {
                    JoinAndLeaveManager.sendMessage(KingdomsLang.JOIN_LEAVE_MESSAGES_JOIN_KINGDOM, kingdom::isMember, player, false);
                    JoinAndLeaveManager.sendMessage(KingdomsLang.JOIN_LEAVE_MESSAGES_JOIN_OTHERS, players -> !kingdom.isMember((OfflinePlayer)players), player, true);
                }
            }, 20L);
        }
        if ((scoreboard = KingdomsMap.SCOREBOARDS.get(player.getUniqueId())) != null) {
            scoreboard.addPlayer(player);
        }
        if (kingdom == null) {
            if (KingdomsConfig.NO_KINGDOM_REMINDER.getBoolean() && kp.getJoinedAt() != 0L) {
                KingdomsLang.NO_KINGDOM_REMINDER.sendMessage((CommandSender)player);
            }
            return;
        }
        if (kp.hasPermission(StandardKingdomPermission.READ_MAILS) && (unreadMails = kp.countUnreadMails(kingdom.getMails())) > 0) {
            KingdomsLang.JOIN_UNREAD_MAILS.sendMessage((CommandSender)player, "unread-mails", unreadMails);
        }
        Elections.ALL.forEach(x -> x.notifyPlayer(player));
        if (player.getBedSpawnLocation() == null || KingdomsConfig.HOME_RESPAWN_UNLESS_HAS_BED.getBoolean()) {
            Nation nation;
            Location spawn = null;
            if (kingdom.hasNation() && KingdomsConfig.HOME_ON_JOIN_NATION_SPAWN.getBoolean() && (nation = kingdom.getNation()) != null && kp.hasNationPermission(StandardKingdomPermission.HOME)) {
                spawn = BukkitAdapter.adapt(nation.getHome());
            }
            if (spawn == null && KingdomsConfig.HOME_ON_JOIN_KINGDOM_HOME.getBoolean() && kp.hasPermission(StandardKingdomPermission.HOME)) {
                spawn = BukkitAdapter.adapt(kingdom.getHome());
            }
            if (spawn != null) {
                player.teleport(spawn);
            }
        }
        if (KingdomsConfig.TAX_KINGDOMS_ENABLED.getBoolean() && KingdomsConfig.TAX_KINGDOMS_NOTIFICATIONS.getBoolean() && TaxManager.needsToPayTaxes(kingdom)) {
            Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)Kingdoms.get(), () -> {
                double tax = kingdom.calculateTax();
                if (!kingdom.getBank().has(tax)) {
                    KingdomsLang.TAX_NOTIFICATIONS.sendMessage((CommandSender)player, "tax", Numbers.toFancyNumber(tax));
                }
            }, 60L);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onRespawn(PlayerRespawnEvent event) {
        Nation nation;
        Player player = event.getPlayer();
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        if (!kp.hasKingdom()) {
            return;
        }
        Kingdom kingdom = kp.getKingdom();
        Location spawn = null;
        if (kingdom.hasNation() && KingdomsConfig.HOME_RESPAWN_NATION_SPAWN.getBoolean() && (nation = kingdom.getNation()) != null && kp.hasNationPermission(StandardKingdomPermission.HOME)) {
            spawn = BukkitAdapter.adapt(nation.getHome());
        }
        if (spawn == null && KingdomsConfig.HOME_RESPAWN_KINGDOM_HOME.getBoolean() && kp.hasPermission(StandardKingdomPermission.HOME)) {
            spawn = BukkitAdapter.adapt(kingdom.getHome());
        }
        if (spawn != null && spawn.getWorld() != null) {
            event.setRespawnLocation(spawn);
        }
    }

    @EventHandler
    public void onLeave(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        Kingdom kingdom = kp.getKingdom();
        kp.updatePower(true);
        if (JoinAndLeaveManager.showJoinLeaveMessages(player, false)) {
            event.setQuitMessage(null);
            if (kingdom == null) {
                JoinAndLeaveManager.sendMessage(KingdomsLang.JOIN_LEAVE_MESSAGES_LEAVE_OTHERS, null, player, true);
            } else {
                JoinAndLeaveManager.sendMessage(KingdomsLang.JOIN_LEAVE_MESSAGES_LEAVE_KINGDOM, kingdom::isMember, player, false);
                JoinAndLeaveManager.sendMessage(KingdomsLang.JOIN_LEAVE_MESSAGES_LEAVE_OTHERS, players -> !kingdom.isMember((OfflinePlayer)players), player, true);
            }
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)Kingdoms.get(), () -> {
            LandVisualizer.removeVisualizers(player, false);
            if (!KingdomsConfig.Chat.RESET_CHANNEL_ON_LEAVE.getManager().getBoolean()) {
                kp.setChatChannel(KingdomsChatChannel.getGlobalChannel());
            }
        });
        if (kingdom == null) {
            return;
        }
        kp.setFlying(false, null);
        if (!KingdomsConfig.KEEP_ADMIN_MODE.getBoolean()) {
            kp.setAdmin(false);
        }
    }
}

