/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.kingdoms.data.Pair;
import org.kingdoms.libs.xseries.XEnchantment;
import org.kingdoms.libs.xseries.XMaterial;
import org.kingdoms.libs.xseries.reflection.XReflection;
import org.kingdoms.nbt.tag.NBTTag;
import org.kingdoms.nbt.tag.NBTTagCompound;
import org.kingdoms.utils.cache.single.CachedSupplier;
import org.kingdoms.utils.compilers.ConditionalCompiler;
import org.kingdoms.utils.compilers.MathCompiler;
import org.kingdoms.utils.compilers.expressions.ConditionalExpression;
import org.kingdoms.utils.config.ConfigSection;
import org.kingdoms.utils.internal.numbers.AnyNumber;
import org.kingdoms.utils.internal.string.NumberMatcher;
import org.kingdoms.utils.internal.string.StringMatcher;
import org.kingdoms.utils.string.Strings;

public class ItemMatcher {
    private final StringMatcher name;
    private final StringMatcher lore;
    private final StringMatcher material;
    private final NumberMatcher customModelData;
    private final List<Pair<XEnchantment, ConditionalExpression>> enchants;
    private final Pair<String[], StringMatcher>[] NBT;
    private final ConfigSection section;

    public ItemMatcher(ConfigSection section) {
        ConfigSection nbt;
        Objects.requireNonNull(section, "Cannot parse item matcher of a null section");
        this.section = section.getSection(new String[0]);
        String mat = section.getString("material");
        this.material = mat != null ? StringMatcher.fromString(mat) : null;
        this.customModelData = NumberMatcher.parse(section.getString("custom-model-data"));
        String name = section.getString("name");
        this.name = name != null ? StringMatcher.fromString(name) : null;
        String lore = section.getString("lore");
        this.lore = lore != null ? StringMatcher.fromString(lore) : null;
        ConfigSection enchantsSection = section.getSection("enchants");
        if (enchantsSection != null) {
            this.enchants = new ArrayList<Pair<XEnchantment, ConditionalExpression>>();
            for (String key : enchantsSection.getKeys()) {
                String conditionStr = enchantsSection.getString(key);
                int asLvl = enchantsSection.getInt(key);
                XEnchantment enchant = (XEnchantment)XEnchantment.of((String)key).orElseThrow(() -> new IllegalArgumentException("Unknown enchantment: " + key));
                ConditionalCompiler.LogicalOperand condition = conditionStr.equals("*") ? ConditionalCompiler.ConstantLogicalOperand.TRUE : (asLvl == 0 && !conditionStr.equals("0") ? ConditionalCompiler.compile(conditionStr).evaluate() : new ConditionalCompiler.BiLogicalOperator(new ConditionalCompiler.LogicalVariableOperand("lvl"), ConditionalCompiler.LogicalOperator.EQUALS, new ConditionalCompiler.ArithmeticOperand(new MathCompiler.ConstantExpr(asLvl, MathCompiler.ConstantExprType.NUMBER))));
                this.enchants.add(Pair.of(enchant, condition));
            }
        } else {
            this.enchants = null;
        }
        if ((nbt = section.getSection("nbt")) != null) {
            Set<String> keys = nbt.getKeys();
            this.NBT = new Pair[keys.size()];
            int i = 0;
            for (String key : keys) {
                String[] splits = Strings.splitArray(key, '.');
                StringMatcher checker = StringMatcher.fromString(nbt.getString(key));
                this.NBT[i++] = Pair.of(splits, checker);
            }
        } else {
            this.NBT = new Pair[0];
        }
    }

    public ConfigSection getSection() {
        return this.section;
    }

    public boolean matchesMaterial(ItemStack item) {
        return this.material == null || this.material.matches(XMaterial.matchXMaterial((ItemStack)item).name());
    }

    public boolean matches(ItemStack item) {
        return this.matches(item, null);
    }

    public boolean matches(ItemStack item, CachedSupplier<NBTTagCompound> nbt) {
        return this.matches(item, item.getItemMeta(), nbt);
    }

    public boolean matches(ItemStack item, ItemMeta meta, CachedSupplier<NBTTagCompound> nbt) {
        if (!this.matchesMaterial(item)) {
            return false;
        }
        if (!this.matchesCustomModel(meta)) {
            return false;
        }
        if (!this.matchesEnchants(meta == null ? null : meta.getEnchants())) {
            return false;
        }
        if (!this.matchesName(meta) || !this.matchesLore(meta)) {
            return false;
        }
        return nbt == null || !this.needsNBT() || this.matchesNBT(nbt.get());
    }

    public boolean matchesEnchants(Map<Enchantment, Integer> enchants) {
        if (this.enchants == null) {
            return true;
        }
        if (this.enchants.isEmpty()) {
            return true;
        }
        if (enchants == null || enchants.isEmpty()) {
            return false;
        }
        for (Pair<XEnchantment, ConditionalExpression> enchant : this.enchants) {
            Integer lvl = enchants.get(enchant.getKey().get());
            if (lvl == null) {
                return false;
            }
            ConditionalExpression requiredLvl = enchant.getValue();
            boolean passed = requiredLvl.eval(x -> x.equals("lvl") ? lvl : null);
            if (passed) continue;
            return false;
        }
        return true;
    }

    public boolean needsNBT() {
        return this.NBT != null;
    }

    public boolean matchesName(ItemMeta meta) {
        if (this.name == null) {
            return true;
        }
        if (meta == null || !meta.hasDisplayName()) {
            return false;
        }
        return this.name.matches(meta.getDisplayName());
    }

    public boolean matchesLore(ItemMeta meta) {
        if (this.lore == null) {
            return true;
        }
        if (meta == null || !meta.hasLore()) {
            return false;
        }
        for (String line : meta.getLore()) {
            if (!this.lore.matches(line)) continue;
            return true;
        }
        return false;
    }

    public boolean matchesCustomModel(ItemMeta meta) {
        if (!XReflection.supports((int)14)) {
            return true;
        }
        if (this.customModelData == null) {
            return true;
        }
        if (meta == null) {
            return false;
        }
        if (!meta.hasCustomModelData()) {
            return false;
        }
        return this.customModelData.matches(AnyNumber.of(meta.getCustomModelData()));
    }

    public boolean matchesNBT(NBTTagCompound nbt) {
        for (Pair<String[], StringMatcher> tag : this.NBT) {
            NBTTagCompound last = null;
            int times = 0;
            for (String name : tag.getKey()) {
                ++times;
                NBTTag current = (NBTTag)(last == null ? nbt : last).value().get(name);
                if (current == null) {
                    return false;
                }
                if (current instanceof NBTTagCompound) {
                    last = (NBTTagCompound)current;
                    continue;
                }
                if (times == tag.getKey().length) {
                    Object value = current.value();
                    if (value == null) {
                        return false;
                    }
                    if (tag.getValue().matches(value.toString())) continue;
                    return false;
                }
                return false;
            }
        }
        return true;
    }
}

