/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers;

import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.abstraction.KingdomBuilding;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.events.general.KingdomDisbandEvent;
import org.kingdoms.events.members.KingdomLeaveEvent;
import org.kingdoms.gui.InteractiveGUI;
import org.kingdoms.gui.InteractiveGUIManager;
import org.kingdoms.managers.chat.ChatInputManager;

public final class GUIProtectionInterrupter
implements Listener {
    public static final Map<SimpleLocation, CopyOnWriteArrayList<Player>> ONGOING_CONVERSATIONS = new HashMap<SimpleLocation, CopyOnWriteArrayList<Player>>();
    public static final Map<SimpleLocation, CopyOnWriteArrayList<Player>> OPENED_GUI = new HashMap<SimpleLocation, CopyOnWriteArrayList<Player>>();
    public static final Map<Player, SimpleLocation> OPENED_GUI_PLAYER = new HashMap<Player, SimpleLocation>();
    private static final Map<UUID, Set<InterruptHandle>> OPEN_MEMBER_GUIS = new HashMap<UUID, Set<InterruptHandle>>();
    private static long lastCleanup = 0L;
    private static final long CLEANUP_INTERVAL_MILLIS = Duration.ofHours(1L).toMillis();

    private static void cleanup() {
        long now = System.currentTimeMillis();
        long timePassed = now - lastCleanup;
        if (CLEANUP_INTERVAL_MILLIS - timePassed > 0L) {
            return;
        }
        lastCleanup = now;
        OPEN_MEMBER_GUIS.values().removeIf(Set::isEmpty);
    }

    public static void watchKingdomMember(UUID player, InteractiveGUI gui, Runnable action) {
        GUIProtectionInterrupter.cleanup();
        OPEN_MEMBER_GUIS.compute(player, (k, v) -> {
            if (v == null) {
                v = Collections.newSetFromMap(new WeakHashMap());
            }
            v.add(new InterruptHandle(gui, action));
            return v;
        });
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onMemberLeave(KingdomLeaveEvent event) {
        Set<InterruptHandle> openGUIs = OPEN_MEMBER_GUIS.remove(event.getPlayer().getId());
        if (openGUIs == null) {
            return;
        }
        openGUIs.forEach(rec$ -> ((InterruptHandle)rec$).handle());
    }

    protected static boolean removeLandManager(Player player) {
        SimpleLocation loc = OPENED_GUI_PLAYER.remove(player);
        if (loc != null) {
            List players = OPENED_GUI.get(loc);
            if (players != null) {
                players.remove(player);
                if (players.isEmpty()) {
                    OPENED_GUI.remove(loc);
                }
            }
            return true;
        }
        return false;
    }

    public static void cancelAllConversations(KingdomBuilding<?> building, UUID ignoring) {
        List talking = ONGOING_CONVERSATIONS.get(building.getOrigin());
        if (talking != null) {
            for (Player player : talking) {
                if (player.getUniqueId().equals(ignoring)) continue;
                ChatInputManager.endConversation(player);
            }
        }
    }

    public static void handleConversation(KingdomBuilding<?> building, Player player) {
        ONGOING_CONVERSATIONS.compute(building.getOrigin(), (k, list) -> {
            if (list == null) {
                list = new CopyOnWriteArrayList<Player>();
            }
            list.add(player);
            return list;
        });
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onKingdomDisband(KingdomDisbandEvent event) {
        Kingdom kingdom = event.getKingdom();
        for (Player member : kingdom.getOnlineMembers()) {
            if (!GUIProtectionInterrupter.end(member, true)) continue;
            member.closeInventory();
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onLeave(KingdomLeaveEvent event) {
        Player player = event.getPlayer().getPlayer();
        if (player != null && GUIProtectionInterrupter.end(player, true)) {
            player.closeInventory();
        }
    }

    private static boolean end(Player player, boolean onlyIfActiveLand) {
        if (!GUIProtectionInterrupter.removeLandManager(player) && onlyIfActiveLand) {
            return false;
        }
        InteractiveGUI gui = InteractiveGUIManager.getGuis().remove(player.getEntityId());
        if (gui != null) {
            gui.cancelRefreshTask();
        }
        return true;
    }

    private static final class InterruptHandle {
        public final InteractiveGUI gui;
        public final Runnable action;

        private InterruptHandle(InteractiveGUI gui, Runnable action) {
            this.gui = gui;
            this.action = action;
        }

        private void handle() {
            this.gui.close();
            if (this.action != null) {
                this.action.run();
            }
        }
    }
}

