/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers;

import com.google.common.base.Strings;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.config.accessor.ConfigAccessor;
import org.kingdoms.config.accessor.KeyedConfigAccessor;
import org.kingdoms.constants.economy.Balance;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.model.relationships.RelationAttribute;
import org.kingdoms.constants.group.model.relationships.StandardRelationAttribute;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.land.structures.objects.Regulator;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.data.Pair;
import org.kingdoms.events.general.KingdomDisbandEvent;
import org.kingdoms.events.lands.LandChangeEvent;
import org.kingdoms.events.lands.UnclaimLandEvent;
import org.kingdoms.events.members.KingdomLeaveEvent;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.main.KLogger;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.AfkF24Manager;
import org.kingdoms.managers.pvp.PvPManager;
import org.kingdoms.permissions.KingdomsDefaultPluginPermission;
import org.kingdoms.services.ServiceVault;
import org.kingdoms.services.managers.ServiceHandler;
import org.kingdoms.services.managers.SoftService;
import org.kingdoms.utils.MathUtils;
import org.kingdoms.utils.PlayerUtils;
import org.kingdoms.utils.compilers.ConditionalCompiler;
import org.kingdoms.utils.compilers.expressions.ConditionalExpression;
import org.kingdoms.utils.config.ConfigSection;
import org.kingdoms.utils.debugging.DebugNS;
import org.kingdoms.utils.debugging.KingdomsDebug;
import org.kingdoms.utils.hash.EntityHashSet;
import org.kingdoms.utils.hash.EntityWeakHashSet;
import org.kingdoms.utils.internal.numbers.AnyNumber;
import org.kingdoms.utils.internal.numbers.Numbers;
import org.kingdoms.utils.internal.string.NumberMatcher;

public final class FlyManager
implements Listener {
    private static final Map<UUID, BukkitTask> WARNINGS_LAND = new HashMap<UUID, BukkitTask>();
    private static final Map<UUID, BukkitTask> WARNINGS_UNFRIENDLY = new HashMap<UUID, BukkitTask>();
    private static final Map<UUID, BukkitTask> WARNINGS_CHARGES = new HashMap<UUID, BukkitTask>();
    private static final Map<UUID, FlightSession> SESSIONS = new HashMap<UUID, FlightSession>();
    private static final EntityWeakHashSet<Player> PREVENT_FALL_DAMAGE = ((EntityHashSet.WeakBuilder)((EntityHashSet.WeakBuilder)EntityHashSet.weakBuilder(Player.class).onDeath(EntityHashSet::remove)).onLeave(EntityHashSet::remove)).build();
    private static final FlightAFKCharge AFK = FlightAFKCharge.parse(KingdomsConfig.KINGDOM_FLY_CHARGES_AFK.getSection());

    public static FlightSession getCharges(Player player) {
        return SESSIONS.computeIfAbsent(player.getUniqueId(), k -> new FlightSession());
    }

    public static float getDefaultSpeed(Player player) {
        String targetNode = "kingdoms.flight.speed.default.";
        for (PermissionAttachmentInfo perm : player.getEffectivePermissions()) {
            String node = perm.getPermission();
            if (!node.startsWith(targetNode)) continue;
            String num = node.substring(targetNode.length());
            AnyNumber number = AnyNumber.of(num);
            if (number == null) {
                KLogger.error("Found /k fly default speed permission with wrong number: '" + num + "' (full: '" + node + "')");
                continue;
            }
            return number.getValue().floatValue();
        }
        return (float)KingdomsConfig.KINGDOM_FLY_SPEED.getDouble();
    }

    public static List<NumberMatcher> getUsableSpeeds(Player player, float speed, AtomicBoolean canUse) {
        String targetNode = "kingdoms.flight.speed.range.";
        ArrayList<NumberMatcher> allowedSpeeds = new ArrayList<NumberMatcher>();
        AnyNumber anySpeed = AnyNumber.of(speed);
        for (PermissionAttachmentInfo perm : player.getEffectivePermissions()) {
            String node = perm.getPermission();
            if (!node.startsWith(targetNode)) continue;
            String numberMatcherStr = node.substring(targetNode.length());
            try {
                NumberMatcher matcher = NumberMatcher.parse(numberMatcherStr);
                allowedSpeeds.add(matcher);
                if (matcher == null) {
                    KLogger.error("Found /k fly speed permission with wrong number matcher: '" + numberMatcherStr + "' (full: '" + node + "')");
                    continue;
                }
                if (!matcher.matches(anySpeed)) continue;
                canUse.set(true);
            }
            catch (Exception ex) {
                KLogger.error("Found /k fly speed permission with wrong number matcher: '" + node + "' " + ex.getMessage());
            }
        }
        if (allowedSpeeds.isEmpty()) {
            canUse.set(true);
        }
        return allowedSpeeds;
    }

    public static void preventFallDamage(Player entity2) {
        PREVENT_FALL_DAMAGE.add(entity2);
    }

    @EventHandler
    public void onFlightDisableDamage(EntityDamageEvent event) {
        if (event.getCause() != EntityDamageEvent.DamageCause.FALL) {
            return;
        }
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        if (!PREVENT_FALL_DAMAGE.remove((Player)event.getEntity())) {
            return;
        }
        event.setCancelled(true);
        KLogger.debug((DebugNS)KingdomsDebug.FALL$DAMAGE, () -> "Prevented fall damage for " + event.getEntity());
    }

    public static boolean handleCharges(Player player, KingdomPlayer kp, Pair<KeyedConfigAccessor, KingdomsLang> playerCosts, Pair<KeyedConfigAccessor, KingdomsLang> kingdomCosts) {
        Balance usedBalance;
        String kingdomEqn;
        String chargesEqn;
        Kingdom kingdom = kp.getKingdom();
        Runnable finalizePlayerCosts = null;
        if (SoftService.VAULT.isAvailable() && ServiceVault.isAvailable(ServiceVault.Component.ECO) && !Strings.isNullOrEmpty((String)(chargesEqn = playerCosts.getKey().forWorld((Entity)player).getString()))) {
            double playerCharges = MathUtils.eval(chargesEqn, (OfflinePlayer)player, new Object[0]);
            if (ServiceVault.hasMoney((OfflinePlayer)player, playerCharges)) {
                finalizePlayerCosts = () -> {
                    ServiceVault.withdraw((OfflinePlayer)player, playerCharges);
                    FlightSession charges = FlyManager.getCharges(player);
                    charges.playerCharges += playerCharges;
                    if (KingdomsConfig.KINGDOM_FLY_CHARGES_PLAYERS_PAY_KINGDOM_ENABLED.getBoolean()) {
                        boolean useRp = KingdomsConfig.KINGDOM_FLY_CHARGES_PLAYERS_PAY_KINGDOM_RESOURCE_POINTS.getBoolean();
                        if (useRp) {
                            kingdom.getResourcePoints().add(playerCharges);
                            charges.kingdomChargesRp -= playerCharges;
                        } else {
                            kingdom.getBank().add(playerCharges);
                            charges.kingdomChargesBank -= playerCharges;
                        }
                    }
                };
            } else {
                playerCosts.getValue().sendError((CommandSender)player, "money", Numbers.toFancyNumber(playerCharges), "interval", KingdomsConfig.KINGDOM_FLY_CHARGES_EVERY_SECONDS.getInt());
                return false;
            }
        }
        if (Strings.isNullOrEmpty((String)(kingdomEqn = kingdomCosts.getKey().forWorld((Entity)player).getString()))) {
            if (finalizePlayerCosts != null) {
                finalizePlayerCosts.run();
            }
            return true;
        }
        double kingdomCharges = MathUtils.eval(kingdomEqn, (OfflinePlayer)player, new Object[0]);
        boolean useRp = KingdomsConfig.KINGDOM_FLY_CHARGES_KINGDOMS_RESOURCE_POINTS.getBoolean();
        Balance balance = usedBalance = useRp ? kingdom.getResourcePoints() : kingdom.getBank();
        if (usedBalance.has(kingdomCharges)) {
            usedBalance.subtract(kingdomCharges);
            if (useRp) {
                FlyManager.getCharges(player).kingdomChargesRp -= kingdomCharges;
            } else {
                FlyManager.getCharges(player).kingdomChargesBank -= kingdomCharges;
            }
        } else {
            kingdomCosts.getValue().sendError((CommandSender)player, "amount", Numbers.toFancyNumber(kingdomCharges), "interval", KingdomsConfig.KINGDOM_FLY_CHARGES_EVERY_SECONDS.getInt());
            return false;
        }
        if (finalizePlayerCosts != null) {
            finalizePlayerCosts.run();
        }
        return true;
    }

    private static void handleCharges(Player player) {
        if (!player.getAllowFlight() || !player.isFlying()) {
            return;
        }
        if (KingdomsDefaultPluginPermission.FLIGHT_BYPASS_CHARGES.hasPermission((CommandSender)player)) {
            return;
        }
        if (PlayerUtils.invulnerableGameMode(player)) {
            return;
        }
        if (WARNINGS_CHARGES.containsKey(player.getUniqueId())) {
            return;
        }
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        if (!kp.isFlying() || kp.isAdmin()) {
            return;
        }
        if (!FlyManager.handleCharges(player, kp, Pair.of(KingdomsConfig.KINGDOM_FLY_CHARGES_PLAYERS_AMOUNT.getManager(), KingdomsLang.FLY_CHARGES_CANT_AFFORD), Pair.of(KingdomsConfig.KINGDOM_FLY_CHARGES_KINGDOMS_AMOUNT.getManager(), KingdomsLang.FLY_CHARGES_CANT_AFFORD_KINGDOM))) {
            FlyManager.handleCantPay(player, kp);
        }
    }

    private static void handleCantPay(final Player player, final KingdomPlayer kp) {
        final int warning = KingdomsConfig.KINGDOM_FLY_WARNINGS_CHARGES.getInt();
        if (warning <= 0) {
            FlyManager.disableFly(player, kp);
            return;
        }
        BukkitTask task = new BukkitRunnable(){
            int counter;
            {
                this.counter = warning;
            }

            public void run() {
                if (this.counter == 0) {
                    WARNINGS_CHARGES.remove(player.getUniqueId());
                    FlyManager.disableFlight(kp, player);
                    this.cancel();
                    return;
                }
                KingdomsLang.FLY_WARNINGS_CHARGES.sendError((CommandSender)player, "counter", this.counter);
                --this.counter;
            }
        }.runTaskTimerAsynchronously((Plugin)Kingdoms.get(), 0L, 20L);
        WARNINGS_CHARGES.put(player.getUniqueId(), task);
    }

    private static boolean isNearUnfriendly(final Player player, final int range, boolean action) {
        if (!player.getAllowFlight()) {
            return false;
        }
        if (KingdomsDefaultPluginPermission.FLIGHT_NEARBY$ENEMIES.hasPermission((CommandSender)player)) {
            return false;
        }
        if (PlayerUtils.invulnerableGameMode(player)) {
            return false;
        }
        final KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        if (!kp.isFlying() || kp.isAdmin()) {
            return false;
        }
        Kingdom kingdom = kp.getKingdom();
        for (Entity nearby : player.getNearbyEntities((double)range, (double)range, (double)range)) {
            Kingdom otherKingdom;
            KingdomPlayer enemyKp;
            Player enemy;
            if (!(nearby instanceof Player) || ServiceHandler.isNPC((Entity)(enemy = (Player)nearby)) || PlayerUtils.invulnerableGameMode(enemy) || (enemyKp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)enemy)).isInSneakMode() || kingdom.hasAttribute(otherKingdom = enemyKp.getKingdom(), (RelationAttribute)StandardRelationAttribute.FLY)) continue;
            if (action && !WARNINGS_UNFRIENDLY.containsKey(player.getUniqueId())) {
                final int warning = KingdomsConfig.KINGDOM_FLY_WARNINGS_UNFRIENDLY_NEARBY.getInt();
                if (warning <= 0) {
                    KingdomsLang.FLY_ENEMIES_NEARBY.sendError((CommandSender)player, new Object[0]);
                    FlyManager.disableFly(player, kp);
                } else {
                    BukkitTask task = new BukkitRunnable(){
                        int counter;
                        {
                            this.counter = warning;
                        }

                        public void run() {
                            if (!FlyManager.isNearUnfriendly(player, range, false)) {
                                KingdomsLang.FLY_WARNINGS_UNFRIENDLY_NEARBY_SAFE.sendMessage((CommandSender)player, "counter", this.counter);
                                WARNINGS_UNFRIENDLY.remove(player.getUniqueId());
                                this.cancel();
                                return;
                            }
                            if (this.counter == 0) {
                                KingdomsLang.FLY_ENEMIES_NEARBY.sendError((CommandSender)player, new Object[0]);
                                WARNINGS_UNFRIENDLY.remove(player.getUniqueId());
                                FlyManager.disableFlight(kp, player);
                                this.cancel();
                                return;
                            }
                            KingdomsLang.FLY_WARNINGS_UNFRIENDLY_NEARBY_WARN.sendError((CommandSender)player, "counter", this.counter);
                            --this.counter;
                        }
                    }.runTaskTimer((Plugin)Kingdoms.get(), 0L, 20L);
                    WARNINGS_UNFRIENDLY.put(player.getUniqueId(), task);
                }
            }
            return true;
        }
        return false;
    }

    private static boolean canFlyInLand(Player player, KingdomPlayer kp, Land to) {
        Kingdom kingdom;
        if (PlayerUtils.invulnerableGameMode(player)) {
            return true;
        }
        if (kp.isAdmin()) {
            return true;
        }
        Kingdom kingdom2 = kingdom = to == null ? null : to.getKingdom();
        if (kingdom == null) {
            return KingdomsConfig.KINGDOM_FLY_ALLOW_UNCLAIMED.getBoolean();
        }
        if (!kp.getKingdom().hasAttribute(kingdom, (RelationAttribute)StandardRelationAttribute.FLY)) {
            Boolean attr;
            Regulator regulator = to.getStructure(Regulator.class);
            if (regulator != null && (attr = regulator.hasAttribute(player.getUniqueId(), Regulator.Attribute.FLY)) != null) {
                return attr;
            }
            return false;
        }
        return true;
    }

    private static void cancelTasks(Player player) {
        UUID id = player.getUniqueId();
        BukkitTask task = WARNINGS_UNFRIENDLY.remove(id);
        if (task != null) {
            task.cancel();
        }
        if ((task = WARNINGS_LAND.remove(id)) != null) {
            task.cancel();
        }
    }

    private static void disableFlight(KingdomPlayer kp, Player player) {
        Bukkit.getScheduler().runTask((Plugin)Kingdoms.get(), () -> FlyManager.disableFly(player, kp));
    }

    public static void disableFly(Player player, KingdomPlayer kp) {
        kp.setFlying(false, null);
        FlyManager.noFallDamage(player);
        FlyManager.notifyAboutCharges(player);
    }

    public static void notifyAboutCharges(Player player) {
        FlightSession session = SESSIONS.remove(player.getUniqueId());
        if (session != null) {
            KingdomsLang.FLY_DISABLE_CHARGES.sendMessage((CommandSender)player, new MessagePlaceholderProvider().raw("player_charges", session.playerCharges).raw("kingdom_charges_rp", session.kingdomChargesRp).raw("kingdom_charges_bank", session.kingdomChargesBank));
        }
    }

    public static void noFallDamage(final Player player) {
        new BukkitRunnable(){
            private int tries;

            public void run() {
                ++this.tries;
                if (player.isOnGround()) {
                    PREVENT_FALL_DAMAGE.remove(player);
                    this.cancel();
                    return;
                }
                if (this.tries / 20 >= 2) {
                    this.cancel();
                }
            }
        }.runTaskTimerAsynchronously((Plugin)Kingdoms.get(), 1L, 1L);
        PREVENT_FALL_DAMAGE.add(player);
    }

    public static void onFlyLandChange(LandChangeEvent event) {
        final Player player = event.getPlayer();
        if (KingdomsDefaultPluginPermission.FLIGHT_LANDS.hasPermission((CommandSender)player)) {
            return;
        }
        if (!player.getAllowFlight()) {
            return;
        }
        if (PlayerUtils.invulnerableGameMode(player)) {
            return;
        }
        if (WARNINGS_LAND.containsKey(player.getUniqueId())) {
            return;
        }
        final KingdomPlayer kp = event.getKingdomPlayer();
        if (kp.isAdmin() || !kp.isFlying()) {
            return;
        }
        Land to = event.getToLand();
        if (!FlyManager.canFlyInLand(player, kp, to)) {
            final int warning = KingdomsConfig.KINGDOM_FLY_WARNINGS_LAND.getInt();
            if (event.getCause() != null) {
                KingdomsLang.FLY_OUT_OF_LAND.sendError((CommandSender)player, new Object[0]);
                kp.setFlying(false, null);
                return;
            }
            if (warning <= 0) {
                KingdomsLang.FLY_OUT_OF_LAND.sendError((CommandSender)player, new Object[0]);
                FlyManager.disableFly(player, kp);
                return;
            }
            BukkitTask task = new BukkitRunnable(){
                int counter;
                {
                    this.counter = warning;
                }

                public void run() {
                    if (FlyManager.canFlyInLand(player, kp, Land.getLand(player.getLocation()))) {
                        KingdomsLang.FLY_WARNINGS_OUT_OF_LAND_SAFE.sendMessage((CommandSender)player, "counter", this.counter);
                        WARNINGS_LAND.remove(player.getUniqueId());
                        this.cancel();
                        return;
                    }
                    if (this.counter == 0) {
                        KingdomsLang.FLY_OUT_OF_LAND.sendError((CommandSender)player, new Object[0]);
                        WARNINGS_LAND.remove(player.getUniqueId());
                        FlyManager.disableFlight(kp, player);
                        this.cancel();
                        return;
                    }
                    KingdomsLang.FLY_WARNINGS_OUT_OF_LAND_WARN.sendError((CommandSender)player, "counter", this.counter);
                    --this.counter;
                }
            }.runTaskTimerAsynchronously((Plugin)Kingdoms.get(), 0L, 20L);
            WARNINGS_LAND.put(player.getUniqueId(), task);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onFlyDamage(EntityDamageByEntityEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        if (PvPManager.getDamager(event.getDamager()) == null) {
            return;
        }
        Player player = (Player)event.getEntity();
        if (!player.getAllowFlight()) {
            return;
        }
        if (KingdomsDefaultPluginPermission.FLIGHT_DAMAGE.hasPermission((CommandSender)player)) {
            return;
        }
        if (!KingdomsConfig.KINGDOM_FLY_DISABLE_ON_DAMAGE.getBoolean()) {
            return;
        }
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        if (kp.isAdmin() || !kp.isFlying()) {
            return;
        }
        FlyManager.disableFly(player, kp);
        KingdomsLang.FLY_DAMAGE.sendError((CommandSender)player, new Object[0]);
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        PREVENT_FALL_DAMAGE.remove(player);
        SESSIONS.remove(player.getUniqueId());
        FlyManager.cancelTasks(player);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onTeleport(PlayerTeleportEvent event) {
        PREVENT_FALL_DAMAGE.remove(event.getPlayer());
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onUnclaim(UnclaimLandEvent event) {
        for (SimpleChunkLocation land : event.getLandLocations()) {
            Chunk chunk = land.toChunk();
            for (Entity entity2 : chunk.getEntities()) {
                if (!(entity2 instanceof Player)) continue;
                Player player = (Player)entity2;
                KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
                FlyManager.flightInUnclaimed(kp);
            }
        }
    }

    static void flightInUnclaimed(KingdomPlayer kp) {
        Player player;
        if (kp.isFlying() && !kp.isAdmin() && (player = kp.getPlayer()) != null && !KingdomsDefaultPluginPermission.FLIGHT_LANDS.hasPermission((CommandSender)player)) {
            FlyManager.disableFly(player, kp);
            FlyManager.cancelTasks(player);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onDisband(KingdomDisbandEvent event) {
        for (Player player : event.getKingdom().getOnlineMembers()) {
            FlyManager.flightInUnclaimed(KingdomPlayer.getKingdomPlayer((OfflinePlayer)player));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void duringFlyKingdomLeaveEvent(KingdomLeaveEvent event) {
        KingdomPlayer kp = event.getPlayer();
        FlyManager.flightInUnclaimed(kp);
    }

    static {
        int range = KingdomsConfig.KINGDOM_FLY_NEARBY_UNFRIENDLY_RANGE.getInt();
        Bukkit.getScheduler().runTaskTimer((Plugin)Kingdoms.get(), () -> {
            for (Player player : Bukkit.getOnlinePlayers()) {
                KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
                if (kp.hasKingdom() && kp.isFlying() && !kp.hasPermission(StandardKingdomPermission.FLY)) {
                    StandardKingdomPermission.FLY.sendDeniedMessage(player);
                    FlyManager.disableFly(player, kp);
                    continue;
                }
                FlyManager.isNearUnfriendly(player, range, true);
            }
        }, 1200L, 100L);
        if (KingdomsConfig.KINGDOM_FLY_CHARGES_ENABLED.getBoolean()) {
            long chargesTicks = (long)KingdomsConfig.KINGDOM_FLY_CHARGES_EVERY_SECONDS.getInt() * 20L;
            Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)Kingdoms.get(), () -> {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    FlyManager.handleCharges(player);
                }
            }, 1200L, chargesTicks);
        }
    }

    public static final class FlightSession {
        private double playerCharges;
        private double kingdomChargesRp;
        private double kingdomChargesBank;
    }

    private static final class FlightAFKCharge
    extends AfkF24Manager {
        protected FlightAFKCharge(ConditionalExpression condition, Duration stopDuration, boolean considerCameraMovements) {
            super(condition, stopDuration, considerCameraMovements);
        }

        public static FlightAFKCharge parse(ConfigAccessor accessor) {
            if (accessor == null) {
                return null;
            }
            ConfigSection section = accessor.getSection();
            if (section == null) {
                return null;
            }
            ConditionalExpression condition = section.getCondition("enabled");
            if (condition instanceof ConditionalCompiler.ConstantLogicalOperand && !((ConditionalCompiler.ConstantLogicalOperand)condition).getValue()) {
                return null;
            }
            boolean considerCameraMovement = section.getBoolean("consider-camera-movement");
            Duration duration = section.getTime("duration");
            return new FlightAFKCharge(condition, duration, considerCameraMovement);
        }

        @Override
        protected boolean filter(PlayerMoveEvent event) {
            Player player = event.getPlayer();
            if (!player.getAllowFlight()) {
                return false;
            }
            if (!player.isFlying()) {
                return false;
            }
            KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
            return kp.isFlying();
        }
    }
}

