/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers;

import java.util.Map;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.JvmStatic;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.managers.ChairSession;
import org.kingdoms.server.events.EntityDismountEvent;
import org.kingdoms.utils.LocationUtils;
import org.kingdoms.utils.hash.EntityHashMap;
import org.kingdoms.utils.hash.EntityWeakHashMap;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\t\b\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000bH\u0007\u00a8\u0006\r"}, d2={"Lorg/kingdoms/managers/ChairManager;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "onCannonStandUp", "", "event", "Lorg/kingdoms/server/events/EntityDismountEvent;", "onTeleport", "Lorg/bukkit/event/player/PlayerTeleportEvent;", "onLeave", "Lorg/bukkit/event/player/PlayerQuitEvent;", "Companion", "core"})
public final class ChairManager
implements Listener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final EntityWeakHashMap<Player, ChairSession<Object>> HANDLERS = ((EntityHashMap.WeakBuilder)((EntityHashMap.WeakBuilder)EntityHashMap.weakBuilder(Player.class).onDeath(ChairManager::HANDLERS$lambda$0)).onLeave(ChairManager::HANDLERS$lambda$1)).build();

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public final void onCannonStandUp(@NotNull EntityDismountEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getEntity() instanceof Player) {
            Entity entity2 = event.getEntity();
            Intrinsics.checkNotNull((Object)entity2, (String)"null cannot be cast to non-null type org.bukkit.entity.Player");
            Companion.standUp((Player)entity2);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public final void onTeleport(@NotNull PlayerTeleportEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
        Companion.standUp(player);
    }

    @EventHandler
    public final void onLeave(@NotNull PlayerQuitEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
        Companion.standUp(player);
    }

    private static final void HANDLERS$lambda$0(EntityWeakHashMap map, Player x) {
        map.remove(x);
    }

    private static final void HANDLERS$lambda$1(EntityWeakHashMap map, Player x) {
        map.remove(x);
    }

    @JvmStatic
    public static final void sit(@NotNull Player player, @NotNull ChairSession<Object> obj) {
        Companion.sit(player, obj);
    }

    @JvmStatic
    public static final void removeAll() {
        Companion.removeAll();
    }

    @JvmStatic
    @Nullable
    public static final ChairSession<Object> standUp(@NotNull Player player) {
        return Companion.standUp(player);
    }

    @JvmStatic
    @Nullable
    public static final ChairSession<Object> getHandler(@NotNull Player entity2) {
        return Companion.getHandler(entity2);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00010\bH\u0007J\b\u0010\u000f\u001a\u00020\fH\u0007J\u0018\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\u0006H\u0007J\u0018\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\b2\u0006\u0010\u0012\u001a\u00020\u0006H\u0007J!\u0010\u0013\u001a\n\u0012\u0004\u0012\u0002H\u0014\u0018\u00010\b\"\u0006\b\u0000\u0010\u0014\u0018\u00012\u0006\u0010\u0012\u001a\u00020\u0006H\u0086\nRp\u0010\u0004\u001aZ\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0001 \u0007*\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\b0\b \u0007*,\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0001 \u0007*\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\b0\b\u0018\u00010\u00050\u00058\u0002X\u0083\u0004\u00a2\u0006\n\n\u0002\u0010\n\u0012\u0004\b\t\u0010\u0003\u00a8\u0006\u0015"}, d2={"Lorg/kingdoms/managers/ChairManager$Companion;", "", "<init>", "()V", "HANDLERS", "Lorg/kingdoms/utils/hash/EntityWeakHashMap;", "Lorg/bukkit/entity/Player;", "org.kingdoms.libs.kotlin.jvm.PlatformType", "Lorg/kingdoms/managers/ChairSession;", "getHANDLERS$annotations", "Lorg/kingdoms/utils/hash/EntityWeakHashMap;", "sit", "", "player", "obj", "removeAll", "standUp", "getHandler", "entity", "get", "T", "core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        private static /* synthetic */ void getHANDLERS$annotations() {
        }

        @JvmStatic
        public final void sit(@NotNull Player player, @NotNull ChairSession<Object> obj) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter(obj, (String)"obj");
            EntityWeakHashMap entityWeakHashMap = HANDLERS;
            Intrinsics.checkNotNullExpressionValue((Object)entityWeakHashMap, (String)"access$getHANDLERS$cp(...)");
            ((Map)entityWeakHashMap).put(player, obj);
        }

        @JvmStatic
        public final void removeAll() {
            for (ChairSession handler : HANDLERS.values()) {
                if (handler == null) continue;
                ChairSession session = handler;
                Runnable runnable = session.getOnDismount();
                if (runnable != null) {
                    runnable.run();
                }
                session.getChair().remove();
            }
        }

        @JvmStatic
        @Nullable
        public final ChairSession<Object> standUp(@NotNull Player player) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            ChairSession chairSession = (ChairSession)HANDLERS.remove(player);
            if (chairSession == null) {
                return null;
            }
            ChairSession session = chairSession;
            Runnable runnable = session.getOnDismount();
            if (runnable != null) {
                runnable.run();
            }
            session.getChair().remove();
            Location location = player.getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)location, (String)"getLocation(...)");
            Location playerLoc = location;
            Location location2 = session.getChair().getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)location2, (String)"getLocation(...)");
            Location safeLoc = location2;
            safeLoc.setY(safeLoc.getY() + 1.5);
            safeLoc.setPitch(playerLoc.getPitch());
            safeLoc.setYaw(playerLoc.getYaw());
            if (LocationUtils.isPassableAndNotDangerous(safeLoc.getBlock())) {
                player.teleport(safeLoc);
            }
            return session;
        }

        @JvmStatic
        @Nullable
        public final ChairSession<Object> getHandler(@NotNull Player entity2) {
            Intrinsics.checkNotNullParameter((Object)entity2, (String)"entity");
            return (ChairSession)HANDLERS.get(entity2);
        }

        public final /* synthetic */ <T> ChairSession<T> get(Player entity2) {
            Intrinsics.checkNotNullParameter((Object)entity2, (String)"entity");
            boolean $i$f$get = false;
            ChairSession<Object> chairSession = this.getHandler(entity2);
            if (chairSession == null) {
                return null;
            }
            ChairSession<Object> session = chairSession;
            Object object = session.getSession();
            Intrinsics.reifiedOperationMarker((int)3, (String)"T");
            return object instanceof Object ? session : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

