/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.libs.caffeine.cache.Cache;
import org.kingdoms.utils.cache.caffeine.CacheHandler;

public final class BlockLogManager
implements Listener {
    public static final Cache<UUID, Map<SimpleLocation, BlockLog>> PLAYER_LOGS = CacheHandler.newBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build();

    public static boolean owns(Player player, SimpleLocation loc) {
        Map logs = (Map)PLAYER_LOGS.getIfPresent((Object)player.getUniqueId());
        if (logs == null) {
            throw new IllegalStateException("Player '" + player.getName() + "' not tracked yet");
        }
        return logs.containsKey(loc);
    }

    public static void track(Player player) {
        PLAYER_LOGS.put((Object)player.getUniqueId(), new HashMap());
    }

    public static void dontTrack(Player player) {
        PLAYER_LOGS.invalidate((Object)player.getUniqueId());
    }

    private static void handle(Player player, Block block, BlockLog.Type type) {
        Map logs = (Map)PLAYER_LOGS.getIfPresent((Object)player.getUniqueId());
        if (logs == null) {
            return;
        }
        logs.put(SimpleLocation.of(block), new BlockLog(BlockLog.Type.BREAK));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBreak(BlockBreakEvent event) {
        BlockLogManager.handle(event.getPlayer(), event.getBlock(), BlockLog.Type.BREAK);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlace(BlockPlaceEvent event) {
        BlockLogManager.handle(event.getPlayer(), event.getBlock(), BlockLog.Type.PLACE);
    }

    public static final class BlockLog {
        private final Type type;

        public BlockLog(Type type) {
            this.type = type;
        }

        public static enum Type {
            PLACE,
            BREAK;

        }
    }
}

