/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.main;

import java.nio.file.Path;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.kingdoms.dependencies.classpath.BootstrapProvider;
import org.kingdoms.dependencies.classpath.ClassPathAppender;
import org.kingdoms.dependencies.classpath.ReflectionClassPathAppender;
import org.kingdoms.main.Kingdoms;

final class KingdomsBootstrapProvider
implements BootstrapProvider {
    private final Kingdoms loader;
    private final ClassPathAppender classPathAppender;

    public KingdomsBootstrapProvider(Kingdoms loaderPlugin) {
        this.loader = loaderPlugin;
        this.classPathAppender = new ReflectionClassPathAppender(this.getClass().getClassLoader());
    }

    @Override
    public void onLoad() {
        this.loader.onLoad();
    }

    @Override
    public void onEnable() {
        this.loader.onEnable();
    }

    @Override
    public void onDisable() {
        this.loader.onDisable();
    }

    @Override
    public void runAsyncLater(Runnable runnable, long time, TimeUnit unit) {
        Kingdoms.taskScheduler.async().delayed(Duration.ofMillis(unit.toMillis(time)), runnable);
    }

    @Override
    public ClassPathAppender getClassPathAppender() {
        return this.classPathAppender;
    }

    @Override
    public Path getLibsFolder() {
        return Kingdoms.getFolder().resolve("libs");
    }

    @Override
    public Logger getLogger() {
        return this.loader.getLogger();
    }
}

