/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.main;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitTask;
import org.kingdoms.api.KingdomsDefaultAPI;
import org.kingdoms.api.KingdomsDefaultAPIContainer;
import org.kingdoms.commands.KingdomsCommandHandler;
import org.kingdoms.commands.admin.CommandAdminResetConfigs;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.config.managers.ConfigManager;
import org.kingdoms.config.migration.ConfigMigrationHistory;
import org.kingdoms.constants.group.model.logs.AuditLogRegistry;
import org.kingdoms.constants.group.model.logs.StandardAuditLogRegistrar;
import org.kingdoms.constants.group.model.relationships.KingdomRelation;
import org.kingdoms.constants.group.model.relationships.RelationAttributeRegistry;
import org.kingdoms.constants.group.model.relationships.StandardRelationAttribute;
import org.kingdoms.constants.group.upgradable.Powerup;
import org.kingdoms.constants.group.upgradable.champion.ChampionAbility;
import org.kingdoms.constants.land.building.BuildingArchitectRegistry;
import org.kingdoms.constants.land.structures.StructureRegistry;
import org.kingdoms.constants.land.turrets.TurretRegistry;
import org.kingdoms.constants.metadata.KingdomMetadataRegistry;
import org.kingdoms.constants.player.KingdomPermissionRegistry;
import org.kingdoms.constants.player.KingdomsChatChannel;
import org.kingdoms.constants.player.Rank;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.data.centers.KingdomsDataCenter;
import org.kingdoms.data.centers.KingdomsStartup;
import org.kingdoms.dependencies.Dependency;
import org.kingdoms.dependencies.DependencyManager;
import org.kingdoms.gui.GUIConfig;
import org.kingdoms.gui.InteractiveGUIManager;
import org.kingdoms.libs.jetbrains.annotations.ApiStatus;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.snakeyaml.nodes.MappingNode;
import org.kingdoms.libs.snakeyaml.nodes.Node;
import org.kingdoms.libs.snakeyaml.nodes.ScalarNode;
import org.kingdoms.libs.xseries.reflection.XReflection;
import org.kingdoms.locale.LanguageManager;
import org.kingdoms.locale.MessageHandler;
import org.kingdoms.locale.placeholders.StandardKingdomsPlaceholder;
import org.kingdoms.main.KLogger;
import org.kingdoms.main.KingdomsBootstrapProvider;
import org.kingdoms.main.PluginState;
import org.kingdoms.managers.BlockLogManager;
import org.kingdoms.managers.ChairManager;
import org.kingdoms.managers.FlyManager;
import org.kingdoms.managers.GUIProtectionInterrupter;
import org.kingdoms.managers.GeneralizedEventWatcher;
import org.kingdoms.managers.JoinAndLeaveManager;
import org.kingdoms.managers.PowerupManager;
import org.kingdoms.managers.PrivateKingdomManager;
import org.kingdoms.managers.abstraction.ProlongedTask;
import org.kingdoms.managers.backup.KingdomsBackup;
import org.kingdoms.managers.book.BookManager;
import org.kingdoms.managers.buildings.itemoffer.BuildingItemOfferManager;
import org.kingdoms.managers.buildings.structures.RegulatorManager;
import org.kingdoms.managers.buildings.structures.SiegeManager;
import org.kingdoms.managers.buildings.turrets.ManualTurretHandler;
import org.kingdoms.managers.buildings.turrets.SoldierManager;
import org.kingdoms.managers.buildings.turrets.TurretFactory;
import org.kingdoms.managers.buildings.turrets.TurretLandCacheOptimizationWatcher;
import org.kingdoms.managers.chat.ChatInputManager;
import org.kingdoms.managers.chat.KingdomChatChannelListener;
import org.kingdoms.managers.chunkrestoration.ChunkSnapshotManager;
import org.kingdoms.managers.entity.KingdomEntityManager;
import org.kingdoms.managers.entity.KingdomEntityRegistry;
import org.kingdoms.managers.internals.EmergencyMode;
import org.kingdoms.managers.internals.ReloadProtection;
import org.kingdoms.managers.invasions.InvasionManager;
import org.kingdoms.managers.inventory.InventoryWatcher;
import org.kingdoms.managers.inviterequests.JoinRequests;
import org.kingdoms.managers.land.ChunkManager;
import org.kingdoms.managers.land.KingdomBuildingManager;
import org.kingdoms.managers.land.KingdomsBlockRegistry;
import org.kingdoms.managers.land.LandChangeWatcher;
import org.kingdoms.managers.land.LandEffectsManager;
import org.kingdoms.managers.land.LandProtectionManager;
import org.kingdoms.managers.land.chests.GeneratedChestManager;
import org.kingdoms.managers.land.claiming.AutoClaimManager;
import org.kingdoms.managers.land.distance.DistanceManager;
import org.kingdoms.managers.land.protection.KingdomGuardManager;
import org.kingdoms.managers.land.protection.KingdomVaultManager;
import org.kingdoms.managers.land.protection.LandPistonManager;
import org.kingdoms.managers.land.protection.MiscUpgradeManager;
import org.kingdoms.managers.land.protection.explosions.LandExplosionManager;
import org.kingdoms.managers.logger.KingdomsLogger;
import org.kingdoms.managers.logger.LogAndStatsManager;
import org.kingdoms.managers.mails.MailUserAgent;
import org.kingdoms.managers.network.MetricsLoader;
import org.kingdoms.managers.network.socket.SocketManager;
import org.kingdoms.managers.protectionsign.ProtectionSignManager;
import org.kingdoms.managers.pvp.PvPManager;
import org.kingdoms.managers.teleportation.TpManager;
import org.kingdoms.permissions.KingdomsDefaultPluginPermission;
import org.kingdoms.permissions.registry.PermissionRegistry;
import org.kingdoms.platform.bukkit.core.BukkitServer;
import org.kingdoms.scheduler.AsyncScheduledTasks;
import org.kingdoms.scheduler.BukkitSchedulerAdapter;
import org.kingdoms.scheduler.TaskScheduleProvider;
import org.kingdoms.server.core.Server;
import org.kingdoms.server.platform.CrossPlatformManager;
import org.kingdoms.server.platform.Platform;
import org.kingdoms.services.ServiceVault;
import org.kingdoms.services.managers.SoftService;
import org.kingdoms.utils.PaperUtils;
import org.kingdoms.utils.PlayerUtils;
import org.kingdoms.utils.config.ConfigSection;
import org.kingdoms.utils.config.adapters.YamlContainer;
import org.kingdoms.utils.config.adapters.YamlParseContext;
import org.kingdoms.utils.config.importer.YamlModuleLoader;
import org.kingdoms.utils.hash.EntityHashHandler;
import org.kingdoms.utils.internal.reflection.Reflect;
import org.kingdoms.utils.network.UpdateChecker;
import org.kingdoms.utils.nms.TemporaryEntity;
import org.kingdoms.utils.paper.PaperEvents;
import org.kingdoms.utils.playerselector.PlayerSelectorRegistry;
import org.kingdoms.versioning.JavaVersion;
import org.kingdoms.versioning.LatestMCVersion;

public final class Kingdoms
extends JavaPlugin {
    private PluginState state = PluginState.INITIATING;
    private static boolean STRICT = true;
    private static Kingdoms instance;
    private StackTraceElement[] stackTrace;
    private KingdomsDataCenter dataCenter;
    private KingdomsBackup backupManager;
    private final DependencyManager dependencyManager;
    protected static TaskScheduleProvider taskScheduler;
    private final KingdomsBootstrapProvider bootstrapProvider;
    private final JavaPlugin loader = this;
    private final ZonedDateTime compileTime;
    private final String compileCommitSHA;
    private static Server server;
    private final KingdomPermissionRegistry permissionRegistery = new KingdomPermissionRegistry();
    private final RelationAttributeRegistry relationAttributeRegistry = new RelationAttributeRegistry();
    private final AuditLogRegistry auditLogRegistry = new AuditLogRegistry();
    private final KingdomMetadataRegistry metadataRegistry = new KingdomMetadataRegistry();
    private final BuildingArchitectRegistry buildingArchitectRegistry = new BuildingArchitectRegistry();
    private final KingdomsBlockRegistry kingdomsBlockRegistry = new KingdomsBlockRegistry();

    public AuditLogRegistry getAuditLogRegistry() {
        return this.auditLogRegistry;
    }

    public KingdomPermissionRegistry getPermissionRegistery() {
        return this.permissionRegistery;
    }

    public RelationAttributeRegistry getRelationAttributeRegistry() {
        return this.relationAttributeRegistry;
    }

    public KingdomMetadataRegistry getMetadataRegistry() {
        return this.metadataRegistry;
    }

    public BuildingArchitectRegistry getBuildingArchitectRegistry() {
        return this.buildingArchitectRegistry;
    }

    public KingdomsBlockRegistry getKingdomsBlockRegistry() {
        return this.kingdomsBlockRegistry;
    }

    private void checkMinecraftVersion() {
        RuntimeException ex;
        if (!Platform.BUKKIT.isAvailable()) {
            throw new IllegalArgumentException("Your server doesn't seem to be running on a bukkit platform. Please contact the plugin developers.");
        }
        if (!XReflection.supports((int)9)) {
            throw new IllegalStateException("The plugin doesn't support 1.8 and below versions. Visit here for more info: https://github.com/CryptoMorin/KingdomsX/wiki/FAQ#support-for-18-and-lower-versions");
        }
        RuntimeException runtimeException = ex = LatestMCVersion.CURRENT_MINOR_VERSION == null ? null : LatestMCVersion.CURRENT_MINOR_VERSION.ensureLatestPatch(this.getLogger());
        if (ex != null) {
            throw ex;
        }
    }

    @ApiStatus.Internal
    public Kingdoms() {
        Path cfg = this.getDataFolder().toPath().resolve("config.yml");
        if (Files.exists(cfg, new LinkOption[0])) {
            try (InputStream is = Files.newInputStream(cfg, StandardOpenOption.READ);){
                MappingNode root = YamlContainer.parse(new YamlParseContext().named("config.yml").stream(is));
                Node node = root.getNode("iSwearIKnowWhatTheFuckIAmDoingRightNow");
                if (node instanceof ScalarNode) {
                    ScalarNode scalarNode = (ScalarNode)node;
                    STRICT = !scalarNode.getValue().equals("unsafe");
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        if (STRICT && (instance != null || this.state != PluginState.INITIATING)) {
            throw new IllegalStateException("Plugin loaded twice");
        }
        instance = this;
        this.bootstrapProvider = new KingdomsBootstrapProvider(this);
        this.dependencyManager = new DependencyManager(this.bootstrapProvider);
        taskScheduler = new BukkitSchedulerAdapter(this, this.bootstrapProvider);
        this.getLogger().info("Checking libraries...");
        if (JavaVersion.supports(11)) {
            Dependency.CAFFEINE.setDefaultVersion("3.2.0");
            Dependency.HIKARI.setDefaultVersion("6.2.1");
            Dependency.H2_DRIVER.setDefaultVersion("2.3.232");
        } else {
            Dependency.H2_DRIVER.setDefaultVersion("2.2.224");
        }
        this.dependencyManager.loadDependencies(DependencyManager.REQUIRED_DEPENDENCIES);
        ConfigSection pluginSettings = new ConfigSection(YamlContainer.parse(new YamlParseContext().named("plugin.yml").stream(this.getResource("plugin.yml"))));
        this.compileCommitSHA = Objects.requireNonNull(pluginSettings.getString("compile-master-sha"), () -> pluginSettings.getNode().toString());
        this.compileTime = DateTimeFormatter.ISO_INSTANT.withZone(ZoneOffset.UTC).parse((CharSequence)pluginSettings.getString("compile-time"), ZonedDateTime::from);
        KingdomsDefaultAPIContainer.API = KingdomsDefaultAPI.INSTANCE;
        this.setState(PluginState.INITIATED);
    }

    @ApiStatus.Internal
    private void setState(PluginState state) {
        if (this.state.ordinal() + 1 != state.ordinal()) {
            throw new IllegalStateException("Cannot change state from: " + (Object)((Object)this.state) + " -> " + (Object)((Object)state));
        }
        this.state = state;
    }

    public PluginState getState() {
        return this.state;
    }

    public static TaskScheduleProvider taskScheduler() {
        return taskScheduler;
    }

    @ApiStatus.Internal
    public static boolean isStrict() {
        return STRICT;
    }

    public static Kingdoms get() {
        return instance;
    }

    @ApiStatus.Internal
    public JavaPlugin getLoader() {
        return this;
    }

    private static void registerServices() {
        for (SoftService service : SoftService.values()) {
            if (!service.isAvailable()) continue;
            try {
                service.getService().enable();
            }
            catch (Throwable ex) {
                MessageHandler.sendConsolePluginMessage("&4Failed to register &e" + service.getName() + " &4services&8:");
                ex.printStackTrace();
            }
        }
        if (SoftService.VAULT.isAvailable()) {
            Bukkit.getScheduler().runTaskLater((Plugin)Kingdoms.get(), () -> {
                if (!ServiceVault.isAvailable(ServiceVault.Component.ECO)) {
                    KLogger.warn("Unable to start Vault economy services. Install an economy plugin before using Kingdoms economics.");
                }
                if (!ServiceVault.isAvailable(ServiceVault.Component.CHAT)) {
                    KLogger.warn("Unable to start Vault economy services. Install a prefix/suffix plugin (mostly managed by permission plugins).");
                }
                if (!ServiceVault.isAvailable(ServiceVault.Component.PERM)) {
                    KLogger.warn("Unable to start Vault economy services. Install a permission plugin before using Kingdoms permission checks.");
                }
            }, 0L);
        }
    }

    @ApiStatus.Internal
    public void onLoad() {
        this.state = PluginState.LOADING;
        if (!STRICT) {
            this.getLogger().warning("Running on unsafe mode. No support will be provided.");
        }
        if (STRICT) {
            this.checkMinecraftVersion();
            ReloadProtection.ensureLoadOnce();
            ReloadProtection.ensureLoadedNaturally();
        }
        server = new BukkitServer(this);
        Server.init(server);
        server.onStartup();
        PaperUtils.init();
        StandardKingdomPermission.init();
        StandardRelationAttribute.init();
        StandardAuditLogRegistrar.registerAll();
        this.buildingArchitectRegistry.registerDefaults();
        this.kingdomsBlockRegistry.registerDefaults();
        this.state = PluginState.LOADED;
    }

    @ApiStatus.Internal
    public static Server getServerX() {
        return server;
    }

    public String getCompileCommitSHA() {
        return this.compileCommitSHA;
    }

    public ZonedDateTime getCompileTime() {
        return this.compileTime;
    }

    @ApiStatus.Internal
    public void onEnable() {
        List<String> warnings;
        String restoreBackup;
        if (STRICT) {
            if (this.state != PluginState.LOADED) {
                this.getLogger().severe("-------------------------------------------------------------------");
                this.getLogger().severe("The plugin did not load correctly. Please check your startup logs by scrolling up.");
                this.getLogger().severe("-------------------------------------------------------------------");
                Bukkit.getPluginManager().disablePlugin((Plugin)this);
                return;
            }
            ReloadProtection.ensureLoadOnce();
        }
        this.setState(PluginState.ENABLING);
        this.stackTrace = Thread.currentThread().getStackTrace();
        server.onEnable();
        if (ConfigManager.getGlobals().getBoolean("reset-configs-on-next-start")) {
            KLogger.info("Detected config reset request...");
            CommandAdminResetConfigs.resetConfigs();
        }
        if ((restoreBackup = ConfigManager.getGlobals().getString("restore-backup")) != null && !restoreBackup.isEmpty()) {
            KLogger.info("Restoring backup " + restoreBackup + "...");
            ConfigManager.getGlobals().set("restore-backup", null);
            ConfigManager.getGlobalsAdapter().saveConfig();
            this.backupManager = new KingdomsBackup(this);
            this.backupManager.restore(Paths.get(restoreBackup, new String[0]), this.backupManager.getToBackupRootFolder(), true);
        }
        YamlModuleLoader.loadAll();
        KingdomsConfig.init();
        ConfigManager manager = new ConfigManager(this);
        manager.createDataFolderIfMissing();
        ConfigManager.addAllConfigs();
        StandardKingdomsPlaceholder.init();
        LanguageManager.loadAll();
        if (KingdomsConfig.UPDATES_CONFIGS.getBoolean()) {
            ConfigMigrationHistory.applyMigrations();
            ConfigManager.updateConfigs();
        }
        StructureRegistry.get().init();
        TurretRegistry.get().init();
        KingdomsChatChannel.registerChannels();
        GUIConfig.init();
        if (KingdomsConfig.UPDATES_AUTOMATIC_CONFIG_RELOADS.getBoolean()) {
            manager.setupWatchService();
        }
        try {
            PermissionRegistry.registerAllRegistries();
        }
        catch (IncompatibleClassChangeError ex) {
            throw new RuntimeException("Your system's specs seem to incompatible with the plugin. Please report this to the developers. " + JavaVersion.getVersionString(), ex);
        }
        KingdomsDefaultPluginPermission.init();
        new KingdomsCommandHandler(this);
        Rank.init();
        KingdomRelation.init();
        ChampionAbility.init();
        Powerup.init();
        SoftService.reportAllStates();
        JoinRequests.registerMetaHandlers();
        PlayerSelectorRegistry.registerDefaults();
        ProlongedTask.init();
        if (KingdomsConfig.Claims.RESTORATION_ENABLED.getManager().getBoolean()) {
            ChunkSnapshotManager.init();
        }
        this.dataCenter = KingdomsDataCenter.createDefault();
        this.backupManager = new KingdomsBackup(this);
        KingdomsStartup.init(this);
        Kingdoms.registerServices();
        this.registerAllEvents();
        new UpdateChecker();
        MetricsLoader.init(this);
        manager.validateConfigs();
        KLogger.info("Loading all players...");
        PlayerUtils.init();
        Kingdoms.addLibsInfo(this.bootstrapProvider.getLibsFolder());
        if (KingdomsConfig.DEVELOPMENT_MODE.getBoolean()) {
            SocketManager.initMainManager(this.getLogger());
        }
        if (!(warnings = CrossPlatformManager.warn()).isEmpty()) {
            KLogger.warn("-----------------------------------------------------------------------------------------------");
            warnings.forEach(KLogger::warn);
            KLogger.warn("-----------------------------------------------------------------------------------------------");
        }
        this.setState(PluginState.ENABLED);
    }

    public static Path getFolder() {
        return Kingdoms.get().loader.getDataFolder().toPath();
    }

    @ApiStatus.Internal
    public StackTraceElement[] getStackTrace() {
        return this.stackTrace;
    }

    public static Path getPath(String path) {
        return Kingdoms.getFolder().resolve(path);
    }

    @ApiStatus.Internal
    public void registerAllEvents() {
        GeneralizedEventWatcher.init();
        if (STRICT) {
            this.registerEvent(new ReloadProtection());
        }
        this.registerEvent(new PrivateKingdomManager());
        this.registerEvent(new LogAndStatsManager());
        this.registerEvent(new InteractiveGUIManager());
        this.registerEvent(new JoinAndLeaveManager());
        this.registerEvent(new AutoClaimManager());
        this.registerEvent(new PowerupManager());
        this.registerEvent(new KingdomBuildingManager());
        if (!PvPManager.isPvPType(PvPManager.PvPType.DISABLED)) {
            this.registerEvent(new PvPManager());
        }
        this.registerEvent(new InvasionManager());
        this.registerEvent(new KingdomEntityManager(this));
        this.registerEvent(new TpManager());
        this.registerEvent(new ChatInputManager());
        this.registerEvent(new KingdomGuardManager());
        this.registerEvent(new ChairManager());
        this.registerEvent(new BookManager());
        this.registerEvent(new JoinRequests());
        this.registerEvent(new RegulatorManager());
        this.registerEvent(new SiegeManager());
        this.registerEvent(new BuildingItemOfferManager());
        this.registerEvent(new MailUserAgent());
        this.registerEvent(new KingdomVaultManager());
        this.registerEvent(InventoryWatcher.INSTANCE);
        this.registerEvent(new ChunkManager());
        this.registerEvent(new MiscUpgradeManager());
        this.registerEvent(new LandExplosionManager());
        this.registerEvent(new LandPistonManager());
        this.registerEvent(new LandChangeWatcher());
        this.registerEvent(new LandProtectionManager());
        this.registerEvent(new GUIProtectionInterrupter());
        this.registerEvent(new LandEffectsManager());
        this.registerEvent(new DistanceManager());
        this.registerEvent(new GeneratedChestManager());
        this.registerEvent(new BlockLogManager());
        this.registerEvent(new EntityHashHandler(this));
        if (PaperEvents.supportsBeaconEffectEvent() && KingdomsConfig.Claims.BEACON_PROTECTED_EFFECTS.getManager().getBoolean()) {
            this.registerEvent(LandEffectsManager.createBeaconEffects());
        }
        if (Reflect.classExists("org.bukkit.event.entity.EntityTransformEvent")) {
            this.registerEvent(new InvasionManager.AdvancedInvasionManager());
        }
        new KingdomChatChannelListener(this);
        if (KingdomsConfig.KINGDOM_FLY_ENABLED.getBoolean()) {
            this.registerEvent(new FlyManager());
        }
        if (KingdomsConfig.ProtectionSigns.ENABLED.getManager().getBoolean()) {
            this.registerEvent(new ProtectionSignManager(this));
        }
        if (KingdomsConfig.Turrets.ENABLED.getManager().getBoolean()) {
            this.registerEvent(new TurretFactory());
            this.registerEvent(new ManualTurretHandler());
            this.registerEvent(new SoldierManager());
            this.registerEvent(new TurretLandCacheOptimizationWatcher());
        }
    }

    @ApiStatus.Internal
    public DependencyManager getDependencyManager() {
        return this.dependencyManager;
    }

    @ApiStatus.Internal
    static void addLibsInfo(Path path) {
        try {
            Files.write(path.resolve("README.txt"), Arrays.asList("For all information regarding what these files are, visit:", "https://github.com/CryptoMorin/KingdomsX/wiki/Installation#libraries"), StandardCharsets.US_ASCII, new OpenOption[0]);
        }
        catch (IOException e) {
            KLogger.error("Failed to add info file to libs folder:");
            e.printStackTrace();
        }
    }

    @ApiStatus.Internal
    public void registerEvent(Listener listener) {
        Bukkit.getPluginManager().registerEvents(listener, (Plugin)this.loader);
    }

    @ApiStatus.Internal
    public void onDisable() {
        if (this.state != PluginState.ENABLED) {
            this.getLogger().severe("Kingdoms plugin did not load properly to disable normally. Force disabling...");
            EmergencyMode.alert(EmergencyMode.DEFCON.DEFCON_2, "Plugin did not load properly. All your kingdoms data are unprotected. Please read the startup logs (scroll up). If you couldn't understand the error, do not just report this message, report your full server logs to the developers.");
            return;
        }
        this.setState(PluginState.DISABLING);
        this.dataCenter.onDisable();
        KingdomsLogger.getMain().log("Plugin disabled");
        ConfigManager.onDisable();
        if (KingdomsConfig.Claims.RESTORATION_ENABLED.getManager().getBoolean()) {
            KLogger.info("Finalizing chunk snapshots...");
            ChunkSnapshotManager.finishTasks();
        }
        KLogger.info("Disabling thread workers...");
        taskScheduler.shutdown();
        for (Map.Entry<BukkitTask, Runnable> task : AsyncScheduledTasks.getTasks().entrySet()) {
            task.getValue().run();
            task.getKey().cancel();
        }
        KLogger.info("Closing the logger...");
        this.getLogger().info("Unregistering plugin services...");
        for (SoftService service : SoftService.values()) {
            if (!service.isAvailable()) continue;
            try {
                service.getService().disable();
            }
            catch (Throwable ex) {
                MessageHandler.sendConsolePluginMessage("&4Failed to disable &e" + service.getName() + " &4services&8:");
                ex.printStackTrace();
            }
        }
        this.getLogger().info("Removing kingdom mobs...");
        KingdomEntityRegistry.removeAllKingdomMobs();
        this.getLogger().info("Removing temporary entities...");
        ChairManager.removeAll();
        TemporaryEntity.removeAllTemporaryEntities();
        this.getLogger().info("Removing temporary items...");
        BookManager.removeAll();
        if (LandExplosionManager.REGENERATE) {
            this.getLogger().info("Force regenerating all exploded stuff...");
            LandExplosionManager.forceOngoingRegenerations();
        }
        this.getLogger().info("Saving all data and closing the data center...");
        this.dataCenter.signalFullSave();
        this.dataCenter.close();
        KingdomsLogger.getMain().close();
        this.getLogger().info("Done, goodbye cruel world!");
        this.setState(PluginState.DISABLED);
    }

    @NotNull
    public KingdomsBackup getBackupManager() {
        return this.backupManager;
    }

    public KingdomsDataCenter getDataCenter() {
        return this.dataCenter;
    }

    @ApiStatus.Internal
    public void setDataCenter(KingdomsDataCenter dataCenter) {
        this.dataCenter = dataCenter;
    }
}

