/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.main;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.data.Pair;
import org.kingdoms.libs.jetbrains.annotations.TestOnly;
import org.kingdoms.locale.MessageHandler;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.permissions.KingdomsDefaultPluginPermission;
import org.kingdoms.utils.cooldown.Cooldown;
import org.kingdoms.utils.debugging.DebugNS;
import org.kingdoms.utils.debugging.DebugSettings;
import org.kingdoms.utils.debugging.StacktraceSettings;
import org.kingdoms.utils.internal.stacktrace.StackTraces;

public final class KLogger {
    public static final Object SILENT = new Object();
    public static final Object RAW = new Object();
    private static final String DEBUG = "&7[&5DEBUG&7] &6";
    private static final Logger LOGGER = Kingdoms.get().getLogger();
    private static final AtomicInteger ID_GEN = new AtomicInteger();
    private static final Cooldown<String> COOLDOWN = new Cooldown();
    private static final Map<String, String> DEBUG_VALUES = new HashMap<String, String>();
    private boolean ignore;
    private int id;
    private final DebugNS ns;
    private StackTraceElement[] tracedStack;
    private StackTraceElement[] parentStack;
    private Object asymmetricKey;
    private Thread tracedThread;
    @TestOnly
    public static final KLogger DEFAULT = new KLogger(null, false, null, null);

    public static boolean toggleDebugMode() {
        return DebugContainer.DEBUGGING = !DebugContainer.DEBUGGING;
    }

    public KLogger(DebugNS ns) {
        this(ns, true, null, null);
    }

    public static Map<String, String> getDebugValues() {
        return DEBUG_VALUES;
    }

    private boolean isInCooldown(DebugNS debug, String value) {
        return COOLDOWN.isInCooldown(debug.namespace() + ':' + value);
    }

    private void putCooldown(DebugNS debug, String value, Duration cooldown) {
        COOLDOWN.add(debug.namespace() + ':' + value, cooldown);
    }

    public static boolean hasDebugValue(String key) {
        return DEBUG_VALUES.containsKey(key.toLowerCase(Locale.ENGLISH));
    }

    public static String getDebugValue(String key) {
        key = key.toLowerCase(Locale.ENGLISH);
        return Objects.requireNonNull(DEBUG_VALUES.get(key), "Debug value " + key + " is not present.");
    }

    public KLogger(DebugNS ns, boolean printHeader) {
        this(ns, printHeader, null, null);
    }

    public KLogger(DebugNS ns, boolean printHeader, Object cooldownObject, Duration cooldown) {
        this.ns = ns;
        if (!KLogger.isDebugging()) {
            return;
        }
        if (cooldownObject != null) {
            if (COOLDOWN.isInCooldown(cooldownObject.toString())) {
                this.ignore = true;
                return;
            }
            COOLDOWN.add(cooldownObject.toString(), cooldown);
        }
        this.id = ID_GEN.getAndIncrement();
        if (printHeader) {
            this.log("Debug Info&8:");
            this.log("   &7- &2Platform&8: &9" + Bukkit.getVersion() + " &8- &9" + Bukkit.getBukkitVersion());
            this.log("   &7- &2Plugin Version&8: &9" + Kingdoms.get().getDescription().getVersion());
            StackTraceElement stack = this.getFirstStackTrace();
            this.log("   &7- &2Source&8: &9" + stack.getClassName() + "&8.&9" + stack.getMethodName() + "&8: &5" + stack.getLineNumber());
        }
    }

    public static void info(Object str) {
        LOGGER.info(str.toString());
    }

    @Deprecated
    @TestOnly
    public static void todo(Object ... objs) {
        if (objs.length == 0) {
            return;
        }
        if (objs[0] == SILENT) {
            return;
        }
        if (objs[0] == RAW) {
            KLogger.info(Arrays.stream(objs).skip(1L).map(Object::toString).collect(Collectors.joining(" ")));
        } else {
            MessageHandler.sendConsolePluginMessage("&5" + Arrays.stream(objs).map(Object::toString).collect(Collectors.joining(" ")));
        }
    }

    public static boolean calledFrom(Class<?> clazz) {
        for (StackTraceElement stack : Thread.currentThread().getStackTrace()) {
            if (!stack.getClassName().equals(clazz.getName())) continue;
            return true;
        }
        return false;
    }

    private static boolean stackEqualsSimple(StackTraceElement first, StackTraceElement second) {
        if (first == second) {
            return true;
        }
        return first.getClassName().equals(second.getClassName()) && Objects.equals(first.getMethodName(), second.getMethodName()) && Objects.equals(first.getFileName(), second.getFileName());
    }

    public boolean originatesFrom(StackTraceElement[] stackTrace) {
        return KLogger.originatesFrom(this.getTrueStackTrace(), stackTrace);
    }

    public static boolean originatesFrom(StackTraceElement[] first, StackTraceElement[] stackTrace) {
        if (first.length < stackTrace.length) {
            return false;
        }
        StackTraceElement[] currStack = (StackTraceElement[])Arrays.stream(first).skip(first.length - stackTrace.length).toArray(StackTraceElement[]::new);
        for (int i = 0; i < stackTrace.length; ++i) {
            StackTraceElement currElement = currStack[i];
            StackTraceElement element = stackTrace[i];
            if (!(i == 0 ? !KLogger.stackEqualsSimple(element, currElement) : !element.equals(currElement))) continue;
            return false;
        }
        return true;
    }

    public void startKeyExchange(Object key) {
        this.asymmetricKey = key;
    }

    @TestOnly
    public boolean exchangeKeys(Object previous, Object next) {
        if (this.asymmetricKey == previous) {
            this.asymmetricKey = next;
            return true;
        }
        return false;
    }

    @TestOnly
    public boolean hasKey(Object previous) {
        return this.asymmetricKey == previous;
    }

    @TestOnly
    public boolean isTraced() {
        if (this.tracedStack == null && this.tracedThread == null) {
            return false;
        }
        return Thread.currentThread() == this.tracedThread && (this.tracedStack == null || this.originatesFrom(this.tracedStack));
    }

    @TestOnly
    public KLogger traceStack() {
        Object[] currentStackTrace = Thread.currentThread().getStackTrace();
        if (this.tracedStack != null && Arrays.equals(this.tracedStack, currentStackTrace)) {
            return this;
        }
        this.tracedStack = (StackTraceElement[])Arrays.stream(currentStackTrace).skip(2L).toArray(StackTraceElement[]::new);
        return this;
    }

    public StackTraceElement[] getTrueStackTrace() {
        Thread currentThread = Thread.currentThread();
        StackTraceElement[] stackTrace = currentThread.getStackTrace();
        if (this.parentStack == null || currentThread != this.tracedThread) {
            return stackTrace;
        }
        AtomicBoolean noLongerSeen = new AtomicBoolean(false);
        return (StackTraceElement[])Stream.concat(Arrays.stream(stackTrace).limit(stackTrace.length - 1).skip(2L).filter(x -> {
            if (noLongerSeen.get()) {
                return true;
            }
            if (x.getClassName().equals(this.getClass().getName())) {
                return false;
            }
            noLongerSeen.set(true);
            return true;
        }), Arrays.stream(this.parentStack)).toArray(StackTraceElement[]::new);
    }

    @TestOnly
    public KLogger traceThread(boolean waitToFinish, Runnable runnable) {
        if (this.tracedThread != null || this.tracedStack != null && !this.originatesFrom(this.tracedStack)) {
            runnable.run();
            return this;
        }
        final Thread.UncaughtExceptionHandler oldHandler = Thread.getDefaultUncaughtExceptionHandler();
        final Thread.UncaughtExceptionHandler subclass = Thread.currentThread().getUncaughtExceptionHandler();
        this.parentStack = (StackTraceElement[])Arrays.stream(Thread.currentThread().getStackTrace()).skip(2L).toArray(StackTraceElement[]::new);
        this.tracedThread = new Thread(runnable, "KingdomsX-Debugger-" + this.id);
        this.tracedThread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread th, Throwable ex) {
                ArrayList<StackTraceElement> stacktrace = new ArrayList<StackTraceElement>(30);
                Collections.addAll(stacktrace, ex.getStackTrace());
                stacktrace.add(new StackTraceElement("Thread Change", th.getName(), "None", 0));
                Collections.addAll(stacktrace, KLogger.this.parentStack);
                ex.setStackTrace(stacktrace.toArray(new StackTraceElement[0]));
                if (oldHandler != null) {
                    oldHandler.uncaughtException(th, ex);
                } else if (subclass != null) {
                    subclass.uncaughtException(th, ex);
                } else {
                    ex.printStackTrace();
                }
            }
        });
        this.tracedThread.start();
        if (waitToFinish) {
            try {
                this.tracedThread.join();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        return this;
    }

    @TestOnly
    public void traced(Object message) {
        if (this.isTraced()) {
            StackTraceElement[] stackTraces = Thread.currentThread().getStackTrace();
            StackTraceElement stackTrace = stackTraces[2];
            MessageHandler.sendConsoleMessage("&8[&4Traced&8][&6" + stackTrace.getClassName() + "&8->&6" + stackTrace.getMethodName() + "&8] " + message);
        }
    }

    public static void debug(DebugNS ns, Supplier<Object> obj) {
        if (!KLogger.isDebugging()) {
            return;
        }
        KLogger.debug0(ns, () -> (ns == null ? "" : "&8[&5" + ns.namespace() + "&8] &6") + obj.get());
    }

    private static void debug0(DebugNS ns, Supplier<Object> obj) {
        if (!KLogger.isDebugging()) {
            return;
        }
        String str = obj.get().toString();
        String fullMsg = DEBUG + str;
        MessageHandler.sendConsolePluginMessage(fullMsg);
        Bukkit.getOnlinePlayers().stream().filter(x -> KingdomsDefaultPluginPermission.DEBUG.hasPermission((CommandSender)x, true)).filter(x -> ns == null || DebugSettings.getSettings((CommandSender)x).isWhitelist() == DebugSettings.getSettings((CommandSender)x).getList().contains(ns)).forEach(x -> MessageHandler.sendPlayerPluginMessage(x, fullMsg));
        if (ns != null && StacktraceSettings.isWhitelist == StacktraceSettings.list.contains(ns)) {
            StackTraces.printStackTrace();
        }
    }

    public static boolean isDebugging() {
        return DebugContainer.DEBUGGING;
    }

    public static void debug(DebugNS ns, Object str) {
        KLogger.debug(ns, () -> str);
    }

    public static void warn(Object str) {
        LOGGER.warning(str.toString());
    }

    public static void error(Object str) {
        LOGGER.severe(str.toString());
    }

    public KLogger property(Object name, boolean bool) {
        if (!KLogger.isDebugging()) {
            return this;
        }
        this.property(name, (bool ? "&2" : "&c") + bool);
        return this;
    }

    public KLogger property(Object name, Object value) {
        if (!KLogger.isDebugging()) {
            return this;
        }
        this.log(name + "&8: &2" + value);
        return this;
    }

    private StackTraceElement getFirstStackTrace() {
        return Arrays.stream(Thread.currentThread().getStackTrace()).skip(2L).filter(x -> !x.getClassName().startsWith(this.getClass().getName())).findFirst().orElseThrow(() -> new IllegalStateException("Cannot obtain stack trace"));
    }

    public void end() {
        this.log("-------------------------------------------------");
    }

    public void log(Object str) {
        this.log(this.ns, str);
    }

    public void log(Duration cooldown, Object str) {
        String string = str.toString();
        if (!this.isInCooldown(this.ns, string)) {
            this.putCooldown(this.ns, string, cooldown);
            this.log(this.ns, str);
        }
    }

    public void log(DebugNS ns, Object str) {
        this.log(ns, () -> str);
    }

    public void log(Supplier<Object> str) {
        this.log(this.ns, str);
    }

    public void log(DebugNS ns, Supplier<Object> str) {
        if (this.ignore) {
            return;
        }
        if (!KLogger.isDebugging()) {
            return;
        }
        if (ns == null) {
            KLogger.debug0(null, () -> "&6" + str.get());
        } else {
            KLogger.debug0(ns, () -> "&8[&5" + ns.namespace() + "&8][&7" + this.id + "&8] &6" + str.get());
        }
    }

    private static final class DebugContainer {
        private static boolean DEBUGGING = KingdomsConfig.DEBUG.getBoolean();

        private DebugContainer() {
        }
    }

    public static final class Prettifier {
        private final List<Pair<Object, Object>> properties = new ArrayList<Pair<Object, Object>>(10);

        public static Prettifier start(Object key, Object value) {
            return new Prettifier().add(key, value);
        }

        public Prettifier add(Object key, Object value) {
            this.properties.add(Pair.of(key, value));
            return this;
        }

        public String toString() {
            return "&7{ " + this.properties.stream().map(x -> "&2" + x.getKey() + "&8: &9" + x.getValue()).collect(Collectors.joining("&7, ")) + " &7}";
        }
    }
}

