/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.locale.placeholders.transformer;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.inventory.ItemStack;
import org.kingdoms.constants.economy.Balance;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.collections.CollectionsKt;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.locale.placeholders.transformer.PlaceholderTransformer;
import org.kingdoms.server.location.BlockPoint3D;
import org.kingdoms.utils.HierarchalClassMap;
import org.kingdoms.utils.ItemUtil;
import org.kingdoms.utils.LocationUtils;
import org.kingdoms.utils.compilers.expressions.Expression;
import org.kingdoms.utils.internal.functional.Fn;
import org.kingdoms.utils.internal.stacktrace.StackTraces;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J8\u0010\u0007\u001a\u00020\b\"\u0004\b\u0000\u0010\t\"\u0004\b\u0001\u0010\n2\u000e\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\t0\f2\u0014\u0010\r\u001a\u0010\u0012\u0006\b\u0001\u0012\u0002H\t\u0012\u0004\u0012\u0002H\n0\u0006J\u001c\u0010\u000e\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u00062\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fJ\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00012\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001R\u001c\u0010\u0004\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/kingdoms/locale/placeholders/transformer/PlaceholderTransformerRegistry;", "", "<init>", "()V", "registry", "Lorg/kingdoms/utils/HierarchalClassMap;", "Lorg/kingdoms/locale/placeholders/transformer/PlaceholderTransformer;", "register", "", "I", "O", "clazz", "Ljava/lang/Class;", "transformer", "getTransformer", "applyTransformation", "obj", "core"})
public final class PlaceholderTransformerRegistry {
    @NotNull
    public static final PlaceholderTransformerRegistry INSTANCE = new PlaceholderTransformerRegistry();
    @NotNull
    private static final HierarchalClassMap<PlaceholderTransformer<?, ?>> registry = new HierarchalClassMap(null, 1, null);

    private PlaceholderTransformerRegistry() {
    }

    public final <I, O> void register(@NotNull Class<? extends I> clazz, @NotNull PlaceholderTransformer<? extends I, O> transformer) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter(transformer, (String)"transformer");
        ((Map)registry).put(clazz, transformer);
    }

    @Nullable
    public final PlaceholderTransformer<?, ?> getTransformer(@NotNull Class<?> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        return registry.get((Object)clazz);
    }

    @Nullable
    public final Object applyTransformation(@Nullable Object obj) {
        if (obj == null) {
            return null;
        }
        PlaceholderTransformer<?, ?> transformer = this.getTransformer(obj.getClass());
        if (transformer != null) {
            return transformer.apply(Fn.cast(obj));
        }
        return obj;
    }

    private static final String _init_$lambda$0(ItemStack it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String amountString = "" + 'x' + it.getAmount();
        return ItemUtil.getName(it) + ' ' + amountString;
    }

    private static final String _init_$lambda$1(Location it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return LocationUtils.parseLocation(it);
    }

    private static final String _init_$lambda$2(SimpleLocation it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return LocationUtils.parseLocation(it);
    }

    private static final String _init_$lambda$3(BlockPoint3D it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return LocationUtils.parseLocation(it);
    }

    private static final String _init_$lambda$4(SimpleChunkLocation it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return LocationUtils.parseChunk(it);
    }

    private static final Object _init_$lambda$5(Supplier it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.get();
    }

    private static final Object _init_$lambda$6(Callable it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.call();
    }

    private static final Double _init_$lambda$7(Balance it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.get();
    }

    private static final Long _init_$lambda$8(Duration it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.toMillis();
    }

    private static final String _init_$lambda$9(Expression it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getOriginalString();
        if (string == null) {
            string = it.asString(true);
        }
        return string;
    }

    private static final CharSequence lambda$11$lambda$10(Throwable ex) {
        return ex.getClass().getName() + ": " + ex.getMessage();
    }

    private static final String _init_$lambda$11(Throwable it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        List<Throwable> list = StackTraces.getCausationChain(it);
        Intrinsics.checkNotNullExpressionValue(list, (String)"getCausationChain(...)");
        return CollectionsKt.joinToString$default((Iterable)list, (CharSequence)" <- ", null, null, (int)0, null, PlaceholderTransformerRegistry::lambda$11$lambda$10, (int)30, null);
    }

    static {
        INSTANCE.register(OfflinePlayer.class, 1.INSTANCE);
        INSTANCE.register(ItemStack.class, PlaceholderTransformerRegistry::_init_$lambda$0);
        INSTANCE.register(Location.class, PlaceholderTransformerRegistry::_init_$lambda$1);
        INSTANCE.register(SimpleLocation.class, PlaceholderTransformerRegistry::_init_$lambda$2);
        INSTANCE.register(BlockPoint3D.class, PlaceholderTransformerRegistry::_init_$lambda$3);
        INSTANCE.register(SimpleChunkLocation.class, PlaceholderTransformerRegistry::_init_$lambda$4);
        INSTANCE.register(Supplier.class, PlaceholderTransformerRegistry::_init_$lambda$5);
        INSTANCE.register(Callable.class, PlaceholderTransformerRegistry::_init_$lambda$6);
        INSTANCE.register(Balance.class, PlaceholderTransformerRegistry::_init_$lambda$7);
        INSTANCE.register(Duration.class, PlaceholderTransformerRegistry::_init_$lambda$8);
        INSTANCE.register(Expression.class, PlaceholderTransformerRegistry::_init_$lambda$9);
        INSTANCE.register(Throwable.class, PlaceholderTransformerRegistry::_init_$lambda$11);
    }
}

