/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.locale.placeholders;

import org.kingdoms.constants.top.ExpressionBasedTopData;
import org.kingdoms.constants.top.TopData;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.KotlinNothingValueException;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.compiler.placeholders.Placeholder;
import org.kingdoms.locale.compiler.placeholders.PlaceholderParser;
import org.kingdoms.locale.compiler.placeholders.functions.PlaceholderFunctionInvoker;
import org.kingdoms.locale.compiler.placeholders.types.KingdomsPlaceholder;
import org.kingdoms.locale.placeholders.FunctionalPlaceholder;
import org.kingdoms.locale.placeholders.KingdomsPlaceholderTranslationContext;
import org.kingdoms.locale.placeholders.PhFn;
import org.kingdoms.locale.placeholders.PhParam;
import org.kingdoms.locale.placeholders.context.PlaceholderContextBuilder;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001d\u0010\u0006\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH \u00a2\u0006\u0002\b\nJ\u0017\u0010\u000b\u001a\u00028\u00002\u0006\u0010\f\u001a\u00020\rH \u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00028\u0000H \u00a2\u0006\u0004\b\u0012\u0010\u0013J \u0010\u0006\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00072\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\tH\u0002J5\u0010\u0016\u001a\u0004\u0018\u00010\u00022\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00152\b\b\u0001\u0010\b\u001a\u00020\t2\n\b\u0001\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0007\u00a2\u0006\u0002\u0010\u0019J$\u0010\u001a\u001a\u0004\u0018\u00010\u00022\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00152\b\b\u0001\u0010\b\u001a\u00020\tH\u0007J5\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00152\b\b\u0001\u0010\b\u001a\u00020\t2\n\b\u0001\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0007\u00a2\u0006\u0002\u0010\u001dJ$\u0010\u001e\u001a\u0004\u0018\u00010\u00022\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00152\b\b\u0001\u0010\b\u001a\u00020\tH\u0007J0\u0010\u001f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0014\u001a\u00020\u00152\b\b\u0001\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\u001a\u001a\u00020\u00182\b\b\u0001\u0010 \u001a\u00020\tH\u0007\u00a8\u0006!"}, d2={"Lorg/kingdoms/locale/placeholders/TopPlaceholders;", "V", "", "Lorg/kingdoms/locale/placeholders/FunctionalPlaceholder;", "<init>", "()V", "getTopData", "Lorg/kingdoms/constants/top/TopData;", "type", "", "getTopData$core", "getContextObject", "context", "Lorg/kingdoms/locale/placeholders/KingdomsPlaceholderTranslationContext;", "getContextObject$core", "(Lorg/kingdoms/locale/placeholders/KingdomsPlaceholderTranslationContext;)Ljava/lang/Object;", "createContext", "Lorg/kingdoms/locale/placeholders/context/PlaceholderContextBuilder;", "createContext$core", "(Ljava/lang/Object;)Lorg/kingdoms/locale/placeholders/context/PlaceholderContextBuilder;", "fn", "Lorg/kingdoms/locale/compiler/placeholders/functions/PlaceholderFunctionInvoker;", "value", "pos", "", "(Lorg/kingdoms/locale/placeholders/KingdomsPlaceholderTranslationContext;Lorg/kingdoms/locale/compiler/placeholders/functions/PlaceholderFunctionInvoker;Ljava/lang/String;Ljava/lang/Integer;)Ljava/lang/Object;", "position", "has", "", "(Lorg/kingdoms/locale/placeholders/KingdomsPlaceholderTranslationContext;Lorg/kingdoms/locale/compiler/placeholders/functions/PlaceholderFunctionInvoker;Ljava/lang/String;Ljava/lang/Integer;)Ljava/lang/Boolean;", "isIncluded", "at", "of", "core"})
public abstract class TopPlaceholders<V>
extends FunctionalPlaceholder {
    @Nullable
    public abstract TopData<V> getTopData$core(@NotNull String var1);

    @NotNull
    public abstract V getContextObject$core(@NotNull KingdomsPlaceholderTranslationContext var1);

    @NotNull
    public abstract PlaceholderContextBuilder createContext$core(@NotNull V var1);

    private final TopData<V> getTopData(PlaceholderFunctionInvoker fn, String type) {
        TopData<V> topData = this.getTopData$core(type);
        if (topData == null) {
            fn.invalidArg("type", "Unknown top kingdom data type named '" + type + '\'');
            return null;
        }
        return topData;
    }

    @PhFn
    @Nullable
    public final Object value(@NotNull KingdomsPlaceholderTranslationContext context, @NotNull PlaceholderFunctionInvoker fn, @PhParam(name="type") @NotNull String type, @PhParam(name="pos", optional=true) @Nullable Integer pos) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fn, (String)"fn");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        TopData<V> topData = this.getTopData(fn, type);
        if (topData == null) {
            return null;
        }
        TopData<V> topData2 = topData;
        if (!(topData2 instanceof ExpressionBasedTopData)) {
            fn.getPlaceholder().error("This placeholder doesn't support top values");
            throw new KotlinNothingValueException();
        }
        ExpressionBasedTopData exprTop = (ExpressionBasedTopData)topData2;
        if (pos != null) {
            Object v = ((ExpressionBasedTopData)topData2).getTopPosition(pos).orElse(null);
            if (v == null) {
                Object[] objectArray = new Object[]{"position", pos};
                return KingdomsLang.PLACEHOLDERS_TOP_NOT_FOUND.parse(objectArray);
            }
            Object dataAtPosition = v;
            return exprTop.getTopValueOf(dataAtPosition);
        }
        return exprTop.getTopValueOf(this.getContextObject$core(context));
    }

    @PhFn
    @Nullable
    public final Object position(@NotNull KingdomsPlaceholderTranslationContext context, @NotNull PlaceholderFunctionInvoker fn, @PhParam(name="type") @NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fn, (String)"fn");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        TopData<V> topData = this.getTopData(fn, type);
        if (topData == null) {
            return null;
        }
        TopData<V> topData2 = topData;
        return topData2.getPositionOf(this.getContextObject$core(context)).orElse(topData2.size());
    }

    @PhFn
    @Nullable
    public final Boolean has(@NotNull KingdomsPlaceholderTranslationContext context, @NotNull PlaceholderFunctionInvoker fn, @PhParam(name="type") @NotNull String type, @PhParam(name="pos", optional=true) @Nullable Integer pos) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fn, (String)"fn");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        TopData<V> topData = this.getTopData(fn, type);
        if (topData == null) {
            return null;
        }
        TopData<V> topData2 = topData;
        Integer n = pos;
        return n != null ? Boolean.valueOf(topData2.getTopPosition(n).isPresent()) : Boolean.valueOf(topData2.getPositionOf(this.getContextObject$core(context)).isPresent());
    }

    @PhFn
    @Nullable
    public final Object isIncluded(@NotNull KingdomsPlaceholderTranslationContext context, @NotNull PlaceholderFunctionInvoker fn, @PhParam(name="type") @NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fn, (String)"fn");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        TopData<V> topData = this.getTopData(fn, type);
        if (topData == null) {
            return null;
        }
        TopData<V> topData2 = topData;
        return topData2.isIncluded(this.getContextObject$core(context));
    }

    @PhFn
    @Nullable
    public final Object at(@NotNull PlaceholderFunctionInvoker fn, @PhParam(name="type") @NotNull String type, @PhParam(name="pos") int position, @PhParam(name="of") @NotNull String of) {
        Intrinsics.checkNotNullParameter((Object)fn, (String)"fn");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)of, (String)"of");
        if (position <= 0) {
            fn.invalidArg("pos", "Position must be a positive number, got " + position);
            return null;
        }
        TopData<V> topData = this.getTopData(fn, type);
        if (topData == null) {
            return null;
        }
        TopData<V> topData2 = topData;
        Placeholder placeholder = PlaceholderParser.parse(of, true);
        KingdomsPlaceholder kingdomsPlaceholder = placeholder instanceof KingdomsPlaceholder ? (KingdomsPlaceholder)placeholder : null;
        if (kingdomsPlaceholder == null) {
            return null;
        }
        KingdomsPlaceholder ph = kingdomsPlaceholder;
        V v = topData2.getTopPosition(position).orElse(null);
        if (v == null) {
            Object[] objectArray = new Object[]{"position", position};
            return KingdomsLang.PLACEHOLDERS_TOP_NOT_FOUND.parse(objectArray);
        }
        V dataAtPosition = v;
        return ph.request(this.createContext$core(dataAtPosition));
    }
}

