/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.locale.placeholders;

import java.time.Duration;
import java.util.function.Function;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.utils.cache.single.CachedFunction;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\b\u0016\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003B#\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\f\u001a\u00028\u00012\u0006\u0010\r\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/kingdoms/locale/placeholders/AsyncExpirableFunction;", "I", "O", "Lorg/kingdoms/utils/cache/single/CachedFunction;", "cacheTime", "Ljava/time/Duration;", "function", "Ljava/util/function/Function;", "<init>", "(Ljava/time/Duration;Ljava/util/function/Function;)V", "lastChecked", "", "apply", "input", "(Ljava/lang/Object;)Ljava/lang/Object;", "core"})
public class AsyncExpirableFunction<I, O>
extends CachedFunction<I, O> {
    @NotNull
    private final Duration cacheTime;
    private long lastChecked;

    public AsyncExpirableFunction(@NotNull Duration cacheTime, @NotNull Function<I, O> function) {
        Intrinsics.checkNotNullParameter((Object)cacheTime, (String)"cacheTime");
        Intrinsics.checkNotNullParameter(function, (String)"function");
        super(function);
        this.cacheTime = cacheTime;
        this.lastChecked = System.currentTimeMillis();
        if (this.cacheTime.getSeconds() <= 5L) {
            throw new IllegalArgumentException("Any cache time under 5 seconds is not likely to help with performance: " + this.cacheTime.toMillis() + "ms");
        }
    }

    @Override
    public O apply(I input) {
        long currentTime = System.currentTimeMillis();
        long diff = currentTime - this.lastChecked;
        if (this.cached == null || this.cacheTime.minusMillis(diff).isNegative()) {
            Kingdoms.taskScheduler().async().execute(() -> AsyncExpirableFunction.apply$lambda$0(this, input));
            this.lastChecked = currentTime;
        }
        Object object = this.cached;
        Intrinsics.checkNotNull((Object)object);
        return (O)object;
    }

    private static final void apply$lambda$0(AsyncExpirableFunction this$0, Object $input) {
        this$0.cached = this$0.function.apply($input);
    }
}

