/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.locale.messenger;

import java.util.Arrays;
import java.util.List;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.admin.CommandAdminTrack;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.config.annotations.AdvancedMessage;
import org.kingdoms.config.annotations.Comment;
import org.kingdoms.config.annotations.Path;
import org.kingdoms.config.annotations.RawPath;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.collections.ArraysKt;
import org.kingdoms.libs.kotlin.jvm.JvmStatic;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.libs.kotlin.text.StringsKt;
import org.kingdoms.libs.snakeyaml.markers.Mark;
import org.kingdoms.libs.snakeyaml.nodes.Node;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.Language;
import org.kingdoms.locale.LanguageEntry;
import org.kingdoms.locale.LanguageManager;
import org.kingdoms.locale.SupportedLanguage;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.locale.provider.MessageProvider;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.utils.internal.arrays.ArrayUtils;
import org.kingdoms.utils.string.Strings;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0007H&J\n\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\n\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\b\u0010\f\u001a\u00020\rH&J\n\u0010\u000e\u001a\u0004\u0018\u00010\rH&J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0016\u00c0\u0006\u0001"}, d2={"Lorg/kingdoms/locale/messenger/DefinedMessenger;", "Lorg/kingdoms/locale/messenger/Messenger;", "getProvider", "Lorg/kingdoms/locale/provider/MessageProvider;", "locale", "Lorg/kingdoms/locale/Language;", "getLanguageEntry", "Lorg/kingdoms/locale/LanguageEntry;", "getComment", "Lorg/kingdoms/config/annotations/Comment;", "getAdvancedData", "Lorg/kingdoms/config/annotations/AdvancedMessage;", "name", "", "getDefaultValue", "sendMessage", "", "receiver", "Lorg/bukkit/command/CommandSender;", "context", "Lorg/kingdoms/locale/placeholders/context/MessagePlaceholderProvider;", "Companion", "core"})
public interface DefinedMessenger
extends Messenger {
    @NotNull
    public static final Companion Companion = org.kingdoms.locale.messenger.DefinedMessenger$Companion.$$INSTANCE;

    @Override
    @NotNull
    default public MessageProvider getProvider(@NotNull Language locale) {
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        MessageProvider messageProvider = locale.getMessage(this.getLanguageEntry(), true);
        if (messageProvider == null) {
            throw new AssertionError((Object)("Language returned null for " + locale + "->" + this.getLanguageEntry()));
        }
        return messageProvider;
    }

    @NotNull
    public LanguageEntry getLanguageEntry();

    @Nullable
    default public Comment getComment() {
        Comment comment;
        try {
            comment = this.getClass().getField(this.name()).getAnnotation(Comment.class);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        return comment;
    }

    @Nullable
    default public AdvancedMessage getAdvancedData() {
        AdvancedMessage advancedMessage;
        try {
            advancedMessage = this.getClass().getField(this.name()).getAnnotation(AdvancedMessage.class);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        return advancedMessage;
    }

    @NotNull
    public String name();

    @Nullable
    public String getDefaultValue();

    @Override
    default public void sendMessage(@NotNull CommandSender receiver, @NotNull MessagePlaceholderProvider context) {
        Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (KingdomsConfig.PREFIX.getBoolean()) {
            context.usePrefix(true);
        }
        Language language = receiver instanceof Player ? KingdomPlayer.getKingdomPlayer((OfflinePlayer)receiver).getLanguage() : context.getLanguage();
        Intrinsics.checkNotNull((Object)language);
        Language locale = language;
        context.lang(locale);
        if (CommandAdminTrack.isTracking(receiver) && this != KingdomsLang.COMMAND_ADMIN_TRACK_TRACKED && this != KingdomsLang.COMMAND_ADMIN_TRACK_GUI) {
            SupportedLanguage trackable = (SupportedLanguage)locale;
            String file = StringsKt.replace$default((String)((Object)Kingdoms.getFolder().relativize(trackable.getMainLanguageFile())).toString(), (char)' ', (char)'*', (boolean)false, (int)4, null);
            Node node = trackable.getAdapter().getConfig().findNode(this.getLanguageEntry().getPath());
            Object object = node;
            if (object == null || (object = ((Node)object).getStartMark()) == null || (object = Integer.valueOf(((Mark)object).getLine()).toString()) == null) {
                object = KingdomsLang.UNKNOWN;
            }
            Object line = object;
            KingdomsLang.COMMAND_ADMIN_TRACK_TRACKED.getProvider(locale).send(receiver, new MessagePlaceholderProvider().parse("path", Strings.join(this.getLanguageEntry().getPath(), " {$sep}-> {$s}")).raw("file", file).raw("raw", LanguageManager.getRawMessage(this, (SupportedLanguage)locale)).parse("line", line));
        }
        this.getProvider(locale).send(receiver, context);
    }

    @JvmStatic
    @Nullable
    public static Path getAnnotatedPath(@NotNull DefinedMessenger $this$getAnnotatedPath) {
        return Companion.getAnnotatedPath($this$getAnnotatedPath);
    }

    @JvmStatic
    public static boolean isRawPath(@NotNull DefinedMessenger $this$isRawPath) {
        return Companion.isRawPath($this$isRawPath);
    }

    @JvmStatic
    @NotNull
    public static LanguageEntry getEntry(@Nullable String prefix, @NotNull DefinedMessenger lang, @NotNull int[] group) {
        return Companion.getEntry(prefix, lang, group);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u0004\u0018\u00010\u0005*\u00020\u0006H\u0007J\f\u0010\u0007\u001a\u00020\b*\u00020\u0006H\u0007J\"\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0007\u00a8\u0006\u0010"}, d2={"Lorg/kingdoms/locale/messenger/DefinedMessenger$Companion;", "", "<init>", "()V", "getAnnotatedPath", "Lorg/kingdoms/config/annotations/Path;", "Lorg/kingdoms/locale/messenger/DefinedMessenger;", "isRawPath", "", "getEntry", "Lorg/kingdoms/locale/LanguageEntry;", "prefix", "", "lang", "group", "", "core"})
    @SourceDebugExtension(value={"SMAP\nDefinedMessenger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefinedMessenger.kt\norg/kingdoms/locale/messenger/DefinedMessenger$Companion\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,132:1\n37#2:133\n36#2,3:134\n*S KotlinDebug\n*F\n+ 1 DefinedMessenger.kt\norg/kingdoms/locale/messenger/DefinedMessenger$Companion\n*L\n120#1:133\n120#1:134,3\n*E\n"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final Path getAnnotatedPath(@NotNull DefinedMessenger $this$getAnnotatedPath) {
            Path path;
            Intrinsics.checkNotNullParameter((Object)$this$getAnnotatedPath, (String)"<this>");
            try {
                path = $this$getAnnotatedPath.getClass().getField($this$getAnnotatedPath.name()).getAnnotation(Path.class);
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
            return path;
        }

        @JvmStatic
        public final boolean isRawPath(@NotNull DefinedMessenger $this$isRawPath) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)$this$isRawPath, (String)"<this>");
            try {
                bl = $this$isRawPath.getClass().getField($this$isRawPath.name()).getAnnotation(RawPath.class) != null;
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
            return bl;
        }

        @JvmStatic
        @NotNull
        public final LanguageEntry getEntry(@Nullable String prefix, @NotNull DefinedMessenger lang, @NotNull int[] group) {
            Intrinsics.checkNotNullParameter((Object)lang, (String)"lang");
            Intrinsics.checkNotNullParameter((Object)group, (String)"group");
            Path annotatedPath = this.getAnnotatedPath(lang);
            if (annotatedPath != null) {
                return new LanguageEntry(annotatedPath.value());
            }
            int[] finalGroup = group;
            boolean isCommand = StringsKt.startsWith$default((String)lang.name(), (String)"COMMAND_", (boolean)false, (int)2, null);
            if (isCommand && group.length == 0) {
                int[] nArray;
                int[] nArray2;
                if (StringsKt.startsWith$default((String)lang.name(), (String)"COMMAND_ADMIN_", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)lang.name(), (String)"COMMAND_NATION_", (boolean)false, (int)2, null)) {
                    nArray2 = new int[]{1, 2, 3};
                    nArray = nArray2;
                } else {
                    nArray2 = new int[]{1, 2};
                    nArray = nArray2;
                }
                finalGroup = nArray;
            }
            try {
                List<String> list = Strings.split(Strings.getGroupedOption(lang.name(), Arrays.copyOf(finalGroup, finalGroup.length)), '.', false);
                Intrinsics.checkNotNullExpressionValue(list, (String)"split(...)");
                String[] $this$toTypedArray$iv = (String[])list;
                boolean $i$f$toTypedArray = false;
                String[] thisCollection$iv = $this$toTypedArray$iv;
                String[] grouped = thisCollection$iv.toArray(new String[0]);
                if (prefix != null && !isCommand && !this.isRawPath(lang)) {
                    $this$toTypedArray$iv = new String[]{prefix};
                    grouped = ArrayUtils.merge($this$toTypedArray$iv, grouped);
                }
                return new LanguageEntry(grouped);
            }
            catch (IndexOutOfBoundsException ex) {
                StringBuilder stringBuilder = new StringBuilder().append("Invalid number of groups provided for ");
                String string = prefix;
                if (string == null) {
                    string = "";
                }
                throw new RuntimeException(stringBuilder.append(string).append(' ').append(lang).append(" -> ").append(ArraysKt.joinToString$default((int[])group, null, null, null, (int)0, null, null, (int)63, null)).toString(), ex);
            }
        }

        static {
            $$INSTANCE = new Companion();
        }
    }
}

