/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.locale.compiler.placeholders.types;

import java.util.List;
import org.bukkit.entity.Player;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.KotlinNothingValueException;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.text.StringsKt;
import org.kingdoms.locale.compiler.placeholders.modifiers.PlaceholderModifier;
import org.kingdoms.locale.compiler.placeholders.types.AbstractPlaceholder;
import org.kingdoms.locale.placeholders.context.PlaceholderProvider;
import org.kingdoms.locale.placeholders.target.BasePlaceholderTargetProvider;
import org.kingdoms.locale.placeholders.target.PlaceholderTargetProvider;
import org.kingdoms.permissions.AbstractPluginPermission;
import org.kingdoms.permissions.Permission;
import org.kingdoms.permissions.registry.PermissionRegistry;
import org.kingdoms.server.permission.PermissionDefaultValue;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/kingdoms/locale/compiler/placeholders/types/PermissionPlaceholder;", "Lorg/kingdoms/locale/compiler/placeholders/types/AbstractPlaceholder;", "originalString", "", "permission", "pointer", "modifiers", "", "Lorg/kingdoms/locale/compiler/placeholders/modifiers/PlaceholderModifier;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;)V", "asString", "full", "", "realPermission", "Lorg/kingdoms/permissions/Permission;", "request", "", "provider", "Lorg/kingdoms/locale/placeholders/context/PlaceholderProvider;", "core"})
public final class PermissionPlaceholder
extends AbstractPlaceholder {
    @NotNull
    private final String permission;
    @NotNull
    private final Permission realPermission;

    public PermissionPlaceholder(@NotNull String originalString, @NotNull String permission, @Nullable String pointer, @NotNull List<? extends PlaceholderModifier> modifiers) {
        Intrinsics.checkNotNullParameter((Object)originalString, (String)"originalString");
        Intrinsics.checkNotNullParameter((Object)permission, (String)"permission");
        Intrinsics.checkNotNullParameter(modifiers, (String)"modifiers");
        super(originalString, pointer, modifiers);
        this.permission = permission;
        this.realPermission = AbstractPluginPermission.Companion.of(StringsKt.replace$default((String)this.permission, (String)"_", (String)".", (boolean)false, (int)4, null), PermissionDefaultValue.OP);
        PermissionRegistry.Companion.registerToAllRegistries(this.realPermission, false);
    }

    @Override
    @NotNull
    public String asString(boolean full) {
        return this.getCommonString(full, "perm_" + this.permission);
    }

    @Override
    @NotNull
    public Object request(@NotNull PlaceholderProvider provider) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        if (!(provider instanceof PlaceholderTargetProvider)) {
            this.error("Cannot use permission placeholders here with no player context: " + provider);
            throw new KotlinNothingValueException();
        }
        BasePlaceholderTargetProvider targetProvider = ((PlaceholderTargetProvider)provider).getTargetProviderFor(this.getPointer());
        if (!(targetProvider.getPrimaryTarget() instanceof Player)) {
            this.error("Cannot use permission placeholders here with no player context: " + targetProvider.getPrimaryTarget());
            throw new KotlinNothingValueException();
        }
        Object object = targetProvider.getPrimaryTarget();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.bukkit.entity.Player");
        boolean hasPermission = ((Player)object).hasPermission(this.realPermission.toFullName());
        return String.valueOf(hasPermission);
    }
}

