/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.locale.compiler.placeholders.types;

import java.util.Collection;
import java.util.List;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.collections.CollectionsKt;
import org.kingdoms.libs.kotlin.jvm.JvmStatic;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.locale.compiler.PlaceholderTranslationContext;
import org.kingdoms.locale.compiler.placeholders.Placeholder;
import org.kingdoms.locale.compiler.placeholders.modifiers.PlaceholderModifier;
import org.kingdoms.locale.compiler.placeholders.types.PlaceholderTranslationException;
import org.kingdoms.locale.placeholders.context.PlaceholderProvider;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0001\n\u0002\b\u0003\b&\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0003H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0010H\u0096\u0002J\u0018\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0003H\u0004J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0003R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001f"}, d2={"Lorg/kingdoms/locale/compiler/placeholders/types/AbstractPlaceholder;", "Lorg/kingdoms/locale/compiler/placeholders/Placeholder;", "originalString", "", "pointer", "modifiers", "", "Lorg/kingdoms/locale/compiler/placeholders/modifiers/PlaceholderModifier;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;)V", "getOriginalString", "()Ljava/lang/String;", "getPointer", "getModifiers", "()Ljava/util/List;", "request", "", "provider", "Lorg/kingdoms/locale/placeholders/context/PlaceholderProvider;", "toString", "hashCode", "", "equals", "", "other", "getCommonString", "full", "error", "", "msg", "Companion", "core"})
public abstract class AbstractPlaceholder
implements Placeholder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String originalString;
    @Nullable
    private final String pointer;
    @NotNull
    private final List<PlaceholderModifier> modifiers;

    public AbstractPlaceholder(@NotNull String originalString, @Nullable String pointer, @NotNull List<? extends PlaceholderModifier> modifiers) {
        Intrinsics.checkNotNullParameter((Object)originalString, (String)"originalString");
        Intrinsics.checkNotNullParameter(modifiers, (String)"modifiers");
        this.originalString = originalString;
        this.pointer = pointer;
        this.modifiers = modifiers;
    }

    @Override
    @NotNull
    public String getOriginalString() {
        return this.originalString;
    }

    @Override
    @Nullable
    public String getPointer() {
        return this.pointer;
    }

    @Override
    @NotNull
    public List<PlaceholderModifier> getModifiers() {
        return this.modifiers;
    }

    @Override
    @Nullable
    public Object request(@NotNull PlaceholderProvider provider) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        throw new UnsupportedOperationException("Cannot translate placeholder manually: " + this);
    }

    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + '(' + this.getOriginalString() + " | " + this.asString(true) + ')';
    }

    public int hashCode() {
        throw new UnsupportedOperationException();
    }

    public boolean equals(@Nullable Object other) {
        throw new UnsupportedOperationException();
    }

    @NotNull
    protected final String getCommonString(boolean full, @NotNull String other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        String string = "";
        if (this.getPointer() != null) {
            string = string + this.getPointer() + '*';
        }
        if (!((Collection)this.getModifiers()).isEmpty()) {
            string = string + CollectionsKt.joinToString$default((Iterable)this.getModifiers(), (CharSequence)"@", null, null, (int)0, null, AbstractPlaceholder::getCommonString$lambda$0, (int)30, null) + '@';
        }
        return full ? '%' + string + other + '%' : string + other;
    }

    @NotNull
    public final Void error(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        throw new PlaceholderTranslationException(this, msg);
    }

    private static final CharSequence getCommonString$lambda$0(PlaceholderModifier it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getName();
    }

    @JvmStatic
    @Nullable
    public static final Object wrapWithDefaultContextProvider(@Nullable Object placeholder) {
        return Companion.wrapWithDefaultContextProvider(placeholder);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u00012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0001H\u0007\u00a8\u0006\u0006"}, d2={"Lorg/kingdoms/locale/compiler/placeholders/types/AbstractPlaceholder$Companion;", "", "<init>", "()V", "wrapWithDefaultContextProvider", "placeholder", "core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final Object wrapWithDefaultContextProvider(@Nullable Object placeholder) {
            return !(placeholder instanceof String) ? placeholder : PlaceholderTranslationContext.withDefaultContext(placeholder);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

