/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.locale.compiler.pieces;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.KeybindComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.TranslatableComponent;
import net.md_5.bungee.chat.TranslationRegistry;
import org.kingdoms.data.Pair;
import org.kingdoms.libs.xseries.reflection.XReflection;
import org.kingdoms.locale.compiler.MessageCompiler;
import org.kingdoms.locale.compiler.MessageCompilerSettings;
import org.kingdoms.locale.compiler.MessageObject;
import org.kingdoms.locale.compiler.PlaceholderTranslationContext;
import org.kingdoms.locale.compiler.builders.MessageObjectBuilder;
import org.kingdoms.locale.compiler.builders.context.ComplexMessageBuilderContextProvider;
import org.kingdoms.locale.compiler.builders.context.HTMLMessageBuilderContextProvider;
import org.kingdoms.locale.compiler.builders.context.MessageBuilderContextProvider;
import org.kingdoms.locale.compiler.builders.context.PlainMessageBuilderContextProvider;
import org.kingdoms.locale.compiler.placeholders.Placeholder;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.locale.placeholders.context.PlaceholderContextBuilder;
import org.kingdoms.utils.ColorUtils;
import org.kingdoms.utils.XComponentBuilder;
import org.kingdoms.utils.compilers.expressions.ConditionalExpression;
import org.kingdoms.utils.conditions.ConditionProcessor;

public abstract class MessagePiece {
    public abstract void build(ComplexMessageBuilderContextProvider var1);

    public abstract void build(PlainMessageBuilderContextProvider var1);

    public abstract void build(HTMLMessageBuilderContextProvider var1);

    public abstract int length();

    public abstract int jsonLength();

    public static final class Hover
    extends MessagePiece {
        private final ClickAction clickActionType;
        private final MessagePiece[] normalMessage;
        private final MessagePiece[] hoverMessage;
        private final MessagePiece[] clickAction;
        private static final int JSON_LEN = "{  \"clickEvent\": {    \"action\": \"ACTION\",    \"value\": \"VALUE\"  },\n  \"hoverEvent\": {    \"action\": \"show_text\",    \"contents\": []  },\n  \"extra\": [],  \"text\": \"\"},".replace(" ", "").length();

        public Hover(ClickAction clickActionType, MessagePiece[] normalMessage, MessagePiece[] hoverMessage, MessagePiece[] clickAction) {
            this.clickActionType = clickActionType;
            this.normalMessage = Objects.requireNonNull(normalMessage);
            this.hoverMessage = hoverMessage;
            this.clickAction = clickAction;
        }

        @Override
        public void build(ComplexMessageBuilderContextProvider context) {
            PlainMessageBuilderContextProvider actionProvider = new PlainMessageBuilderContextProvider(context.getSettings());
            for (MessagePiece messagePiece : this.clickAction) {
                messagePiece.build(actionProvider);
            }
            ClickEvent clickEvent = this.clickActionType == null || this.clickActionType == ClickAction.INSERTION ? null : (this.clickActionType.action == null ? new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "Unsupported action: " + (Object)((Object)this.clickActionType)) : new ClickEvent(this.clickActionType.action, actionProvider.merge()));
            TextComponent parent = context.getComponent().getText().isEmpty() ? context.getComponent() : context.newComponent(ComponentBuilder.FormatRetention.FORMATTING);
            ComplexMessageBuilderContextProvider msgProvider = new ComplexMessageBuilderContextProvider(context, new XComponentBuilder(), parent, context.getSettings());
            for (MessagePiece piece : this.normalMessage) {
                msgProvider.build(piece);
            }
            msgProvider.appendRemaining();
            ComplexMessageBuilderContextProvider complexMessageBuilderContextProvider = new ComplexMessageBuilderContextProvider(context, new XComponentBuilder(), new TextComponent(), context.getSettings());
            for (MessagePiece piece : this.hoverMessage) {
                complexMessageBuilderContextProvider.build(piece);
            }
            complexMessageBuilderContextProvider.appendRemaining();
            HoverEvent hoverEvent = MessageCompiler.constructHoverEvent(complexMessageBuilderContextProvider.getBuilder().createSingular());
            parent.setHoverEvent(hoverEvent);
            if (clickEvent != null) {
                parent.setClickEvent(clickEvent);
            }
            if (this.clickActionType == ClickAction.INSERTION) {
                parent.setInsertion(actionProvider.merge());
            }
            for (BaseComponent baseComponent : msgProvider.getBuilder().createSingular()) {
                parent.addExtra(baseComponent);
            }
            context.newComponent(ComponentBuilder.FormatRetention.FORMATTING);
        }

        @Override
        public void build(PlainMessageBuilderContextProvider context) {
            Arrays.stream(this.normalMessage).forEach(x -> x.build(context));
        }

        @Override
        public void build(HTMLMessageBuilderContextProvider context) {
            HTMLMessageBuilderContextProvider hoverProvider = new HTMLMessageBuilderContextProvider(context.getSettings());
            for (MessagePiece piece : this.hoverMessage) {
                hoverProvider.build(piece);
            }
            context.getCurrentElement().hover = hoverProvider.getHTML().toString();
        }

        public MessagePiece[] getHoverMessage() {
            return this.hoverMessage;
        }

        public MessagePiece[] getClickAction() {
            return this.clickAction;
        }

        public MessagePiece[] getNormalMessage() {
            return this.normalMessage;
        }

        @Override
        public int length() {
            return Arrays.stream(this.normalMessage).mapToInt(MessagePiece::length).sum();
        }

        @Override
        public int jsonLength() {
            return JSON_LEN + Arrays.stream(this.normalMessage).mapToInt(MessagePiece::jsonLength).sum() + Arrays.stream(this.hoverMessage).mapToInt(MessagePiece::jsonLength).sum() + Arrays.stream(this.clickAction).mapToInt(MessagePiece::jsonLength).sum();
        }

        public String toString() {
            String actionStr = "No Action";
            if (this.clickActionType != null) {
                actionStr = (Object)((Object)this.clickActionType) + " -> " + Arrays.toString(this.clickAction);
            }
            return "Hover{ length=" + this.length() + " | " + Arrays.toString(this.normalMessage) + ';' + Arrays.toString(this.hoverMessage) + ';' + actionStr + " }";
        }

        public static enum ClickAction {
            OPEN_URL,
            OPEN_FILE,
            RUN_COMMAND,
            SUGGEST_COMMAND,
            CHANGE_PAGE,
            COPY_TO_CLIPBOARD,
            INSERTION;

            private final ClickEvent.Action action;

            private ClickAction() {
                ClickEvent.Action action;
                try {
                    action = ClickEvent.Action.valueOf((String)this.name());
                }
                catch (IllegalArgumentException ex) {
                    action = null;
                }
                this.action = action;
            }
        }
    }

    public static final class ColorAccessor
    extends Color {
        private final int index;
        private final Variable variable;

        public ColorAccessor(int index, Variable variable) {
            this.index = index;
            this.variable = variable;
        }

        public List<MessagePiece> getLastColors(MessagePlaceholderProvider context) {
            MessageObject obj;
            ArrayList<MessagePiece> pieces = new ArrayList<MessagePiece>(3);
            Object translated = this.variable.getPlaceholder(context);
            if (translated == null) {
                return Collections.singletonList(new Plain('{' + this.variable.placeholder.asString(true) + " & " + this.index + '}'));
            }
            if (translated instanceof MessageObject) {
                obj = (MessageObject)translated;
            } else if (translated instanceof PlaceholderTranslationContext) {
                obj = this.variable.getCompiled(translated);
            } else {
                pieces.add(new Plain('{' + this.variable.placeholder.asString(true) + " & " + this.index + " (this special placeholder which is of type" + translated.getClass() + " -> " + translated + " is not supported for color accessors}"));
                return pieces;
            }
            return obj.findColorPieces(Math.abs(this.index), this.index < 0);
        }

        @Override
        public void build(ComplexMessageBuilderContextProvider context) {
            for (MessagePiece piece : this.getLastColors(context.getSettings())) {
                context.build(piece);
            }
        }

        @Override
        public void build(PlainMessageBuilderContextProvider context) {
            for (MessagePiece piece : this.getLastColors(context.getSettings())) {
                context.build(piece);
            }
        }

        @Override
        public void build(HTMLMessageBuilderContextProvider context) {
            for (MessagePiece piece : this.getLastColors(context.getSettings())) {
                context.build(piece);
            }
        }

        @Override
        public int jsonLength() {
            return 5;
        }

        @Override
        public int length() {
            return 4;
        }

        public String toString() {
            return "ColorAccessor{ " + this.variable.toString() + " & " + this.index + " }";
        }
    }

    public static final class Variable
    extends MessagePiece {
        private final Placeholder placeholder;

        public Variable(Placeholder placeholder) {
            this.placeholder = placeholder;
        }

        @Override
        public void build(ComplexMessageBuilderContextProvider context) {
            Object translated = this.getPlaceholder(context.getSettings());
            if (translated == null) {
                context.newComponent(ComponentBuilder.FormatRetention.FORMATTING).setText(this.placeholder.asString(true));
                return;
            }
            context.getSettings().usePrefix(false);
            if (translated instanceof MessageObjectBuilder) {
                MessageObjectBuilder obj = (MessageObjectBuilder)translated;
                obj.build(context);
                return;
            }
            if (!(translated instanceof PlaceholderTranslationContext)) {
                TextComponent placeholderComp = context.newComponent(ComponentBuilder.FormatRetention.ALL);
                placeholderComp.setText(translated.toString());
                return;
            }
            MessageObject varObj = this.getCompiled(translated);
            varObj.build(context);
        }

        public Placeholder getPlaceholder() {
            return this.placeholder;
        }

        @Override
        public void build(PlainMessageBuilderContextProvider context) {
            Object translated = this.getPlaceholder(context.getSettings());
            if (translated == null) {
                context.getCurrentLine().append(this.placeholder.asString(true));
                return;
            }
            context.getSettings().usePrefix(false);
            if (translated instanceof MessageObjectBuilder) {
                MessageObjectBuilder obj = (MessageObjectBuilder)translated;
                obj.build(context);
                return;
            }
            if (!(translated instanceof PlaceholderTranslationContext)) {
                context.getCurrentLine().append(translated);
                return;
            }
            MessageObject varObj = this.getCompiled(translated);
            varObj.build(context);
        }

        @Override
        public void build(HTMLMessageBuilderContextProvider context) {
            Object translated = this.getPlaceholder(context.getSettings());
            if (translated == null) {
                context.getCurrentElement().text = HTMLMessageBuilderContextProvider.escape(this.placeholder.asString(true));
                return;
            }
            context.getSettings().usePrefix(false);
            if (translated instanceof MessageObjectBuilder) {
                MessageObjectBuilder obj = (MessageObjectBuilder)translated;
                obj.build(context);
                return;
            }
            if (!(translated instanceof PlaceholderTranslationContext)) {
                context.getCurrentElement().text = HTMLMessageBuilderContextProvider.escape(translated.toString());
                return;
            }
            MessageObject varObj = this.getCompiled(translated);
            varObj.build(context);
        }

        public MessageObject getCompiled(Object translated) {
            PlaceholderTranslationContext settings = (PlaceholderTranslationContext)translated;
            translated = settings.getValue();
            MessageCompilerSettings compilerSettings = settings.getSettings();
            return MessageCompiler.compile(translated.toString(), compilerSettings);
        }

        public Object getPlaceholder(MessagePlaceholderProvider context) {
            Object translated = this.placeholder.request(context);
            translated = this.placeholder.process(translated);
            translated = PlaceholderTranslationContext.unwrapContextualPlaceholder(translated, context);
            return translated;
        }

        @Override
        public int length() {
            return this.placeholder.asString(true).length();
        }

        @Override
        public int jsonLength() {
            return this.length();
        }

        public String toString() {
            return "Variable{ " + this.placeholder + " }";
        }
    }

    public static final class Translate
    extends MessagePiece {
        private final String messageId;
        private final String fallback;
        private static final boolean SUPPORTS_FALLBACK = XReflection.of(TranslatableComponent.class).method("public void setFallback(String fallback)").exists();

        public Translate(String messageId, String fallback) {
            this.messageId = messageId;
            this.fallback = fallback;
        }

        @Override
        public void build(ComplexMessageBuilderContextProvider context) {
            TranslatableComponent comp = new TranslatableComponent(this.messageId, new Object[0]);
            if (this.fallback != null && SUPPORTS_FALLBACK) {
                comp.setFallback(this.fallback);
            }
            context.newComponent(ComponentBuilder.FormatRetention.FORMATTING, new BaseComponent[]{comp});
            context.newComponent(ComponentBuilder.FormatRetention.FORMATTING);
        }

        @Override
        public void build(PlainMessageBuilderContextProvider context) {
            String english = TranslationRegistry.INSTANCE.translate(this.messageId);
            String use = Strings.isNullOrEmpty((String)english) ? this.fallback : english;
            context.getCurrentLine().append(use);
        }

        @Override
        public void build(HTMLMessageBuilderContextProvider context) {
            String english = TranslationRegistry.INSTANCE.translate(this.messageId);
            String use = Strings.isNullOrEmpty((String)english) ? this.fallback : english;
            context.getHTML().append("<span>").append(use).append("</span>");
        }

        @Override
        public int length() {
            return this.messageId.length();
        }

        @Override
        public int jsonLength() {
            return this.length();
        }
    }

    public static final class KeyBind
    extends MessagePiece {
        private final String keybind;

        public KeyBind(String keybind) {
            this.keybind = keybind;
        }

        @Override
        public void build(ComplexMessageBuilderContextProvider context) {
            KeybindComponent comp = new KeybindComponent(this.keybind);
            context.newComponent(ComponentBuilder.FormatRetention.FORMATTING, new BaseComponent[]{comp});
            context.newComponent(ComponentBuilder.FormatRetention.FORMATTING);
        }

        @Override
        public void build(PlainMessageBuilderContextProvider context) {
            context.getCurrentLine().append("<keybind>").append(this.keybind).append("</keybind>");
        }

        @Override
        public void build(HTMLMessageBuilderContextProvider context) {
            context.getHTML().append("<span class=\"minecraft-keybind\">").append(this.keybind).append("</span>");
        }

        @Override
        public int length() {
            return 30;
        }

        @Override
        public int jsonLength() {
            return 20;
        }
    }

    public static final class Font
    extends MessagePiece {
        private final String font;

        public Font(String font) {
            this.font = font;
        }

        @Override
        public void build(ComplexMessageBuilderContextProvider context) {
            context.newComponent(ComponentBuilder.FormatRetention.FORMATTING).setFont(this.font);
        }

        @Override
        public void build(PlainMessageBuilderContextProvider context) {
        }

        @Override
        public void build(HTMLMessageBuilderContextProvider context) {
        }

        @Override
        public int length() {
            return 0;
        }

        @Override
        public int jsonLength() {
            return 0;
        }
    }

    public static final class NewLine
    extends MessagePiece {
        public static final NewLine INSTANCE = new NewLine();

        private NewLine() {
        }

        @Override
        public void build(ComplexMessageBuilderContextProvider context) {
            TextComponent comp = context.getComponent();
            comp.setText(comp.getText() + '\n');
        }

        @Override
        public void build(PlainMessageBuilderContextProvider context) {
            context.newLine();
        }

        @Override
        public void build(HTMLMessageBuilderContextProvider context) {
            context.newLine();
        }

        @Override
        public int length() {
            return 1;
        }

        @Override
        public int jsonLength() {
            return 0;
        }

        public String toString() {
            return "Newline";
        }
    }

    public static final class HexColor
    extends Color {
        private final java.awt.Color color;
        private final ChatColor componentColor;
        private static final int JSON_LEN = "\"color\":\"\",".length() + 6;

        public java.awt.Color getColor() {
            return this.color;
        }

        public HexColor(java.awt.Color color) {
            this.color = color;
            this.componentColor = XReflection.supports((int)16) ? ChatColor.of((java.awt.Color)color) : null;
        }

        @Override
        public void build(ComplexMessageBuilderContextProvider context) {
            if (this.componentColor == null) {
                org.bukkit.ChatColor translated = ColorUtils.hexColorToLegacy(this.color);
                context.build(new SimpleColor(translated));
                return;
            }
            TextComponent comp = context.newComponent(ComponentBuilder.FormatRetention.NONE);
            comp.setColor(this.componentColor);
        }

        @Override
        public void build(PlainMessageBuilderContextProvider context) {
            if (this.componentColor == null) {
                org.bukkit.ChatColor translated = ColorUtils.hexColorToLegacy(this.color);
                new SimpleColor(translated).build(context);
                return;
            }
            context.getCurrentLine().append(this.componentColor);
        }

        @Override
        public void build(HTMLMessageBuilderContextProvider context) {
            if (context.getCurrentElement().isEmpty()) {
                context.newElement(false);
            }
            context.getCurrentElement().color = '#' + ColorUtils.toHexString(this.color);
        }

        @Override
        public int length() {
            return 12;
        }

        @Override
        public int jsonLength() {
            return JSON_LEN;
        }

        public String toString() {
            return "Hex{ " + ColorUtils.toHexString(this.color) + " }";
        }
    }

    public static final class SimpleColor
    extends Color {
        private final org.bukkit.ChatColor color;
        private static final int JSON_LEN = "\"color\":\"\",".length();

        public SimpleColor(org.bukkit.ChatColor color) {
            this.color = color;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof SimpleColor)) {
                return false;
            }
            return this.color == ((SimpleColor)obj).color;
        }

        @Override
        public void build(ComplexMessageBuilderContextProvider context) {
            if (this.color.isColor()) {
                TextComponent component = context.getComponent().getText().isEmpty() ? context.getComponent() : context.newComponent(ComponentBuilder.FormatRetention.NONE);
                component.setColor(this.color.asBungee());
                return;
            }
            if (this.color == org.bukkit.ChatColor.RESET) {
                context.newComponent(ComponentBuilder.FormatRetention.NONE);
                return;
            }
            TextComponent component = context.getComponent().getText().isEmpty() ? context.getComponent() : context.newComponent(ComponentBuilder.FormatRetention.FORMATTING);
            switch (this.color) {
                case BOLD: {
                    component.setBold(Boolean.valueOf(true));
                    break;
                }
                case ITALIC: {
                    component.setItalic(Boolean.valueOf(true));
                    break;
                }
                case UNDERLINE: {
                    component.setUnderlined(Boolean.valueOf(true));
                    break;
                }
                case STRIKETHROUGH: {
                    component.setStrikethrough(Boolean.valueOf(true));
                    break;
                }
                case MAGIC: {
                    component.setObfuscated(Boolean.valueOf(true));
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }

        @Override
        public void build(PlainMessageBuilderContextProvider context) {
            context.getCurrentLine().append('\u00a7').append(this.color.getChar());
        }

        @Override
        public void build(HTMLMessageBuilderContextProvider context) {
            if (this.color.isColor()) {
                if (!context.getCurrentElement().isEmpty()) {
                    context.newElement(false);
                }
                context.getCurrentElement().color = '#' + ColorUtils.toHexString(ColorUtils.legacyColorToHex(this.color));
                return;
            }
            if (this.color == org.bukkit.ChatColor.RESET) {
                context.newElement(false);
                return;
            }
            if (!context.getCurrentElement().isEmpty()) {
                context.newElement(true);
            }
            switch (this.color) {
                case BOLD: {
                    context.getCurrentElement().bold = true;
                    break;
                }
                case ITALIC: {
                    context.getCurrentElement().italic = true;
                    break;
                }
                case UNDERLINE: {
                    context.getCurrentElement().underlined = true;
                    break;
                }
                case STRIKETHROUGH: {
                    context.getCurrentElement().strikethrough = true;
                    break;
                }
                case MAGIC: {
                    context.getCurrentElement().obfuscated = true;
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }

        public org.bukkit.ChatColor getColor() {
            return this.color;
        }

        @Override
        public int length() {
            return 2;
        }

        @Override
        public int jsonLength() {
            return JSON_LEN + this.color.name().length();
        }

        public String toString() {
            return "SimpleColor{ " + this.color.name() + " }";
        }
    }

    public static abstract class Color
    extends MessagePiece {
    }

    public static final class Plain
    extends MessagePiece {
        private final String message;
        public static final Plain EMPTY = new Plain("");
        public static final int JSON_LEN = "\"text\":\"\"".length() + 3;

        public Plain(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }

        @Override
        public void build(ComplexMessageBuilderContextProvider context) {
            TextComponent comp = context.getComponent();
            comp.setText(comp.getText() + this.message);
        }

        @Override
        public void build(PlainMessageBuilderContextProvider context) {
            context.getCurrentLine().append(this.message);
        }

        @Override
        public void build(HTMLMessageBuilderContextProvider context) {
            context.getCurrentElement().text = HTMLMessageBuilderContextProvider.escape(this.message);
        }

        @Override
        public int length() {
            return this.message.length();
        }

        @Override
        public int jsonLength() {
            return JSON_LEN + this.length();
        }

        public String toString() {
            return "Plain{" + this.message + '}';
        }
    }

    public static final class Null
    extends MessagePiece {
        public static final Null INSTANCE = new Null();

        public static MessagePiece[] getArrayInstance() {
            return new MessagePiece[]{INSTANCE};
        }

        private Null() {
        }

        @Override
        public void build(ComplexMessageBuilderContextProvider context) {
        }

        @Override
        public void build(PlainMessageBuilderContextProvider context) {
        }

        @Override
        public void build(HTMLMessageBuilderContextProvider context) {
        }

        @Override
        public int length() {
            return 0;
        }

        @Override
        public int jsonLength() {
            return 0;
        }

        public String toString() {
            return "NullPiece";
        }
    }

    public static final class Conditional
    extends MessagePiece {
        private final List<Pair<ConditionalExpression, MessagePiece[]>> statements;

        public Conditional(List<Pair<ConditionalExpression, MessagePiece[]>> statements) {
            this.statements = statements;
        }

        public MessagePiece[] getPiece(PlaceholderContextBuilder context) {
            for (Pair<ConditionalExpression, MessagePiece[]> statement : this.statements) {
                if (!ConditionProcessor.process(statement.getKey(), context)) continue;
                return statement.getValue();
            }
            return Null.getArrayInstance();
        }

        public void addFor(MessageBuilderContextProvider ctx) {
            MessagePiece[] pieces = this.getPiece(ctx.getSettings());
            if (pieces == null) {
                return;
            }
            for (MessagePiece piece : pieces) {
                ctx.build(piece);
            }
        }

        public List<Pair<ConditionalExpression, MessagePiece[]>> getStatements() {
            return this.statements;
        }

        @Override
        public void build(ComplexMessageBuilderContextProvider context) {
            this.addFor(context);
        }

        @Override
        public void build(PlainMessageBuilderContextProvider context) {
            this.addFor(context);
        }

        @Override
        public void build(HTMLMessageBuilderContextProvider context) {
            this.addFor(context);
        }

        private int lengthStatement(Function<MessagePiece, Integer> lengthFn) {
            return this.statements.stream().map(Pair::getValue).map(x -> Arrays.stream(x).map(lengthFn).reduce(Integer::sum).orElse(0)).max(Integer::compareTo).orElse(0);
        }

        @Override
        public int length() {
            return this.lengthStatement(MessagePiece::length);
        }

        @Override
        public int jsonLength() {
            return this.lengthStatement(MessagePiece::jsonLength);
        }

        public String toString() {
            return "Conditional{" + this.statements.stream().map(x -> "[" + x.getKey() + " => " + Arrays.toString((Object[])x.getValue()) + ']').collect(Collectors.joining(" - ")) + '}';
        }
    }
}

