/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.locale.compiler.builders.context;

import com.google.common.html.HtmlEscapers;
import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import org.kingdoms.locale.compiler.MessageCompiler;
import org.kingdoms.locale.compiler.MessageCompilerSettings;
import org.kingdoms.locale.compiler.MessageObject;
import org.kingdoms.locale.compiler.PlaceholderTranslationContext;
import org.kingdoms.locale.compiler.builders.MessageObjectBuilder;
import org.kingdoms.locale.compiler.builders.context.MessageBuilderContextProvider;
import org.kingdoms.locale.compiler.pieces.MessagePiece;
import org.kingdoms.locale.compiler.placeholders.Placeholder;
import org.kingdoms.locale.compiler.placeholders.PlaceholderParser;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.locale.placeholders.context.PlaceholderProvider;

public final class HTMLMessageBuilderContextProvider
extends MessageBuilderContextProvider {
    public final List<HTMLElement> elements = new ArrayList<HTMLElement>();
    private HTMLElement currentElement = new HTMLElement();
    boolean used = false;

    public static String escape(String raw) {
        return HtmlEscapers.htmlEscaper().escape(raw);
    }

    public static void addHandler(MessagePlaceholderProvider ctx) {
        ctx.addChild("html", new HTMLTranslator(ctx));
        ctx.addChild("htmlStyle", new HTMLColorTranslator(ctx));
    }

    public HTMLMessageBuilderContextProvider(MessagePlaceholderProvider settings) {
        super(settings);
    }

    public HTMLElement getCurrentElement() {
        return this.currentElement;
    }

    public void newElement(boolean copyFormatting) {
        this.elements.add(this.currentElement);
        HTMLElement previousElement = this.currentElement;
        this.currentElement = new HTMLElement();
        if (copyFormatting) {
            this.currentElement.color = previousElement.color;
            this.currentElement.italic = previousElement.italic;
            this.currentElement.bold = previousElement.bold;
            this.currentElement.strikethrough = previousElement.strikethrough;
            this.currentElement.underlined = previousElement.underlined;
            this.currentElement.obfuscated = previousElement.obfuscated;
        }
    }

    public StringBuilder getHTML() {
        this.newElement(false);
        StringBuilder builder = new StringBuilder(this.elements.size() * 30);
        for (HTMLElement element : this.elements) {
            if (element == null) {
                builder.append("<br>");
                continue;
            }
            builder.append(element);
        }
        return builder;
    }

    public void newLine() {
        if (!this.currentElement.isEmpty()) {
            this.newElement(true);
        }
        this.elements.add(null);
    }

    @Override
    public void build(MessagePiece messagePiece) {
        messagePiece.build(this);
    }

    private static final class HTMLTranslator
    implements PlaceholderProvider {
        private final MessagePlaceholderProvider parent;

        private HTMLTranslator(MessagePlaceholderProvider parent) {
            this.parent = parent;
        }

        @Override
        public Object providePlaceholder(String placeholder) {
            Placeholder parsed = PlaceholderParser.parse(placeholder);
            MessagePiece.Variable asVar = new MessagePiece.Variable(parsed);
            HTMLMessageBuilderContextProvider builder = new HTMLMessageBuilderContextProvider(this.parent);
            builder.build(asVar);
            StringBuilder html = builder.getHTML();
            return html.toString();
        }
    }

    private static final class HTMLColorTranslator
    implements PlaceholderProvider {
        private final MessagePlaceholderProvider parent;

        private HTMLColorTranslator(MessagePlaceholderProvider parent) {
            this.parent = parent;
        }

        @Override
        public Object providePlaceholder(String placeholder) {
            MessageObject obj;
            Placeholder parsed = PlaceholderParser.parse(placeholder);
            MessagePiece.Variable asVar = new MessagePiece.Variable(parsed);
            Object translated = asVar.getPlaceholder(this.parent);
            if (translated == null) {
                return null;
            }
            if (translated instanceof MessageObjectBuilder) {
                MessageObjectBuilder builder = (MessageObjectBuilder)translated;
                obj = builder.evaluateDynamicPieces(this.parent);
            } else {
                obj = !(translated instanceof PlaceholderTranslationContext) ? MessageCompiler.compile(translated.toString(), MessageCompilerSettings.none().colorize().translatePlaceholders()) : asVar.getCompiled(translated);
            }
            HTMLMessageBuilderContextProvider fakeBuilder = new HTMLMessageBuilderContextProvider(this.parent);
            obj.build(fakeBuilder);
            return fakeBuilder.getCurrentElement().style();
        }
    }

    public static final class HTMLElement {
        public String text;
        public String color;
        public boolean italic;
        public boolean bold;
        public boolean underlined;
        public boolean strikethrough;
        public boolean obfuscated;
        public String hover;

        public boolean isEmpty() {
            return this.text == null || this.text.isEmpty();
        }

        String style() {
            StringJoiner styles = new StringJoiner(";");
            if (this.color != null) {
                styles.add("color: " + this.color);
            }
            if (this.italic) {
                styles.add("font-style: italic");
            }
            if (this.bold) {
                styles.add("font-weight: bold");
            }
            if (this.underlined) {
                styles.add("text-decoration: underline");
            }
            if (this.strikethrough) {
                styles.add("text-decoration-line: line-through");
            }
            return styles.toString();
        }

        public String toString() {
            if (this.text == null || this.text.isEmpty()) {
                return "";
            }
            if (this.hover == null) {
                return "<span class=\"kingdoms-element\" style=\"" + this.style() + "\">" + this.text + "</span>";
            }
            return "<div class=\"kingdoms-element kingdoms-tooltip\" style=\"" + this.style() + "\">" + this.text + "  <span class=\"kingdoms-element kingdoms-tooltip-text\">Tooltip text</span></div>";
        }
    }
}

