/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.locale.compiler.builders;

import java.util.ArrayList;
import java.util.function.Function;
import org.kingdoms.locale.LanguageEntry;
import org.kingdoms.locale.compiler.MessageCompiler;
import org.kingdoms.locale.compiler.MessageObject;
import org.kingdoms.locale.compiler.builders.MessageObjectBuilder;
import org.kingdoms.locale.compiler.builders.context.ComplexMessageBuilderContextProvider;
import org.kingdoms.locale.compiler.builders.context.HTMLMessageBuilderContextProvider;
import org.kingdoms.locale.compiler.builders.context.PlainMessageBuilderContextProvider;
import org.kingdoms.locale.compiler.pieces.MessagePiece;
import org.kingdoms.locale.messenger.DefinedMessenger;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.locale.provider.MessageProvider;

public class RawLanguageEntryObjectBuilder
implements MessageObjectBuilder {
    private final LanguageEntry messagePath;
    private final Function<String, String> processor;

    public RawLanguageEntryObjectBuilder(DefinedMessenger message, Function<String, String> processor) {
        this.messagePath = message.getLanguageEntry();
        this.processor = processor;
    }

    private String toPlain(MessagePlaceholderProvider _s) {
        MessageProvider message = _s.getLanguage().getMessage(this.messagePath, false);
        if (message == null) {
            return null;
        }
        MessageObject messageObjectBuilder = message.getMessage();
        String plain = messageObjectBuilder.buildPlain(_s);
        try {
            return this.processor.apply(plain);
        }
        catch (Throwable ex) {
            throw new RuntimeException("Error while running raw language entry processor for entry: " + message, ex);
        }
    }

    @Override
    public void build(ComplexMessageBuilderContextProvider contextProvider) {
        MessageCompiler.compile(this.toPlain(contextProvider.getSettings())).build(contextProvider);
    }

    @Override
    public void build(PlainMessageBuilderContextProvider _s) {
        _s.getCurrentLine().append(this.toPlain(_s.getSettings()));
    }

    @Override
    public void build(HTMLMessageBuilderContextProvider _s) {
        MessageProvider message = _s.getSettings().getLanguage().getMessage(this.messagePath, false);
        message.getMessage().build(_s);
        ArrayList<HTMLMessageBuilderContextProvider.HTMLElement> elements = new ArrayList<HTMLMessageBuilderContextProvider.HTMLElement>(_s.elements);
        elements.add(_s.getCurrentElement());
        elements.forEach(x -> {
            try {
                x.text = this.processor.apply(x.text);
            }
            catch (Throwable ex) {
                throw new RuntimeException("Error while running raw language entry processor for entry: " + message, ex);
            }
        });
    }

    @Override
    public boolean isAvailable(MessagePlaceholderProvider builder) {
        return builder.getLanguage().getMessage(this.messagePath, false) != null;
    }

    @Override
    public MessageObject evaluateDynamicPieces(MessagePlaceholderProvider _s) {
        return new MessageObject(new MessagePiece[]{new MessagePiece.Plain(this.toPlain(_s))}, false);
    }
}

