/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.locale.compiler.builders;

import java.util.ArrayList;
import java.util.List;
import org.kingdoms.data.Pair;
import org.kingdoms.locale.compiler.MessageCompiler;
import org.kingdoms.locale.compiler.MessageObject;
import org.kingdoms.locale.compiler.builders.MessageObjectBuilder;
import org.kingdoms.locale.compiler.builders.context.ComplexMessageBuilderContextProvider;
import org.kingdoms.locale.compiler.builders.context.HTMLMessageBuilderContextProvider;
import org.kingdoms.locale.compiler.builders.context.MessageBuilderContextProvider;
import org.kingdoms.locale.compiler.builders.context.PlainMessageBuilderContextProvider;
import org.kingdoms.locale.compiler.pieces.MessagePiece;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.utils.internal.arrays.UnsafeArrayList;

public class MessageObjectLinker
implements MessageObjectBuilder {
    private final List<Pair<MessagePiece[], MessagePlaceholderProvider>> pieces = new ArrayList<Pair<MessagePiece[], MessagePlaceholderProvider>>(10);
    private boolean used;

    public MessageObjectLinker add(MessageObject obj, MessagePlaceholderProvider settings) {
        this.pieces.add(Pair.of(obj.getPieces(), settings));
        return this;
    }

    public MessageObjectLinker add(Messenger lang, MessagePlaceholderProvider settings) {
        return this.add(lang.getMessageObject(settings.getLanguage()), settings);
    }

    public MessageObjectLinker add(String plain) {
        return this.add(MessageCompiler.compile(plain), null);
    }

    @Override
    public void build(ComplexMessageBuilderContextProvider contextProvider) {
        this.checkUsed();
        this.handleIndividual(contextProvider);
        contextProvider.appendRemaining();
    }

    private void checkUsed() {
        if (this.used) {
            throw new IllegalStateException("This message linker has already been used");
        }
        this.used = true;
    }

    void handleIndividual(MessageBuilderContextProvider contextProvider) {
        MessagePlaceholderProvider settings = contextProvider.getSettings();
        for (Pair<MessagePiece[], MessagePlaceholderProvider> piece : this.pieces) {
            if (piece.getValue() != null) {
                contextProvider.setSettings(piece.getValue().inheritPlaceholders(settings));
            } else {
                contextProvider.setSettings(settings);
            }
            for (MessagePiece subPiece : piece.getKey()) {
                if (contextProvider.getSettings().ignoreColors && subPiece instanceof MessagePiece.Color) continue;
                contextProvider.build(subPiece);
            }
        }
        contextProvider.setSettings(settings);
    }

    @Override
    public void build(PlainMessageBuilderContextProvider contextProvider) {
        this.checkUsed();
        this.handleIndividual(contextProvider);
    }

    @Override
    public void build(HTMLMessageBuilderContextProvider contextProvider) {
        this.checkUsed();
        this.handleIndividual(contextProvider);
    }

    @Override
    public boolean isAvailable(MessagePlaceholderProvider builder) {
        return !this.used;
    }

    @Override
    public MessageObject evaluateDynamicPieces(MessagePlaceholderProvider placeholderContextProvider) {
        UnsafeArrayList<MessagePiece> newPieces = UnsafeArrayList.withSize(new MessagePiece[this.pieces.size() * 10]);
        for (Pair<MessagePiece[], MessagePlaceholderProvider> piece : this.pieces) {
            MessageObject obj = new MessageObject(piece.getKey(), false);
            obj = obj.evaluateDynamicPieces(piece.getValue());
            newPieces.addAll((MessagePiece[])obj.getPieces());
        }
        return new MessageObject(newPieces.toArray(), false);
    }
}

