/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.locale.compiler.builders;

import org.kingdoms.locale.LanguageEntry;
import org.kingdoms.locale.compiler.MessageObject;
import org.kingdoms.locale.compiler.builders.ContextualMessageObject;
import org.kingdoms.locale.compiler.builders.MessageObjectBuilder;
import org.kingdoms.locale.compiler.builders.context.ComplexMessageBuilderContextProvider;
import org.kingdoms.locale.compiler.builders.context.HTMLMessageBuilderContextProvider;
import org.kingdoms.locale.compiler.builders.context.PlainMessageBuilderContextProvider;
import org.kingdoms.locale.messenger.DefinedMessenger;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.locale.provider.MessageProvider;

public class LanguageEntryWithContext
implements MessageObjectBuilder {
    private final LanguageEntry messagePath;
    private final MessagePlaceholderProvider settings;

    public LanguageEntryWithContext(DefinedMessenger message, MessagePlaceholderProvider settings) {
        this.messagePath = message.getLanguageEntry();
        this.settings = settings;
    }

    public LanguageEntryWithContext(String ... path) {
        this.messagePath = new LanguageEntry(path);
        this.settings = MessagePlaceholderProvider.DEFAULT;
    }

    public ContextualMessageObject toObject(MessagePlaceholderProvider _s) {
        MessageProvider message = _s.getLanguage().getMessage(this.messagePath, false);
        return message == null ? null : new ContextualMessageObject(message.getMessage(), this.settings);
    }

    @Override
    public void build(ComplexMessageBuilderContextProvider contextProvider) {
        ContextualMessageObject obj = this.toObject(contextProvider.getSettings());
        obj.build(contextProvider);
    }

    @Override
    public void build(PlainMessageBuilderContextProvider contextProvider) {
        ContextualMessageObject obj = this.toObject(contextProvider.getSettings());
        obj.build(contextProvider);
    }

    @Override
    public void build(HTMLMessageBuilderContextProvider contextProvider) {
        ContextualMessageObject obj = this.toObject(contextProvider.getSettings());
        obj.build(contextProvider);
    }

    @Override
    public boolean isAvailable(MessagePlaceholderProvider builder) {
        return this.toObject(builder) != null;
    }

    @Override
    public MessageObject evaluateDynamicPieces(MessagePlaceholderProvider _s) {
        ContextualMessageObject obj = this.toObject(_s);
        return obj == null ? null : obj.evaluateDynamicPieces(_s);
    }

    public String toString() {
        return this.getClass().getSimpleName() + '(' + this.messagePath + ", " + this.settings + ')';
    }
}

