/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.locale.compiler.builders;

import java.util.Arrays;
import org.kingdoms.locale.compiler.MessageObject;
import org.kingdoms.locale.compiler.builders.context.ComplexMessageBuilderContextProvider;
import org.kingdoms.locale.compiler.builders.context.HTMLMessageBuilderContextProvider;
import org.kingdoms.locale.compiler.builders.context.PlainMessageBuilderContextProvider;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;

public class CombinedMessageObject
extends MessageObject {
    private final MessageObject[] messages;

    public CombinedMessageObject(MessageObject[] messages) {
        super(MessageObject.mergeObjectToPieces(messages), false);
        this.messages = messages;
    }

    @Override
    public void build(ComplexMessageBuilderContextProvider contextProvider) {
        for (MessageObject message : this.messages) {
            message.build(contextProvider);
        }
        contextProvider.appendRemaining();
    }

    @Override
    public void build(PlainMessageBuilderContextProvider contextProvider) {
        for (MessageObject message : this.messages) {
            message.build(contextProvider);
        }
    }

    @Override
    public void build(HTMLMessageBuilderContextProvider contextProvider) {
        for (MessageObject message : this.messages) {
            message.build(contextProvider);
        }
    }

    @Override
    public MessageObject evaluateDynamicPieces(MessagePlaceholderProvider placeholderContextProvider) {
        MessageObject[] objects = new MessageObject[this.messages.length];
        for (int i = 0; i < this.messages.length; ++i) {
            objects[i] = this.messages[i].evaluateDynamicPieces(placeholderContextProvider);
        }
        return new CombinedMessageObject(objects);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + '(' + Arrays.toString(this.messages) + ')';
    }
}

