/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.locale.compiler;

import java.util.Objects;
import org.kingdoms.libs.jetbrains.annotations.Contract;
import org.kingdoms.locale.compiler.MessageCompilerSettings;
import org.kingdoms.locale.compiler.builders.MessageObjectBuilder;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.locale.placeholders.transformer.PlaceholderTransformerRegistry;

public final class PlaceholderTranslationContext {
    private final Object raw;
    private final MessageCompilerSettings settings;
    public static final MessageCompilerSettings PLACEHOLDER_SETTINGS = new MessageCompilerSettings(false, false, true, true, true, null);

    public PlaceholderTranslationContext(Object raw, MessageCompilerSettings settings) {
        this.raw = Objects.requireNonNull(raw, "Raw value cannot be null");
        this.settings = settings;
    }

    public static PlaceholderTranslationContext withDefaultContext(Object raw) {
        return new PlaceholderTranslationContext(raw, PLACEHOLDER_SETTINGS);
    }

    @Contract(value="_ -> new")
    public PlaceholderTranslationContext copyTo(Object newRaw) {
        return new PlaceholderTranslationContext(newRaw, this.settings);
    }

    public static boolean isRaw(Object value) {
        return value.getClass().isPrimitive() || value instanceof Messenger || value instanceof MessageObjectBuilder;
    }

    public MessageCompilerSettings getSettings() {
        return this.settings;
    }

    public String toString() {
        return "PlaceholderTranslationContext{" + this.raw.getClass().getSimpleName() + ": " + this.raw + '}';
    }

    public Object getValue() {
        return PlaceholderTranslationContext.unwrapPlaceholder(this.raw);
    }

    public static Object unwrapPlaceholder(Object translated) {
        return PlaceholderTransformerRegistry.INSTANCE.applyTransformation(translated);
    }

    public static Object unwrapContextualPlaceholder(Object translated, MessagePlaceholderProvider context) {
        if ((translated = PlaceholderTranslationContext.unwrapPlaceholder(translated)) instanceof Messenger) {
            translated = ((Messenger)translated).getMessageObject(context.getLanguage());
        }
        return translated;
    }
}

