/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.locale.compiler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringJoiner;
import java.util.function.Predicate;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.compiler.ColorAccessor;
import org.kingdoms.locale.compiler.PlaceholderTranslationContext;
import org.kingdoms.locale.compiler.builders.ContextualMessageObject;
import org.kingdoms.locale.compiler.builders.MessageObjectBuilder;
import org.kingdoms.locale.compiler.builders.context.ComplexMessageBuilderContextProvider;
import org.kingdoms.locale.compiler.builders.context.HTMLMessageBuilderContextProvider;
import org.kingdoms.locale.compiler.builders.context.PlainMessageBuilderContextProvider;
import org.kingdoms.locale.compiler.pieces.MessagePiece;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.locale.provider.AdvancedMessageProvider;
import org.kingdoms.locale.provider.MessageProvider;
import org.kingdoms.utils.internal.arrays.UnsafeArrayList;

public class MessageObject
implements MessageObjectBuilder {
    public static final MessageObject NULL = new MessageObject(MessagePiece.Null.getArrayInstance(), false);
    protected final MessagePiece[] pieces;
    private final Boolean usePrefix;

    public MessageObject(MessagePiece[] pieces, Boolean usePrefix) {
        this.pieces = pieces;
        this.usePrefix = usePrefix;
    }

    public static MessageObject from(Boolean usePrefix, MessagePiece ... pieces) {
        return new MessageObject(pieces, usePrefix);
    }

    public static MessageObject from(MessagePiece ... pieces) {
        return new MessageObject(pieces, false);
    }

    public MessagePiece validateAll(Predicate<MessagePiece> validator) {
        for (MessagePiece piece : this.pieces) {
            if (validator.test(piece)) continue;
            return piece;
        }
        return null;
    }

    public MessagePiece[] getPieces() {
        return this.pieces;
    }

    public Boolean getUsePrefix() {
        return this.usePrefix;
    }

    public boolean isNull() {
        return this.pieces.length == 1 && this.pieces[0] == MessagePiece.Null.INSTANCE;
    }

    public List<MessageObject> splitBy(boolean preservePiece, Predicate<MessagePiece> predicate) {
        ArrayList<MessageObject> pieces = new ArrayList<MessageObject>(1);
        ArrayList<MessagePiece> pieceBuilder = new ArrayList<MessagePiece>(this.pieces.length / 2);
        for (MessagePiece piece : this.pieces) {
            if (predicate.test(piece)) {
                if (preservePiece) {
                    pieceBuilder.add(piece);
                }
                MessageObject partialObj = new MessageObject(pieceBuilder.toArray(new MessagePiece[0]), this.usePrefix);
                pieces.add(partialObj);
                pieceBuilder.clear();
                continue;
            }
            pieceBuilder.add(piece);
        }
        if (pieceBuilder.isEmpty()) {
            pieceBuilder.add(MessagePiece.Plain.EMPTY);
        }
        MessageObject partialObj = new MessageObject(pieceBuilder.toArray(new MessagePiece[0]), this.usePrefix);
        pieces.add(partialObj);
        return pieces;
    }

    public boolean hasPiece(Predicate<MessagePiece> filter) {
        return Arrays.stream(this.pieces).anyMatch(filter);
    }

    public int count(Predicate<MessagePiece> filter) {
        return (int)Arrays.stream(this.pieces).filter(filter).count();
    }

    public static MessageObject combine(MessageObject ... objects) {
        if (objects.length == 0) {
            return null;
        }
        if (objects.length == 1) {
            return objects[0];
        }
        MessageObject first = objects[0];
        MessageObject[] others = (MessageObject[])Arrays.stream(objects).skip(1L).toArray(MessageObject[]::new);
        return first.merge(others);
    }

    public ContextualMessageObject withContext(MessagePlaceholderProvider context) {
        return new ContextualMessageObject(this, context);
    }

    public static MessagePiece[] mergeObjectToPieces(MessageObject ... objects) {
        int length = Arrays.stream(objects).mapToInt(x -> x.getPieces().length).sum();
        MessagePiece[] newPieces = new MessagePiece[length];
        int currentPos = 0;
        for (MessageObject other : objects) {
            MessagePiece[] pieces = other.pieces;
            System.arraycopy(pieces, 0, newPieces, currentPos, pieces.length);
            currentPos += pieces.length;
        }
        return newPieces;
    }

    public MessageObject merge(MessageObject ... others) {
        int length = this.pieces.length + Arrays.stream(others).mapToInt(x -> x.pieces.length).sum();
        MessagePiece[] pieces = new MessagePiece[length];
        int currentPos = 0;
        System.arraycopy(this.pieces, 0, pieces, currentPos, this.pieces.length);
        currentPos += this.pieces.length;
        for (MessageObject other : others) {
            System.arraycopy(other.pieces, 0, pieces, currentPos, other.pieces.length);
            currentPos += other.pieces.length;
        }
        return new MessageObject(pieces, false);
    }

    public MessageObject merge(boolean after, MessagePiece ... others) {
        int length = this.pieces.length + others.length;
        MessagePiece[] pieces = new MessagePiece[length];
        if (after) {
            System.arraycopy(this.pieces, 0, pieces, 0, this.pieces.length);
            System.arraycopy(others, 0, pieces, this.pieces.length, others.length);
        } else {
            System.arraycopy(others, 0, pieces, 0, others.length);
            System.arraycopy(this.pieces, 0, pieces, this.pieces.length, this.pieces.length);
        }
        return new MessageObject(pieces, false);
    }

    public MessageObject filter(Predicate<MessagePiece> filter) {
        MessagePiece[] newPieces = (MessagePiece[])Arrays.stream(this.pieces).filter(filter).toArray(MessagePiece[]::new);
        return new MessageObject(newPieces, this.usePrefix);
    }

    public MessageObject findLastColors() {
        List<MessagePiece> colors = this.findColorPieces(1, true);
        if (colors.isEmpty()) {
            return null;
        }
        return new MessageObject(colors.toArray(new MessagePiece[0]), false);
    }

    public List<MessageObject> splitLines() {
        List<MessageObject> lines = this.splitBy(false, x -> x instanceof MessagePiece.NewLine);
        ArrayList<MessageObject> evaluatedLines = new ArrayList<MessageObject>(lines.size());
        MessageObject lastColor = null;
        for (MessageObject line : lines) {
            MessageObject currentLineLastColor = line.findLastColors();
            if (lastColor != null) {
                line = lastColor.merge(line);
            }
            lastColor = currentLineLastColor;
            evaluatedLines.add(line);
        }
        return evaluatedLines;
    }

    public List<MessagePiece> findColorPieces(int colorIndex, boolean backwards) {
        return ColorAccessor.of(this.pieces, colorIndex, backwards);
    }

    @Override
    public void build(ComplexMessageBuilderContextProvider contextProvider) {
        MessagePlaceholderProvider settings = contextProvider.getSettings();
        if (this.shouldUsePrefix(settings)) {
            for (MessagePiece piece : MessageObject.getPrefix((MessagePlaceholderProvider)settings).pieces) {
                contextProvider.build(piece);
            }
        }
        for (MessagePiece piece : this.pieces) {
            if (settings.ignoreColors && piece instanceof MessagePiece.Color) continue;
            contextProvider.build(piece);
        }
    }

    private static MessageObject getPrefix(MessagePlaceholderProvider settings) {
        return KingdomsLang.PREFIX.getMessageObject(settings.getLanguage());
    }

    private boolean shouldUsePrefix(MessagePlaceholderProvider settings) {
        if (this.usePrefix != null) {
            return this.usePrefix;
        }
        if (settings.usePrefix != null) {
            return settings.usePrefix;
        }
        return false;
    }

    @Override
    public void build(PlainMessageBuilderContextProvider contextProvider) {
        if (this.shouldUsePrefix(contextProvider.getSettings())) {
            for (MessagePiece piece : MessageObject.getPrefix((MessagePlaceholderProvider)contextProvider.getSettings()).pieces) {
                piece.build(contextProvider);
            }
        }
        for (MessagePiece piece : this.pieces) {
            if (contextProvider.getSettings().ignoreColors && piece instanceof MessagePiece.Color) continue;
            piece.build(contextProvider);
        }
    }

    @Override
    public void build(HTMLMessageBuilderContextProvider contextProvider) {
        if (this.shouldUsePrefix(contextProvider.getSettings())) {
            for (MessagePiece piece : MessageObject.getPrefix((MessagePlaceholderProvider)contextProvider.getSettings()).pieces) {
                piece.build(contextProvider);
            }
        }
        for (MessagePiece piece : this.pieces) {
            if (contextProvider.getSettings().ignoreColors && piece instanceof MessagePiece.Color) continue;
            piece.build(contextProvider);
        }
    }

    @Override
    public boolean isAvailable(MessagePlaceholderProvider builder) {
        return true;
    }

    @Override
    public MessageObject evaluateDynamicPieces(MessagePlaceholderProvider placeholderContextProvider) {
        UnsafeArrayList<MessagePiece> newPieces = UnsafeArrayList.withSize(new MessagePiece[this.pieces.length]);
        for (MessagePiece piece : this.pieces) {
            if (piece instanceof MessagePiece.Variable) {
                MessagePiece.Variable variable = (MessagePiece.Variable)piece;
                Object translated = variable.getPlaceholder(placeholderContextProvider);
                if (translated == null) {
                    MessageObject.mergeOrAdd(newPieces, variable.getPlaceholder().asString(true));
                    continue;
                }
                if (translated instanceof MessageObjectBuilder) {
                    MessageObjectBuilder obj = (MessageObjectBuilder)translated;
                    newPieces.addAll((MessagePiece[])obj.evaluateDynamicPieces(placeholderContextProvider).getPieces());
                    continue;
                }
                if (!(translated instanceof PlaceholderTranslationContext)) {
                    MessageObject.mergeOrAdd(newPieces, translated.toString());
                    continue;
                }
                MessageObject varObj = variable.getCompiled(translated);
                newPieces.addAll((MessagePiece[])varObj.pieces);
                continue;
            }
            if (piece instanceof MessagePiece.ColorAccessor) {
                newPieces.addAll(((MessagePiece.ColorAccessor)piece).getLastColors(placeholderContextProvider));
                continue;
            }
            if (piece instanceof MessagePiece.Conditional) {
                MessagePiece[] chosenPieces = ((MessagePiece.Conditional)piece).getPiece(placeholderContextProvider);
                newPieces.addAll((MessagePiece[])chosenPieces);
                continue;
            }
            newPieces.add(piece);
        }
        return new MessageObject(newPieces.toArray(), this.usePrefix);
    }

    private static void mergeOrAdd(UnsafeArrayList<MessagePiece> newPieces, String plain) {
        MessagePiece last;
        if (!newPieces.isEmpty() && (last = newPieces.getLast()) instanceof MessagePiece.Plain) {
            newPieces.replaceLast(new MessagePiece.Plain(((MessagePiece.Plain)last).getMessage() + plain));
            return;
        }
        newPieces.add(new MessagePiece.Plain(plain));
    }

    public MessageProvider getSimpleProvider() {
        return new MessageProvider(this);
    }

    public AdvancedMessageProvider getExtraProvider() {
        return new AdvancedMessageProvider(this, null, null);
    }

    public String toString() {
        if (this.pieces.length == 0) {
            return "MessageObject{}";
        }
        StringJoiner joiner = new StringJoiner(" | ");
        for (MessagePiece piece : this.pieces) {
            joiner.add(piece.toString());
        }
        return "MessageObject{" + joiner + '}';
    }
}

