/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.locale.compiler;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.chat.hover.content.Text;
import org.bukkit.ChatColor;
import org.kingdoms.data.Pair;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.xseries.reflection.XReflection;
import org.kingdoms.locale.Language;
import org.kingdoms.locale.MessageHandler;
import org.kingdoms.locale.compiler.ConditionalMessageLexer;
import org.kingdoms.locale.compiler.MessageCompilerException;
import org.kingdoms.locale.compiler.MessageCompilerSettings;
import org.kingdoms.locale.compiler.MessageObject;
import org.kingdoms.locale.compiler.MessageTokenHandler;
import org.kingdoms.locale.compiler.MessageTokenResult;
import org.kingdoms.locale.compiler.pieces.MessagePiece;
import org.kingdoms.locale.compiler.placeholders.Placeholder;
import org.kingdoms.locale.compiler.placeholders.PlaceholderParser;
import org.kingdoms.locale.compiler.placeholders.TokenCursor;
import org.kingdoms.locale.compiler.placeholders.types.LanguagePathPlaceholder;
import org.kingdoms.locale.compiler.placeholders.types.MacroPlaceholder;
import org.kingdoms.locale.messenger.LanguageEntryMessenger;
import org.kingdoms.locale.placeholders.StandardKingdomsPlaceholder;
import org.kingdoms.utils.compilers.ConditionalCompiler;
import org.kingdoms.utils.compilers.expressions.ConditionalExpression;
import org.kingdoms.utils.internal.numbers.Numbers;
import org.kingdoms.utils.string.Strings;

public final class MessageCompiler {
    public static final MessageCompilerSettings DEFAULT_COMPILER_SETTINGS = MessageCompiler.defaultSettingsWithErroHandler(null);
    public static final boolean CONTENT = XReflection.supports((int)16);
    private final List<MessagePiece> pieces = new ArrayList<MessagePiece>(10);
    private static final String NOPREFIX = "NOPREFIX|";
    private static final String PREFIX = "PREFIX|";
    private final StringBuilder plain;
    private final char[] str;
    private final int len;
    private int i;
    private char ch;
    private final Boolean usePrefix;
    private final MessageCompilerSettings settings;
    private final List<MessageCompilerException> exceptions = new ArrayList<MessageCompilerException>();
    private boolean used = false;
    private static final String HOVER = "hover:{";
    private static final char SEPARATOR = ';';
    private static final char COMMAND = '/';
    private static final char COMMAND_SUGGESTION = '|';
    private static final char URL = '@';
    private static final char INSERTION = '+';
    private static final char CLOSING_HOVER_CHAR = '}';
    int lastBackRefSepIndex = -1;

    public char[] getChars() {
        return this.str;
    }

    public String getRemainingString() {
        return new String(this.str, this.i, this.str.length - this.i);
    }

    public static MessageCompilerSettings defaultSettingsWithErroHandler(Consumer<MessageCompiler> errorHandler) {
        return new MessageCompilerSettings(true, false, true, true, true, null).withErrorHandler(errorHandler);
    }

    public List<MessageCompilerException> getExceptions() {
        return this.exceptions;
    }

    public boolean hasErrors() {
        return !this.exceptions.isEmpty();
    }

    public String joinExceptions() {
        StringBuilder builder = new StringBuilder(this.exceptions.size() * this.len * 2);
        int i = this.exceptions.size();
        for (MessageCompilerException ex : this.exceptions) {
            builder.append(ex.getMessage());
            if (--i == 0) continue;
            builder.append('\n');
        }
        return builder.toString();
    }

    public int getIndex() {
        return this.i;
    }

    public char getChar() {
        return this.ch;
    }

    public MessageCompiler(String str) {
        this(str, DEFAULT_COMPILER_SETTINGS);
    }

    public MessageCompiler(String str, MessageCompilerSettings settings) {
        this(str.toCharArray(), settings);
    }

    public MessageCompiler(char[] str, MessageCompilerSettings settings) {
        this.settings = Objects.requireNonNull(settings);
        this.str = str;
        this.len = str.length;
        this.plain = new StringBuilder(this.len);
        this.usePrefix = this.shouldUsePrefix();
    }

    private boolean isLast() {
        if (this.i == this.len - 1) {
            this.plain.append(this.ch);
            return true;
        }
        return false;
    }

    public List<MessagePiece> getPieces() {
        return this.pieces;
    }

    private void validateColors() {
        MessagePiece.SimpleColor simple;
        if (!this.settings.validate) {
            return;
        }
        if (this.pieces.size() < 2) {
            return;
        }
        MessagePiece first = this.pieces.get(this.pieces.size() - 1);
        MessagePiece second = this.pieces.get(this.pieces.size() - 2);
        if (!(first instanceof MessagePiece.Color) || !(second instanceof MessagePiece.Color)) {
            return;
        }
        if (first.equals(second)) {
            this.exception(this.i - 2, "Repeated color code", "||||");
            return;
        }
        boolean isFirstColor = first instanceof MessagePiece.HexColor;
        boolean isSecondColor = second instanceof MessagePiece.HexColor;
        if (!isFirstColor) {
            simple = (MessagePiece.SimpleColor)first;
            isFirstColor = simple.getColor().isColor();
        }
        if (!isSecondColor) {
            simple = (MessagePiece.SimpleColor)second;
            isSecondColor = simple.getColor().isColor();
        }
        if (isFirstColor && isSecondColor) {
            this.exception(this.i - 2, "Two non-formatting colors cannot follow each other as it's overridden by the later.", "||||");
            return;
        }
        if (!isSecondColor && isFirstColor) {
            this.exception(this.i - 2, "A formatting color cannot follow a non-formatting color as it's overridden by the later. Consider putting the formatting color after the non-formatting one.", "||||");
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(200).append("MessageCompiler(");
        for (MessagePiece piece : this.pieces) {
            builder.append(" | ");
            builder.append(piece.toString());
        }
        return builder.append(')').toString();
    }

    void savePlainStateAndReset() {
        if (this.plain.length() == 0) {
            return;
        }
        this.pieces.add(new MessagePiece.Plain(this.plain.toString()));
        this.plain.setLength(0);
    }

    public static MessageObject compile(String str) {
        return MessageCompiler.compile(str, true, false);
    }

    public static MessageObject compile(String str, boolean validate, boolean plainOnly) {
        return MessageCompiler.compile(str, validate, plainOnly, null);
    }

    public static MessageObject compile(String str, boolean validate, boolean plainOnly, MessageTokenHandler tokenHandler) {
        MessageTokenHandler[] messageTokenHandlerArray;
        if (tokenHandler == null) {
            messageTokenHandlerArray = null;
        } else {
            MessageTokenHandler[] messageTokenHandlerArray2 = new MessageTokenHandler[1];
            messageTokenHandlerArray = messageTokenHandlerArray2;
            messageTokenHandlerArray2[0] = tokenHandler;
        }
        MessageTokenHandler[] handlers = messageTokenHandlerArray;
        return MessageCompiler.compile(str, new MessageCompilerSettings(validate, plainOnly, true, true, true, handlers));
    }

    public static MessageObject compile(String str, MessageCompilerSettings compilerSettings) {
        Objects.requireNonNull(str, "Cannot compile a null message");
        Objects.requireNonNull(compilerSettings, "Cannot compile with null compiler settings");
        MessageCompiler compiler = new MessageCompiler(str.toCharArray(), compilerSettings);
        MessageObject obj = compiler.compileObject();
        if (compiler.hasErrors()) {
            if (compilerSettings.errorHandler != null) {
                compilerSettings.errorHandler.accept(compiler);
            } else {
                throw new MessageCompilerException("{UNCAUGHT}", "[UNCAUGHT]", 0, compiler.joinExceptions());
            }
        }
        return obj;
    }

    public void compile() {
        if (this.used) {
            return;
        }
        this.used = true;
        block8: while (this.i < this.len) {
            this.ch = this.str[this.i];
            if (this.settings.tokenHandlers != null) {
                for (MessageTokenHandler tokenHandler : this.settings.tokenHandlers) {
                    MessageTokenResult end = tokenHandler.consumeUntil(this);
                    if (end == null) continue;
                    if (end.index <= this.i) {
                        throw new IllegalStateException("Less or no characters consumed for token: " + this.i + " -> " + end.index + " using token handler " + tokenHandler);
                    }
                    this.savePlainStateAndReset();
                    this.pieces.add(end.piece);
                    this.i = end.index;
                    break;
                }
            } else {
                block1 : switch (this.ch) {
                    case '\n': {
                        if (!this.settings.allowNewLines) {
                            this.plain.append('\n');
                            break;
                        }
                        this.savePlainStateAndReset();
                        this.pieces.add(MessagePiece.NewLine.INSTANCE);
                        break;
                    }
                    case '%': {
                        if (!this.settings.translatePlaceholders) {
                            this.plain.append('%');
                            break;
                        }
                        if (this.isLast()) break block8;
                        PlaceholderParser placeholderBuilder = PlaceholderParser.parse(this.i + 1, this.str, true);
                        if (placeholderBuilder != null) {
                            int end = placeholderBuilder.getEndIndex();
                            try {
                                Placeholder ph = placeholderBuilder.getPlaceholder();
                                this.savePlainStateAndReset();
                                this.pieces.add(new MessagePiece.Variable(ph));
                                this.i = end;
                            }
                            catch (Throwable ex) {
                                if (this.settings.validate) {
                                    this.exception(this.i, ex.getMessage(), new String(this.str, this.i, end - this.i));
                                }
                                this.plain.append(this.str, this.i, end - this.i + 1);
                            }
                            break;
                        }
                        this.plain.append('%');
                        break;
                    }
                    case '&': 
                    case '\u00a7': {
                        if (!this.settings.colorize) {
                            this.plain.append('&');
                            break;
                        }
                        if (this.isLast()) break block8;
                        char next = this.str[this.i + 1];
                        if (MessageHandler.isColorCode(next)) {
                            this.savePlainStateAndReset();
                            ChatColor bukkitColor = Objects.requireNonNull(ChatColor.getByChar((char)((char)(next | 0x20))));
                            this.pieces.add(new MessagePiece.SimpleColor(bukkitColor));
                            this.validateColors();
                            ++this.i;
                            break;
                        }
                        if (this.ch == '&' && next == '#') {
                            if (this.i + 1 < this.len - 6) {
                                StringBuilder hexBuilder = new StringBuilder(6);
                                ++this.i;
                                while (hexBuilder.length() != 6) {
                                    if (MessageHandler.isColorCode(next = this.str[++this.i])) {
                                        hexBuilder.append(next);
                                        continue;
                                    }
                                    this.exception(this.i, "Invalid hex color character '" + next + "' or possibly unfinished hex color");
                                    break block1;
                                }
                                this.savePlainStateAndReset();
                                Color color = new Color(Integer.parseInt(hexBuilder.toString(), 16));
                                this.pieces.add(new MessagePiece.HexColor(color));
                                this.validateColors();
                                break;
                            }
                            this.exception(this.i, "Unfinished hex color", new String(this.str, this.i, this.len - this.i));
                            break block8;
                        }
                        if (this.ch == '\u00a7' && next == 'x') {
                            if (this.i + 1 >= this.len - 12) break block8;
                            StringBuilder hexBuilder = new StringBuilder(6);
                            ++this.i;
                            boolean skipCode = true;
                            while (hexBuilder.length() != 6) {
                                next = this.str[++this.i];
                                if (skipCode) {
                                    skipCode = false;
                                    if (next == '\u00a7') continue;
                                    break block1;
                                }
                                skipCode = true;
                                if (!MessageHandler.isColorCode(next)) break block1;
                                hexBuilder.append(next);
                            }
                            this.savePlainStateAndReset();
                            Color color = new Color(Integer.parseInt(hexBuilder.toString(), 16));
                            this.pieces.add(new MessagePiece.HexColor(color));
                            this.validateColors();
                            break;
                        }
                        this.plain.append('&');
                        break;
                    }
                    case '{': {
                        if (this.isLast()) break block8;
                        MessagePiece piece = this.handleSpecial();
                        if (piece != null) {
                            this.pieces.add(piece);
                            break;
                        }
                        this.plain.append('{');
                        break;
                    }
                    default: {
                        if (!this.settings.plainOnly && this.ch == HOVER.charAt(0)) {
                            if (this.i + HOVER.length() <= this.len) {
                                for (int hoverIndex = 1; hoverIndex < HOVER.length(); ++hoverIndex) {
                                    this.ch = this.str[++this.i];
                                    if (this.ch == HOVER.charAt(hoverIndex)) continue;
                                    this.plain.append(HOVER, 0, hoverIndex);
                                    --this.i;
                                    break block1;
                                }
                                ++this.i;
                                MessagePiece.Hover hoverPiece = this.buildHover();
                                if (hoverPiece == null) break;
                                this.savePlainStateAndReset();
                                this.pieces.add(hoverPiece);
                                break;
                            }
                        }
                        this.plain.append(this.ch);
                    }
                }
            }
            ++this.i;
        }
        this.savePlainStateAndReset();
    }

    public MessagePiece[] compileToArray() {
        this.compile();
        return this.pieces.toArray(new MessagePiece[0]);
    }

    public MessageObject compileObject() {
        return new MessageObject(this.compileToArray(), this.usePrefix);
    }

    private Boolean shouldUsePrefix() {
        if (this.startsWith(NOPREFIX)) {
            this.i = NOPREFIX.length();
            return false;
        }
        if (this.startsWith(PREFIX)) {
            this.i = PREFIX.length();
            return true;
        }
        return null;
    }

    public static HoverEvent constructHoverEvent(BaseComponent[] baseComponents) {
        if (CONTENT) {
            Text text = new Text(baseComponents);
            return new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{text});
        }
        return new HoverEvent(HoverEvent.Action.SHOW_TEXT, baseComponents);
    }

    private boolean startsWith(String str) {
        if (this.len < str.length()) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (this.str[i] == str.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private MessagePiece.Hover buildHover() {
        HoverParserState state = HoverParserState.NORMAL_MESSAGE;
        StringBuilder normalMessage = new StringBuilder();
        StringBuilder hoverMessage = new StringBuilder();
        StringBuilder action = new StringBuilder();
        MessagePiece.Hover.ClickAction clickActionType = null;
        int hoverMessageStartIndex = 0;
        int actionStartIndex = 0;
        int enclosingLevel = 0;
        block24: for (int j = this.i; j < this.len; ++j) {
            char ch = this.str[j];
            switch (ch) {
                case '}': {
                    if (enclosingLevel != 0) {
                        --enclosingLevel;
                        switch (state.ordinal()) {
                            case 2: {
                                action.append('}');
                                break;
                            }
                            case 0: {
                                normalMessage.append('}');
                                break;
                            }
                            case 1: {
                                hoverMessage.append('}');
                            }
                        }
                        continue block24;
                    }
                    if (state == HoverParserState.NORMAL_MESSAGE && hoverMessage.length() == 0) {
                        this.exception(j, "Hover message is empty");
                        return null;
                    }
                    if (state == HoverParserState.ACTION && clickActionType == null) {
                        this.exception(j, "Hover message action is empty");
                        return null;
                    }
                    MessageCompiler normalObj = new MessageCompiler(MessageCompiler.builderToChars(normalMessage), this.settings);
                    MessageCompiler hoverObj = new MessageCompiler(MessageCompiler.builderToChars(hoverMessage), this.settings);
                    MessageCompiler actionObj = new MessageCompiler(MessageCompiler.builderToChars(action), this.settings);
                    MessagePiece.Hover piece = new MessagePiece.Hover(clickActionType, normalObj.compileToArray(), hoverObj.compileToArray(), actionObj.compileToArray());
                    this.mergeExceptions(this.i, normalObj);
                    this.mergeExceptions(hoverMessageStartIndex, hoverObj);
                    this.mergeExceptions(actionStartIndex, actionObj);
                    this.i = j;
                    return piece;
                }
                case ';': {
                    enclosingLevel = 0;
                    switch (state.ordinal()) {
                        case 2: {
                            this.exception(j, "An extra separator found. Hover messages only take two separators");
                            return null;
                        }
                        case 1: {
                            actionStartIndex = j;
                            state = HoverParserState.ACTION;
                            break;
                        }
                        case 0: {
                            hoverMessageStartIndex = j;
                            if (normalMessage.length() == 0) {
                                this.exception(j, "Normal message is empty");
                                return null;
                            }
                            state = HoverParserState.HOVER_MESSAGE;
                        }
                    }
                    continue block24;
                }
                default: {
                    if (ch == '{') {
                        ++enclosingLevel;
                    }
                    switch (state.ordinal()) {
                        case 2: {
                            if (clickActionType == null) {
                                switch (ch) {
                                    case '|': {
                                        clickActionType = MessagePiece.Hover.ClickAction.SUGGEST_COMMAND;
                                        continue block24;
                                    }
                                    case '@': {
                                        clickActionType = MessagePiece.Hover.ClickAction.OPEN_URL;
                                        continue block24;
                                    }
                                    case '+': {
                                        clickActionType = MessagePiece.Hover.ClickAction.INSERTION;
                                        continue block24;
                                    }
                                }
                                clickActionType = MessagePiece.Hover.ClickAction.RUN_COMMAND;
                                action.append(ch);
                                continue block24;
                            }
                            action.append(ch);
                            continue block24;
                        }
                        case 0: {
                            normalMessage.append(ch);
                            continue block24;
                        }
                        case 1: {
                            hoverMessage.append(ch);
                        }
                    }
                }
            }
        }
        String extra = enclosingLevel == 0 ? "" : ". There are also " + enclosingLevel + " remaining curly bracket(s) that need to closed.";
        this.exception(this.i, "Unclosed hover message" + extra, HOVER);
        return null;
    }

    private String findEndOfSpecial(SpecialType type) {
        this.savePlainStateAndReset();
        StringBuilder builder = new StringBuilder(10);
        int i = this.i;
        ++i;
        while (i + 1 < this.len) {
            char next;
            if ((next = this.str[++i]) == '}') {
                this.i = i;
                if (builder.length() == 0) {
                    this.exception(i, "Empty " + type.name);
                    return null;
                }
                return builder.toString();
            }
            if (type == SpecialType.ANY) {
                builder.append(next);
                continue;
            }
            if (type == SpecialType.BACKREF && this.lastBackRefSepIndex != -1) {
                if (!(next == '-' || next >= '0' && next <= '9' || next == ' ' && builder.length() == 0)) {
                    this.exception(i, "Invalid character '" + next + "' in " + SpecialType.BACKREF.name + " color specifier expected a number");
                    return null;
                }
                builder.append(next);
                continue;
            }
            if (next == '&') {
                if (type != SpecialType.BACKREF) {
                    this.exception(i, "Invalid character '&' in " + type.name + " specifier");
                    return null;
                }
                this.lastBackRefSepIndex = i;
                continue;
            }
            if (!(type == SpecialType.HEX && next >= '0' && next <= '9' || next >= 'a' && next <= 'z' || next >= 'A' && next <= 'Z' || type == SpecialType.MACRO && (next == '-' || next == '_') || type == SpecialType.LANGUAGE_PATH && (next == '-' || next == '_' || next == '.' || next >= '0' && next <= '9') || type == SpecialType.BACKREF && next == ' ')) {
                if (next == ' ') {
                    this.exception(i, "Spaces aren't allowed in " + type.name + " (Did you forget to close the braces with '}'?)");
                } else {
                    this.exception(i, "Invalid character '" + next + "' in " + type.name);
                }
                return null;
            }
            builder.append(next);
        }
        this.exception(this.i, "Cannot find end of " + type.name, "{" + this.str[this.i]);
        return null;
    }

    private MessagePiece handleSpecial() {
        int start = this.i + 2;
        switch (this.str[this.i + 1]) {
            case '?': {
                ConditionalMessageLexer lexer = new ConditionalMessageLexer(start, this.len, this.str);
                try {
                    lexer.lex();
                }
                catch (Exception ex) {
                    this.exception(lexer.getIndex(), ex.getMessage());
                }
                List<ConditionalMessageLexer.Token> tokens = lexer.getTokens();
                ArrayList<Pair<ConditionalExpression, MessagePiece[]>> statements = new ArrayList<Pair<ConditionalExpression, MessagePiece[]>>();
                TokenCursor cursor = new TokenCursor((List<? extends ConditionalMessageLexer.Token>)tokens);
                boolean hadTernary = false;
                while (cursor.hasNext()) {
                    String str = cursor.expectString();
                    if (str == null) {
                        cursor.previous();
                        break;
                    }
                    char cond = cursor.expectChar("Expected conditional message ? conditional separator");
                    if (cond != '?') {
                        this.exception(start, "Expected conditional message ? condition separator");
                    }
                    String msg = cursor.expectString("Expected conditional message string");
                    statements.add(Pair.of(ConditionalCompiler.compile(str).evaluate(), this.subCompile(msg)));
                    Character chr = cursor.expectChar();
                    if (chr == null || chr.charValue() == ';') continue;
                    if (chr.charValue() == ':') {
                        hadTernary = true;
                        break;
                    }
                    this.exception(start, "Unknown character in conditional message: " + chr);
                }
                if (hadTernary) {
                    String otherwise = cursor.expectString("Expected otherwise message for conditional message");
                    statements.add(Pair.of(ConditionalCompiler.ConstantLogicalOperand.TRUE, this.subCompile(otherwise)));
                }
                this.savePlainStateAndReset();
                this.i = lexer.getIndex();
                return new MessagePiece.Conditional(statements);
            }
            case '/': {
                int i = this.i;
                ++i;
                while (i + 1 < this.len) {
                    char next;
                    if ((next = this.str[++i]) != ' ') continue;
                    --i;
                    break;
                }
                this.i = i;
                String extra = new String(this.str, start, this.i - start + 1);
                String rest = this.findEndOfSpecial(SpecialType.ANY);
                switch (extra) {
                    case "font": {
                        return new MessagePiece.Font(rest);
                    }
                    case "translate": {
                        String fallback;
                        int fallbackIndex = rest.indexOf("?:");
                        if (fallbackIndex == -1) {
                            fallback = null;
                        } else {
                            fallback = rest.substring(fallbackIndex + 2).trim();
                            rest = rest.substring(0, fallbackIndex).trim();
                        }
                        return new MessagePiece.Translate(rest, fallback);
                    }
                    case "keybind": {
                        return new MessagePiece.KeyBind(rest);
                    }
                }
                this.exception(i, "Unknown extra special message piece: " + extra, extra);
                break;
            }
            case '#': {
                if (!this.settings.colorize) {
                    return null;
                }
                String hex = this.findEndOfSpecial(SpecialType.HEX);
                if (hex == null) {
                    return null;
                }
                if (hex.length() != 3 && hex.length() != 6) {
                    this.exception(start, "Invalid hex color length. 3 digit and 6 digit formats are supported", hex);
                    return null;
                }
                try {
                    Color color = new Color(Integer.parseInt(hex, 16));
                    return new MessagePiece.HexColor(color);
                }
                catch (NumberFormatException ex) {
                    this.exception(start, "Invalid hex color", hex);
                    return null;
                }
            }
            case '$': {
                String name;
                if (!this.settings.translatePlaceholders) {
                    return null;
                }
                boolean isLangPath = false;
                if (this.str[start] == '$') {
                    isLangPath = true;
                    ++this.i;
                }
                if ((name = this.findEndOfSpecial(isLangPath ? SpecialType.LANGUAGE_PATH : SpecialType.MACRO)) == null) {
                    return null;
                }
                String original = this.substring(start - 2, this.i + 1);
                if (isLangPath) {
                    return new MessagePiece.Variable(new LanguagePathPlaceholder(original, LanguageEntryMessenger.of(name), null, new ArrayList()));
                }
                Object variable = StandardKingdomsPlaceholder.getRawMacro(name);
                if (variable == null) {
                    variable = Language.getDefault().getVariableRaw(name);
                }
                if (variable == null) {
                    String similar = Strings.findSimilar(name, StandardKingdomsPlaceholder.getGlobalMacros().keySet());
                    similar = similar == null ? "" : " Did you mean '" + similar + "'?";
                    this.exception(start, "Unknown macro '" + name + '\'' + similar, name);
                    return null;
                }
                return new MessagePiece.Variable(new MacroPlaceholder(original, name, null, new ArrayList()));
            }
            case '%': {
                if (!this.settings.colorize) {
                    return null;
                }
                PlaceholderParser placeholderBuilder = PlaceholderParser.parse(this.i + 2, this.str, true);
                Placeholder placeholder = null;
                boolean successful = placeholderBuilder != null;
                Throwable exeption = null;
                if (successful) {
                    try {
                        placeholder = placeholderBuilder.getPlaceholder();
                    }
                    catch (Throwable ex) {
                        exeption = ex;
                        successful = false;
                    }
                }
                if (!successful) {
                    this.exception(start, "Could not parse placeholder for color accessor " + (exeption == null ? "" : exeption.getMessage()));
                    return null;
                }
                MessagePiece.Variable var = new MessagePiece.Variable(placeholder);
                this.i = placeholderBuilder.getEndIndex();
                String indexStr = this.findEndOfSpecial(SpecialType.BACKREF);
                if (indexStr == null) {
                    return null;
                }
                indexStr = indexStr.trim();
                int index = -1;
                if (!indexStr.isEmpty()) {
                    try {
                        index = Integer.parseInt(indexStr);
                    }
                    catch (NumberFormatException ex) {
                        this.exception(this.lastBackRefSepIndex + 1, "Invalid color accessor index '" + indexStr.trim() + '\'', indexStr);
                        return null;
                    }
                }
                if (index == 0) {
                    this.exception(this.lastBackRefSepIndex + 1, "Color accessor cannot have an index of 0", indexStr);
                    return null;
                }
                return new MessagePiece.ColorAccessor(index, var);
            }
        }
        return null;
    }

    private MessagePiece @NotNull [] subCompile(String msg) {
        MessageCompiler subCompile = new MessageCompiler(msg);
        MessagePiece[] pieces = subCompile.compileToArray();
        if (subCompile.hasErrors()) {
            this.exceptions.addAll(subCompile.exceptions);
        }
        return pieces;
    }

    private String substring(int start, int end) {
        if (start < 0) {
            throw new IndexOutOfBoundsException("String start index is not positive: " + start + " (" + new String(this.str) + ')');
        }
        if (end > this.str.length) {
            throw new IndexOutOfBoundsException("String end index is greater than the actual size: " + end + " >= " + this.str.length + " (" + new String(this.str) + ')');
        }
        if (end <= start) {
            throw new IndexOutOfBoundsException("String end index is less than the start index: " + end + " <= " + start + " (" + new String(this.str) + ')');
        }
        return new String(this.str, start, end - start);
    }

    private static char[] builderToChars(StringBuilder builder) {
        char[] chars = new char[builder.length()];
        builder.getChars(0, builder.length(), chars, 0);
        return chars;
    }

    private void exception(int ofs, String problem) {
        this.exception(ofs, problem, null);
    }

    private void exception(int ofs, String problem, String target) {
        int i;
        if (!this.settings.validate) {
            return;
        }
        String msg = new String(this.str);
        String errMsg = problem + " at offset " + ofs;
        int totalOfs = 0;
        List<String> lines = Strings.split(msg, '\n', true);
        for (i = 0; i < lines.size(); ++i) {
            String line = lines.get(i);
            if (totalOfs + line.length() >= ofs) {
                errMsg = lines.size() == 1 ? errMsg + " in message:\n" : errMsg + " in " + Numbers.toOrdinalNumeral(i + 1) + " line of message:\n";
                if (i != 0) {
                    errMsg = errMsg + "...\n";
                }
                errMsg = errMsg + '\"' + line + '\"';
                break;
            }
            totalOfs += line.length() + 1;
        }
        int max = 0;
        Collection<Integer> pointers = MessageCompilerException.pointerToName(ofs - totalOfs, target);
        pointers.add(ofs - totalOfs);
        for (Integer pointer : pointers) {
            if (pointer <= max) continue;
            max = pointer;
        }
        StringBuilder pointerStr = new StringBuilder(MessageCompilerException.spaces(max + 2));
        pointers.forEach(x -> pointerStr.setCharAt(x + 1, '^'));
        errMsg = errMsg + '\n' + pointerStr.toString();
        if (i + 1 != lines.size()) {
            errMsg = errMsg + "\n...";
        }
        this.exceptions.add(new MessageCompilerException(target, problem, ofs, errMsg));
    }

    void mergeExceptions(int fromIndex, MessageCompiler other) {
        if (!other.hasErrors()) {
            return;
        }
        for (MessageCompilerException ex : other.exceptions) {
            this.exception(fromIndex + ex.getIndex(), ex.getProblem(), ex.getTarget());
        }
    }

    private static enum HoverParserState {
        NORMAL_MESSAGE,
        HOVER_MESSAGE,
        ACTION;

    }

    private static enum SpecialType {
        HEX("hex"),
        MACRO("macro"),
        LANGUAGE_PATH("language path"),
        BACKREF("back reference"),
        CONDITIONAL("Conditional"),
        ANY("key");

        private final String name;

        private SpecialType(String name) {
            this.name = name;
        }
    }

    private final class ColorBackReference
    extends SpecifierHandler {
        private String variable;
        private String indexSpecifier;

        private ColorBackReference() {
        }

        @Override
        protected void process() {
        }
    }

    private final class TernaryConditional
    extends SpecifierHandler {
        private String condition;
        private String exprIfTrue;
        private String exprIfFalse;

        private TernaryConditional() {
        }

        @Override
        protected void process() {
        }
    }

    private final class SimpleSpecifierHandler
    extends SpecifierHandler {
        protected final StringBuilder text;

        private SimpleSpecifierHandler() {
            this.text = new StringBuilder(10);
        }

        @Override
        protected void process() {
        }
    }

    private abstract class SpecifierHandler {
        protected int i;

        private SpecifierHandler() {
            this.i = MessageCompiler.this.i;
        }

        protected abstract void process();
    }
}

