/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.locale.compiler;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.collections.ArraysKt;
import org.kingdoms.libs.kotlin.collections.CollectionsKt;
import org.kingdoms.libs.kotlin.jvm.functions.Function1;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.libs.kotlin.ranges.IntRange;
import org.kingdoms.libs.kotlin.ranges.RangesKt;
import org.kingdoms.libs.kotlin.text.CharsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0002\b\f\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0013\u0018\u00002\u00020\u0001:\u0003567B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010\u001b\u001a\u00020\u0003H\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u001f\u0010\u001e\u001a\u00020\u001f2\u0014\b\u0004\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\"0!H\u0082\bJ\u0012\u0010#\u001a\u00060$j\u0002`%2\u0006\u0010&\u001a\u00020\u001dJ\u000e\u0010'\u001a\u00020\u001f2\u0006\u0010(\u001a\u00020\u0014J\u0016\u0010)\u001a\u00020\u001d2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003J\u0018\u0010*\u001a\u00020\u00032\u0006\u0010+\u001a\u00020\u001a2\b\b\u0002\u0010,\u001a\u00020\u0003J\u0006\u0010-\u001a\u00020\u001fJ\u0006\u0010.\u001a\u00020\u001dJ\u0006\u0010/\u001a\u00020\"J\u000e\u00100\u001a\u00020\u001f2\u0006\u00101\u001a\u00020\u001aJ\u0006\u00102\u001a\u00020\"J\u0006\u00103\u001a\u00020\u001fJ\u0006\u00104\u001a\u00020\u001fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\n\"\u0004\b\u0010\u0010\u0011R \u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u00068"}, d2={"Lorg/kingdoms/locale/compiler/ConditionalMessageLexer;", "", "start", "", "end", "chars", "", "<init>", "(II[C)V", "getStart", "()I", "getEnd", "getChars", "()[C", "index", "getIndex", "setIndex", "(I)V", "tokens", "", "Lorg/kingdoms/locale/compiler/ConditionalMessageLexer$Token;", "getTokens", "()Ljava/util/List;", "setTokens", "(Ljava/util/List;)V", "currentChar", "", "next", "toString", "", "doWhile", "", "action", "Lorg/kingdoms/libs/kotlin/Function1;", "", "error", "Ljava/lang/RuntimeException;", "Lorg/kingdoms/libs/kotlin/RuntimeException;", "msg", "addToken", "token", "subString", "indexOf", "element", "from", "skipWhitespace", "lexString", "expectStringLiteral", "addCharToken", "char", "hasNext", "lexConditional", "lex", "Token", "StringToken", "CharToken", "core"})
@SourceDebugExtension(value={"SMAP\nConditionalMessageLexer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConditionalMessageLexer.kt\norg/kingdoms/locale/compiler/ConditionalMessageLexer\n*L\n1#1,149:1\n23#1,5:150\n23#1,5:155\n23#1,5:160\n*S KotlinDebug\n*F\n+ 1 ConditionalMessageLexer.kt\norg/kingdoms/locale/compiler/ConditionalMessageLexer\n*L\n55#1:150,5\n63#1:155,5\n115#1:160,5\n*E\n"})
public final class ConditionalMessageLexer {
    private final int start;
    private final int end;
    @NotNull
    private final char[] chars;
    private int index;
    @NotNull
    private List<Token> tokens;

    public ConditionalMessageLexer(int start, int end, @NotNull char[] chars) {
        Intrinsics.checkNotNullParameter((Object)chars, (String)"chars");
        this.start = start;
        this.end = end;
        this.chars = chars;
        this.index = this.start;
        this.tokens = new ArrayList();
    }

    public final int getStart() {
        return this.start;
    }

    public final int getEnd() {
        return this.end;
    }

    @NotNull
    public final char[] getChars() {
        return this.chars;
    }

    public final int getIndex() {
        return this.index;
    }

    public final void setIndex(int n) {
        this.index = n;
    }

    @NotNull
    public final List<Token> getTokens() {
        return this.tokens;
    }

    public final void setTokens(@NotNull List<Token> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.tokens = list;
    }

    private final char currentChar() {
        return this.chars[this.index];
    }

    private final int next() {
        int n = this.index;
        this.index = n + 1;
        return n;
    }

    @NotNull
    public String toString() {
        return "MessageLexer{" + CollectionsKt.joinToString$default((Iterable)this.tokens, (CharSequence)" - ", null, null, (int)0, null, null, (int)62, null) + '}';
    }

    private final void doWhile(Function1<? super Character, Boolean> action) {
        boolean $i$f$doWhile = false;
        do {
            char c;
            if (!((Boolean)action.invoke((Object)Character.valueOf(c = this.currentChar()))).booleanValue()) {
                return;
            }
            this.next();
        } while (this.index < this.chars.length);
    }

    @NotNull
    public final RuntimeException error(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        IllegalArgumentException ex = new IllegalArgumentException(msg);
        throw ex;
    }

    public final void addToken(@NotNull Token token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        this.tokens.add(token);
    }

    @NotNull
    public final String subString(int start, int end) {
        if (end < start) {
            throw new IllegalArgumentException("End is less than than start: " + start + " > " + end);
        }
        return new String(ArraysKt.sliceArray((char[])this.chars, (IntRange)RangesKt.until((int)start, (int)end)));
    }

    public final int indexOf(char element, int from) {
        int n = this.chars.length;
        for (int index = from; index < n; ++index) {
            if (element != this.chars[index]) continue;
            return index;
        }
        return -1;
    }

    public static /* synthetic */ int indexOf$default(ConditionalMessageLexer conditionalMessageLexer, char c, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return conditionalMessageLexer.indexOf(c, n);
    }

    public final void skipWhitespace() {
        ConditionalMessageLexer this_$iv = this;
        boolean $i$f$doWhile = false;
        do {
            char char$iv;
            char it = char$iv = this_$iv.currentChar();
            boolean bl = false;
            if (!CharsKt.isWhitespace((char)it)) break;
            this_$iv.next();
        } while (this_$iv.index < this_$iv.chars.length);
    }

    @NotNull
    public final String lexString() {
        boolean escape = false;
        boolean foundChar = false;
        StringBuilder builder = new StringBuilder();
        ConditionalMessageLexer this_$iv = this;
        boolean $i$f$doWhile = false;
        do {
            boolean bl;
            block11: {
                char char$iv;
                char ch = char$iv = this_$iv.currentChar();
                boolean bl2 = false;
                boolean justEscaped = false;
                switch (ch) {
                    case '\\': {
                        justEscaped = true;
                        break;
                    }
                    case '\"': {
                        if (escape) {
                            builder.append('\"');
                            escape = false;
                            bl = true;
                        } else {
                            foundChar = true;
                            bl = false;
                        }
                        break block11;
                    }
                    default: {
                        builder.append(ch);
                    }
                }
                if (justEscaped) {
                    escape = true;
                } else if (escape) {
                    builder.append('\\');
                    escape = false;
                }
                bl = true;
            }
            if (!bl) break;
            this_$iv.next();
        } while (this_$iv.index < this_$iv.chars.length);
        Serializable serializable = !foundChar ? (Serializable)this.error("Cannot find end of string") : (Serializable)Integer.valueOf(this.next());
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public final boolean expectStringLiteral() {
        this.skipWhitespace();
        char ch = this.currentChar();
        boolean bl = false;
        if (ch != '\"') {
            return false;
        }
        this.next();
        this.addToken(new StringToken(this.lexString()));
        return true;
    }

    public final void addCharToken(char c) {
        this.addToken(new CharToken(c));
    }

    public final boolean hasNext() {
        return this.index < this.end;
    }

    public final void lexConditional() {
        char ch;
        while (true) {
            this.skipWhitespace();
            int startCond = this.index;
            ConditionalMessageLexer this_$iv = this;
            boolean $i$f$doWhile = false;
            do {
                char char$iv;
                char it = char$iv = this_$iv.currentChar();
                boolean bl = false;
                if (!(it != '?')) break;
                this_$iv.next();
            } while (this_$iv.index < this_$iv.chars.length);
            if (!this.hasNext()) {
                this.error("Cannot find end of condition for conditional message");
            }
            this.addToken(new StringToken(this.subString(startCond, this.index)));
            this.addCharToken('?');
            this.next();
            if (!this.expectStringLiteral()) {
                this.error("Expected a string literal for conditional message branch");
            }
            this.skipWhitespace();
            ch = this.currentChar();
            if (ch != ';') break;
            this.addCharToken(ch);
            this.next();
        }
        this.skipWhitespace();
        ch = this.currentChar();
        boolean bl = false;
        if (ch == ':') {
            this.addCharToken(ch);
            this.next();
            if (!this.expectStringLiteral()) {
                this.error("Expected a string literal for conditional message 'else' branch");
            }
        }
        this.skipWhitespace();
        ch = this.currentChar();
        boolean bl2 = false;
        if (ch != '}') {
            this.error("Cannot find end of conditional message");
        }
    }

    public final void lex() {
        this.lexConditional();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lorg/kingdoms/locale/compiler/ConditionalMessageLexer$CharToken;", "Lorg/kingdoms/locale/compiler/ConditionalMessageLexer$Token;", "char", "", "<init>", "(C)V", "getChar", "()C", "toString", "", "core"})
    public static final class CharToken
    extends Token {
        private final char char;

        public CharToken(char c) {
            this.char = c;
        }

        public final char getChar() {
            return this.char;
        }

        @NotNull
        public String toString() {
            return "CharToken{" + this.char + '}';
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\t"}, d2={"Lorg/kingdoms/locale/compiler/ConditionalMessageLexer$StringToken;", "Lorg/kingdoms/locale/compiler/ConditionalMessageLexer$Token;", "string", "", "<init>", "(Ljava/lang/String;)V", "getString", "()Ljava/lang/String;", "toString", "core"})
    public static final class StringToken
    extends Token {
        @NotNull
        private final String string;

        public StringToken(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            this.string = string;
        }

        @NotNull
        public final String getString() {
            return this.string;
        }

        @NotNull
        public String toString() {
            return "StringToken{" + this.string + '}';
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/kingdoms/locale/compiler/ConditionalMessageLexer$Token;", "", "<init>", "()V", "core"})
    public static abstract class Token {
    }
}

