/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.locale;

import com.google.common.base.Strings;
import java.nio.file.Path;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.plugin.Plugin;
import org.kingdoms.gui.GUIConfig;
import org.kingdoms.gui.KingdomsGUI;
import org.kingdoms.gui.objects.GUIObject;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;
import org.kingdoms.libs.jetbrains.annotations.Contract;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.Language;
import org.kingdoms.locale.LanguageEntry;
import org.kingdoms.locale.LanguageManager;
import org.kingdoms.locale.NoDefaultDefinedMessenger;
import org.kingdoms.locale.compiler.MessageObject;
import org.kingdoms.locale.messenger.DefinedMessenger;
import org.kingdoms.locale.placeholders.StandardKingdomsPlaceholder;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.locale.provider.MessageProvider;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.utils.config.adapters.YamlFiledDefaults;
import org.kingdoms.utils.config.adapters.YamlResource;
import org.kingdoms.utils.config.adapters.YamlWithDefaults;
import org.kingdoms.utils.config.importer.YamlGUIImporter;
import org.kingdoms.utils.config.importer.YamlImporter;
import org.kingdoms.utils.internal.nonnull.NonNullMap;

public enum SupportedLanguage implements Language
{
    EN(Locale.ENGLISH, -8, "English", "US", "UK"),
    HU(2, "Magyar", "Magyar nyelv", "Hungarian"),
    RU(3, "\u0420\u0443\u0441\u0441\u043a\u0438\u0439", "Russian", "P\u0443\u0441\u0441\u043a\u0438\u0439 \u044f\u0437\u044b\u043a", "Russia"),
    ES(1, "Espa\u00f1ol", "Spanish", "Espanol", "Castilian", "Castellano"),
    DE(Locale.GERMAN, 1, "Deutsch", "German", "Schwiizerdutsch", "\u00d6sterreichisches", "bar_AT", "gsw_CH", "deu_DE"),
    PL(1, "Polski", "Polish", "Poland"),
    TR(3, "T\u00fcrk\u00e7e", "T\u00fcrk dili", "Turkish", "Turkey"),
    IT(2, "Italiano", "Italian", "Italiana"),
    ZH(Locale.CHINESE, 8, "\u6c49\u8bed", "\u6f22\u8a9e", "\u4e2d\u6587", "Zh\u014dngw\u00e9n", "Chinese", "China"),
    CS(2, "\u010ce\u0161tina", "Bohemian", "Czech"),
    UK(2, "\u0443\u043a\u0440\u0430\u0457\u043d\u0441\u044c\u043a\u0430 \u043c\u043e\u0432\u0430", "ukrainska mova", "Ukranian", "Ukraine"),
    PT(-3, "Portugu\u00eas", "Portuguese", "Portuguesa", "Brazilian");

    public static final SupportedLanguage[] VALUES;
    public static final String MACROS_ENTRY = "variables";
    private final String nativeName;
    private final Locale locale;
    private final TimeZone timeZone;
    private YamlWithDefaults adapter;
    private Map<LanguageEntry, MessageProvider> messages;
    private Map<String, GUIObject> guis;
    private String installedCommitSHA;
    private final YamlImporter yamlImporter = new YamlGUIImporter(this);

    private SupportedLanguage(String ... names) {
        this(null, 0, names);
    }

    private SupportedLanguage(int hoursOffset, String ... names) {
        this(null, hoursOffset, names);
    }

    private SupportedLanguage(Locale locale, int hoursOffset, String ... names) {
        this.locale = locale == null ? new Locale(this.name().toLowerCase(Locale.ENGLISH)) : locale;
        TimeZone timeZone = this.timeZone = hoursOffset == 0 ? TimeZone.getDefault() : TimeZone.getTimeZone(ZoneOffset.ofOffset("UTC", ZoneOffset.ofHours(hoursOffset)));
        if (this.name().equals("EN")) {
            this.initialize();
        }
        this.nativeName = names[0];
        String lowerName = this.getLowerCaseName();
        NameContainer.NAMES.put(lowerName, this);
        Stream.of(names).forEach(x -> NameContainer.NAMES.put(x.toLowerCase(), this));
    }

    public void initialize() {
        if (this.name().equals("EN")) {
            this.installedCommitSHA = Kingdoms.get().getCompileCommitSHA();
        }
        if (this.messages == null) {
            this.messages = new NonNullMap<LanguageEntry, MessageProvider>(KingdomsLang.VALUES.length);
        }
        if (this.guis == null) {
            this.guis = new NonNullMap<String, GUIObject>(KingdomsGUI.SIZE);
        }
        if (this.adapter == null) {
            if (this.name().equals("EN")) {
                this.adapter = new YamlResource((Plugin)Kingdoms.get(), this.getMainLanguageFile().toFile(), null);
                this.installedCommitSHA = Kingdoms.get().getCompileCommitSHA();
            } else {
                this.adapter = new YamlFiledDefaults(this.getMainLanguageFile().toFile(), this.getRepoPath().resolve(this.getLowerCaseName() + ".yml").toFile());
            }
        }
    }

    @Override
    public YamlImporter getYamlImporter() {
        return this.yamlImporter;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    @NotNull
    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public static List<SupportedLanguage> getInstalled() {
        return Arrays.stream(VALUES).filter(SupportedLanguage::isInstalled).collect(Collectors.toList());
    }

    public static Collection<String> getRegisteredGUINames() {
        return Language.getDefault().getGUIs().keySet();
    }

    public Path getRepoPath() {
        return LanguageManager.LANGUAGES_REPO_FOLDER.resolve(this.getLowerCaseName());
    }

    @Override
    public void uninitialize() {
        if (this == EN) {
            throw new IllegalStateException("Cannot uninstall default English translation");
        }
        this.installedCommitSHA = null;
        this.messages = null;
        this.guis = null;
        this.adapter = null;
    }

    @Override
    public boolean isInstalled() {
        return this.installedCommitSHA != null;
    }

    @Override
    public boolean isLoaded() {
        return this.isInstalled() && (!this.messages.isEmpty() || !this.guis.isEmpty());
    }

    public Path getMainLanguageFile() {
        return Kingdoms.getPath("languages").resolve(this.getLowerCaseName() + ".yml");
    }

    public Path getGUIFolder() {
        return GUIConfig.getFolder().resolve(this.getLowerCaseName());
    }

    @Override
    public @Nullable GUIObject getGUIOrDefault(String name, boolean optional) {
        GUIObject raw = this.getGUI(name);
        if (!optional && this == EN && raw == null) {
            throw new IllegalStateException("GUI named " + name + " is null for English");
        }
        return raw != null ? raw : EN.getGUI(name);
    }

    public void addMessage(DefinedMessenger messenger, MessageProvider provider) {
        this.messages.put(messenger.getLanguageEntry(), provider);
    }

    @Override
    public Map<LanguageEntry, MessageProvider> getMessages() {
        return this.messages;
    }

    @Override
    public GUIObject getGUI(String name) {
        return this.guis != null ? this.guis.get(name) : null;
    }

    @Override
    public Map<String, GUIObject> getGUIs() {
        this.ensureInstalled();
        return this.guis;
    }

    public void ensureInstalled() {
        if (!this.isInstalled()) {
            throw new IllegalStateException("This language isn't marked as installed: " + this.name());
        }
    }

    public String getInstalledCommitSHA() {
        return this.installedCommitSHA;
    }

    public void setInstalledCommitSHA(String installedCommitSHA) {
        this.installedCommitSHA = installedCommitSHA;
    }

    @Override
    public String getLowerCaseName() {
        return org.kingdoms.utils.string.Strings.toLatinLowerCase(this.name());
    }

    @Override
    @NotNull
    public String asDataString() {
        return this.name();
    }

    public YamlWithDefaults getAdapter() {
        this.ensureInstalled();
        return this.adapter;
    }

    @Override
    public String getNativeName() {
        return this.nativeName;
    }

    public static SupportedLanguage fromName(@Nullable String name) {
        if (Strings.isNullOrEmpty((String)name)) {
            return null;
        }
        int iso3 = name.indexOf(95);
        if (iso3 != -1) {
            name = name.substring(0, iso3);
        }
        return (SupportedLanguage)NameContainer.NAMES.get(name.toLowerCase());
    }

    @Override
    @Contract(value="_, true -> !null")
    @org.kingdoms.libs.jetbrains.annotations.Nullable
    public MessageProvider getMessage(LanguageEntry lang, boolean error) {
        MessageProvider current;
        MessageProvider messageProvider = current = this.messages == null ? null : this.messages.get(lang);
        if (this == EN && current == null) {
            if (error) {
                throw new NoDefaultDefinedMessenger("Language entry " + lang + " is null for English");
            }
            return null;
        }
        return current == null ? EN.getMessage(lang, error) : current;
    }

    @Override
    public MessageObject getMessage(String ... path) {
        MessageProvider current;
        LanguageEntry entry = new LanguageEntry(path);
        MessageProvider messageProvider = current = this.messages == null ? null : this.messages.get(entry);
        if (current == null) {
            current = SupportedLanguage.EN.messages.get(entry);
        }
        return current.getMessage();
    }

    @Override
    public MessageObject getVariableRaw(String name) {
        return this.getVariable(null, name, true);
    }

    @Override
    public MessageObject getVariable(MessagePlaceholderProvider settings, String name, boolean raw) {
        MessageProvider current;
        LanguageEntry entry = new LanguageEntry(new String[]{MACROS_ENTRY, name});
        MessageProvider messageProvider = current = this.messages == null ? null : this.messages.get(entry);
        if (raw) {
            return current == null ? null : current.getMessage();
        }
        if (current == null) {
            current = SupportedLanguage.EN.messages.get(entry);
        }
        if (current != null) {
            return current.getMessage();
        }
        return StandardKingdomsPlaceholder.getMacro(name, settings);
    }

    static {
        VALUES = SupportedLanguage.values();
    }

    private static final class NameContainer {
        private static final Map<String, SupportedLanguage> NAMES = new HashMap<String, SupportedLanguage>(30);

        private NameContainer() {
        }
    }
}

