/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.locale;

import java.util.Arrays;
import java.util.Collection;
import org.bukkit.command.CommandSender;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.locale.compiler.builders.MessageObjectBuilder;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.locale.provider.MessageContextProvider;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ+\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0016\u0010\u0011\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00130\u0012\"\u0004\u0018\u00010\u0013\u00a2\u0006\u0002\u0010\u0014J\u0018\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0013J+\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0016\u0010\u0011\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00130\u0012\"\u0004\u0018\u00010\u0013\u00a2\u0006\u0002\u0010\u0014J3\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\u0016\u0010\u0011\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00130\u0012\"\u0004\u0018\u00010\u0013\u00a2\u0006\u0002\u0010\u001bR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001c"}, d2={"Lorg/kingdoms/locale/MultiMessenger;", "Lorg/kingdoms/locale/provider/MessageContextProvider;", "receivers", "", "Lorg/bukkit/command/CommandSender;", "messageContext", "Lorg/kingdoms/locale/placeholders/context/MessagePlaceholderProvider;", "<init>", "(Ljava/util/Collection;Lorg/kingdoms/locale/placeholders/context/MessagePlaceholderProvider;)V", "getReceivers", "()Ljava/util/Collection;", "getMessageContext", "()Lorg/kingdoms/locale/placeholders/context/MessagePlaceholderProvider;", "sendError", "", "lang", "Lorg/kingdoms/locale/messenger/Messenger;", "edits", "", "", "(Lorg/kingdoms/locale/messenger/Messenger;[Ljava/lang/Object;)V", "var", "variable", "", "replacement", "sendMessage", "sender", "(Lorg/bukkit/command/CommandSender;Lorg/kingdoms/locale/messenger/Messenger;[Ljava/lang/Object;)V", "core"})
@SourceDebugExtension(value={"SMAP\nMultiMessenger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultiMessenger.kt\norg/kingdoms/locale/MultiMessenger\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,36:1\n1863#2,2:37\n1863#2,2:39\n*S KotlinDebug\n*F\n+ 1 MultiMessenger.kt\norg/kingdoms/locale/MultiMessenger\n*L\n15#1:37,2\n29#1:39,2\n*E\n"})
public final class MultiMessenger
implements MessageContextProvider {
    @NotNull
    private final Collection<CommandSender> receivers;
    @NotNull
    private final MessagePlaceholderProvider messageContext;

    public MultiMessenger(@NotNull Collection<? extends CommandSender> receivers, @NotNull MessagePlaceholderProvider messageContext) {
        Intrinsics.checkNotNullParameter(receivers, (String)"receivers");
        Intrinsics.checkNotNullParameter((Object)messageContext, (String)"messageContext");
        this.receivers = receivers;
        this.messageContext = messageContext;
    }

    @NotNull
    public final Collection<CommandSender> getReceivers() {
        return this.receivers;
    }

    @Override
    @NotNull
    public MessagePlaceholderProvider getMessageContext() {
        return this.messageContext;
    }

    public final void sendError(@NotNull Messenger lang, Object ... edits) {
        Intrinsics.checkNotNullParameter((Object)lang, (String)"lang");
        Intrinsics.checkNotNullParameter((Object)edits, (String)"edits");
        if (!(edits.length == 0)) {
            this.getMessageContext().placeholders(Arrays.copyOf(edits, edits.length));
        }
        Iterable $this$forEach$iv = this.receivers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CommandSender it = (CommandSender)element$iv;
            boolean bl = false;
            lang.sendError(it, this.getMessageContext());
        }
    }

    @NotNull
    public final MultiMessenger var(@NotNull String variable, @Nullable Object replacement) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        MessagePlaceholderProvider messagePlaceholderProvider = !(replacement instanceof MessageObjectBuilder) && !(replacement instanceof Messenger) ? this.getMessageContext().parse(variable, replacement) : this.getMessageContext().raw(variable, replacement);
        return this;
    }

    public final void sendMessage(@NotNull Messenger lang, Object ... edits) {
        Intrinsics.checkNotNullParameter((Object)lang, (String)"lang");
        Intrinsics.checkNotNullParameter((Object)edits, (String)"edits");
        if (!(edits.length == 0)) {
            this.getMessageContext().placeholders(Arrays.copyOf(edits, edits.length));
        }
        Iterable $this$forEach$iv = this.receivers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CommandSender it = (CommandSender)element$iv;
            boolean bl = false;
            this.sendMessage(it, lang, new Object[0]);
        }
    }

    public final void sendMessage(@NotNull CommandSender sender, @NotNull Messenger lang, Object ... edits) {
        Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
        Intrinsics.checkNotNullParameter((Object)lang, (String)"lang");
        Intrinsics.checkNotNullParameter((Object)edits, (String)"edits");
        if (!(edits.length == 0)) {
            this.getMessageContext().placeholders(Arrays.copyOf(edits, edits.length));
        }
        lang.sendMessage(sender, this.getMessageContext());
    }
}

